/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\u00020\u0006*\u00020\u000bH\u0002J\f\u0010\u000e\u001a\u00020\u0006*\u00020\rH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/squareup/wire/schema/ClaimedPaths;", "", "()V", "paths", "", "Lokio/Path;", "", "claim", "", "path", "service", "Lcom/squareup/wire/schema/Service;", "type", "Lcom/squareup/wire/schema/Type;", "asErrorMessage", "wire-schema"})
public final class ClaimedPaths {
    @NotNull
    private final Map<Path, String> paths = new LinkedHashMap();

    public final void claim(@NotNull Path path, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String errorMessage = this.asErrorMessage(type);
        String existingEntry = this.paths.get(path);
        if (!(existingEntry == null)) {
            boolean bl = false;
            String string = "Same file " + path + " is getting generated by different messages:\n  " + existingEntry + "\n  " + this.asErrorMessage(type);
            throw new IllegalStateException(string.toString());
        }
        this.paths.put(path, errorMessage);
    }

    public final void claim(@NotNull Path path, @NotNull Service service) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        String errorMessage = this.asErrorMessage(service);
        String existingEntry = this.paths.get(path);
        if (!(existingEntry == null)) {
            boolean bl = false;
            String string = "Same file " + path + " is getting generated by different services:\n  " + existingEntry + "\n  " + this.asErrorMessage(service);
            throw new IllegalStateException(string.toString());
        }
        this.paths.put(path, errorMessage);
    }

    private final String asErrorMessage(Type $this$asErrorMessage) {
        return $this$asErrorMessage.getType().getSimpleName() + " at " + $this$asErrorMessage.getLocation();
    }

    private final String asErrorMessage(Service $this$asErrorMessage) {
        return $this$asErrorMessage.type().getSimpleName() + " at " + $this$asErrorMessage.location();
    }
}

