/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Pruner;
import com.squareup.wire.schema.PruningRules;
import com.squareup.wire.schema.SchemaProtoAdapterFactory;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\rJ\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u000bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020\rJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u000bJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\"2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010#\u001a\u00020 J\u0010\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u000bJ\u0010\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\rJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/squareup/wire/schema/Schema;", "", "protoFiles", "", "Lcom/squareup/wire/schema/ProtoFile;", "(Ljava/lang/Iterable;)V", "", "getProtoFiles", "()Ljava/util/List;", "protoFilesIndex", "", "Lcom/squareup/wire/schema/ProtoType;", "servicesIndex", "", "Lcom/squareup/wire/schema/Service;", "types", "", "getTypes", "()Ljava/util/Set;", "typesIndex", "Lcom/squareup/wire/schema/Type;", "getField", "Lcom/squareup/wire/schema/Field;", "protoMember", "Lcom/squareup/wire/schema/ProtoMember;", "protoType", "memberName", "typeName", "getService", "name", "getType", "isExtensionField", "", "protoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "includeUnknown", "protoFile", "path", "prune", "pruningRules", "Lcom/squareup/wire/schema/PruningRules;", "Companion", "wire-schema"})
public final class Schema {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ProtoFile> protoFiles;
    @NotNull
    private final Map<ProtoType, ProtoFile> protoFilesIndex;
    @NotNull
    private final Map<String, Type> typesIndex;
    @NotNull
    private final Map<String, Service> servicesIndex;

    public Schema(@NotNull Iterable<ProtoFile> protoFiles) {
        Intrinsics.checkNotNullParameter(protoFiles, (String)"protoFiles");
        Iterable<ProtoFile> $this$sortedBy$iv = protoFiles;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        this.protoFiles = CollectionsKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ProtoFile it = (ProtoFile)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getLocation().getPath());
                it = (ProtoFile)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getLocation().getPath();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        boolean bl2 = false;
        Map index = new LinkedHashMap();
        this.typesIndex = Schema.Companion.buildTypesIndex(protoFiles, index);
        this.servicesIndex = Schema.Companion.buildServicesIndex(protoFiles, index);
        this.protoFilesIndex = index;
    }

    @NotNull
    public final List<ProtoFile> getProtoFiles() {
        return this.protoFiles;
    }

    @NotNull
    public final Set<ProtoType> getTypes() {
        return this.protoFilesIndex.keySet();
    }

    @Nullable
    public final ProtoFile protoFile(@NotNull String path) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$firstOrNull$iv = this.protoFiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ProtoFile it = (ProtoFile)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLocation().getPath(), (Object)path)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final ProtoFile protoFile(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        return this.protoFilesIndex.get(protoType);
    }

    @NotNull
    public final Schema prune(@NotNull PruningRules pruningRules) {
        Intrinsics.checkNotNullParameter((Object)pruningRules, (String)"pruningRules");
        return new Pruner(this, pruningRules).prune();
    }

    @Nullable
    public final Service getService(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.servicesIndex.get(name);
    }

    @Nullable
    public final Service getService(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        return this.getService(protoType.toString());
    }

    @Nullable
    public final Type getType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.typesIndex.get(name);
    }

    @Nullable
    public final Type getType(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        return this.getType(protoType.toString());
    }

    @Nullable
    public final Field getField(@NotNull ProtoMember protoMember) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)protoMember, (String)"protoMember");
        Type type = this.getType(protoMember.getType());
        Object object2 = object = type instanceof MessageType ? (MessageType)type : null;
        if (object == null) {
            return null;
        }
        Object type2 = object;
        return (object = ((MessageType)type2).field(protoMember.getMember())) == null ? ((MessageType)type2).extensionField(protoMember.getMember()) : object;
    }

    @Nullable
    public final Field getField(@NotNull String typeName, @NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        return this.getField(ProtoType.Companion.get(typeName), memberName);
    }

    @Nullable
    public final Field getField(@NotNull ProtoType protoType, @NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        return this.getField(ProtoMember.Companion.get(protoType, memberName));
    }

    @NotNull
    public final ProtoAdapter<Object> protoAdapter(@NotNull String typeName, boolean includeUnknown) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Type type = this.getType(typeName);
        boolean bl = false;
        boolean bl2 = false;
        if (type == null) {
            boolean bl3 = false;
            String string = Intrinsics.stringPlus((String)"unexpected type ", (Object)typeName);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Type type2 = type;
        return new SchemaProtoAdapterFactory(this, includeUnknown).get(type2.getType());
    }

    public final boolean isExtensionField(@NotNull ProtoMember protoMember) {
        Intrinsics.checkNotNullParameter((Object)protoMember, (String)"protoMember");
        Type type = this.getType(protoMember.getType());
        return type instanceof MessageType && ((MessageType)type).extensionField(protoMember.getMember()) != null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bH\u0002J6\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/squareup/wire/schema/Schema$Companion;", "", "()V", "buildServicesIndex", "", "", "Lcom/squareup/wire/schema/Service;", "protoFiles", "", "Lcom/squareup/wire/schema/ProtoFile;", "protoFilesIndex", "", "Lcom/squareup/wire/schema/ProtoType;", "buildTypesIndex", "Lcom/squareup/wire/schema/Type;", "wire-schema"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, Type> buildTypesIndex(Iterable<ProtoFile> protoFiles, Map<ProtoType, ProtoFile> protoFilesIndex) {
            boolean bl = false;
            Map typesByName = new LinkedHashMap();
            for (ProtoFile protoFile : protoFiles) {
                for (Type type : protoFile.getTypes()) {
                    com.squareup.wire.schema.Schema$Companion.buildTypesIndex$index(protoFilesIndex, typesByName, type, protoFile);
                }
            }
            return typesByName;
        }

        private final Map<String, Service> buildServicesIndex(Iterable<ProtoFile> protoFiles, Map<ProtoType, ProtoFile> protoFilesIndex) {
            boolean bl = false;
            Map<ProtoType, ProtoFile> result = new LinkedHashMap();
            for (ProtoFile protoFile : protoFiles) {
                for (Service service : protoFile.getServices()) {
                    Map<ProtoType, ProtoFile> map = result;
                    Object object = service.type().toString();
                    boolean bl2 = false;
                    map.put((ProtoType)object, (ProtoFile)((Object)service));
                    map = protoFilesIndex;
                    object = service.type();
                    bl2 = false;
                    map.put((ProtoType)object, protoFile);
                }
            }
            return result;
        }

        private static final void buildTypesIndex$index(Map<ProtoType, ProtoFile> $protoFilesIndex, Map<String, Type> typesByName, Type type, ProtoFile protoFile) {
            ProtoType protoType = type.getType();
            Object object = $protoFilesIndex;
            boolean bl = false;
            Map<ProtoType, ProtoFile> map = object;
            boolean bl2 = false;
            if (!map.containsKey(protoType)) {
                object = $protoFilesIndex;
                bl = false;
                object.put((ProtoType)protoType, (ProtoFile)protoFile);
            }
            object = typesByName;
            String string = protoType.toString();
            boolean bl3 = false;
            object.put((Object)string, (Object)type);
            for (Type nested : type.getNestedTypes()) {
                com.squareup.wire.schema.Schema$Companion.buildTypesIndex$index($protoFilesIndex, typesByName, nested, protoFile);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

