/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.CycleChecker;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.ErrorCollector;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.FileLinker;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Reserved;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SyntaxRules;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.UtilJVMKt;
import com.squareup.wire.schema.internal.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB\u0017\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u0000\u0012\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u001bJ\u0013\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140\u000eH\u0000\u00a2\u0006\u0002\b&J\u0018\u0010'\u001a\u0004\u0018\u00010\u001e2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u0013J\u0010\u0010*\u001a\u0004\u0018\u00010\u001b2\u0006\u0010#\u001a\u00020 J\u0015\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u0004\u0018\u00010\u001b2\u0006\u0010#\u001a\u00020 J\u0014\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020302J\b\u00104\u001a\u0004\u0018\u00010\u0013J\u000e\u00105\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u001eJ/\u00106\u001a\u0004\u0018\u0001H7\"\u0004\b\u0000\u001072\u0006\u00108\u001a\u00020\u00132\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H70:\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020\u0013H\u0002J\u000e\u0010=\u001a\u00020 2\u0006\u00108\u001a\u00020\u0013J\u000e\u0010>\u001a\u00020 2\u0006\u00108\u001a\u00020\u0013J\u0018\u0010>\u001a\u00020 2\u0006\u00108\u001a\u00020\u00132\u0006\u0010?\u001a\u00020\u0007H\u0002J\u0014\u0010@\u001a\u00020\"2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001b02J*\u0010B\u001a\u00020\"2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001e022\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u000e2\u0006\u0010F\u001a\u00020GJ\u0016\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0013J\u0016\u0010L\u001a\u00020\"2\u0006\u0010I\u001a\u00020J2\u0006\u0010$\u001a\u00020 J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u0001R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0016j\b\u0012\u0004\u0012\u00020\u0014`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/squareup/wire/schema/Linker;", "", "loader", "Lcom/squareup/wire/schema/Loader;", "errors", "Lcom/squareup/wire/schema/ErrorCollector;", "permitPackageCycles", "", "loadExhaustively", "(Lcom/squareup/wire/schema/Loader;Lcom/squareup/wire/schema/ErrorCollector;ZZ)V", "enclosing", "additionalContext", "(Lcom/squareup/wire/schema/Linker;Ljava/lang/Object;)V", "contextStack", "", "getErrors", "()Lcom/squareup/wire/schema/ErrorCollector;", "fileLinkers", "", "", "Lcom/squareup/wire/schema/FileLinker;", "fileOptionsQueue", "Ljava/util/Queue;", "Lcom/squareup/wire/schema/internal/MutableQueue;", "getLoadExhaustively", "()Z", "protoTypeNames", "Lcom/squareup/wire/schema/Type;", "requestedFields", "", "Lcom/squareup/wire/schema/Field;", "requestedTypes", "Lcom/squareup/wire/schema/ProtoType;", "addType", "", "protoType", "type", "contextImportedTypes", "contextImportedTypes$wire_schema", "dereference", "self", "field", "get", "getFileLinker", "path", "getFileLinker$wire_schema", "getForOptions", "link", "Lcom/squareup/wire/schema/Schema;", "sourceProtoFiles", "", "Lcom/squareup/wire/schema/ProtoFile;", "packageName", "request", "resolve", "T", "name", "map", "", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Object;", "resolveContext", "resolveMessageType", "resolveType", "messageOnly", "validateEnumConstantNameUniqueness", "nestedTypes", "validateFields", "fields", "reserveds", "Lcom/squareup/wire/schema/Reserved;", "syntaxRules", "Lcom/squareup/wire/schema/SyntaxRules;", "validateImportForPath", "location", "Lcom/squareup/wire/schema/Location;", "requiredImport", "validateImportForType", "withContext", "context", "wire-schema"})
public final class Linker {
    @NotNull
    private final Loader loader;
    @NotNull
    private final Map<String, FileLinker> fileLinkers;
    @NotNull
    private final Queue<FileLinker> fileOptionsQueue;
    @NotNull
    private final Map<String, Type> protoTypeNames;
    @NotNull
    private final List<Object> contextStack;
    @NotNull
    private final Set<ProtoType> requestedTypes;
    @NotNull
    private final Set<Field> requestedFields;
    private final boolean permitPackageCycles;
    private final boolean loadExhaustively;
    @NotNull
    private final ErrorCollector errors;

    public final boolean getLoadExhaustively() {
        return this.loadExhaustively;
    }

    @NotNull
    public final ErrorCollector getErrors() {
        return this.errors;
    }

    public Linker(@NotNull Loader loader, @NotNull ErrorCollector errors, boolean permitPackageCycles, boolean loadExhaustively) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        this.loader = loader;
        boolean bl = false;
        this.fileLinkers = new LinkedHashMap();
        this.fileOptionsQueue = UtilJVMKt.mutableQueueOf();
        bl = false;
        this.protoTypeNames = new LinkedHashMap();
        this.contextStack = CollectionsKt.emptyList();
        bl = false;
        this.requestedTypes = new LinkedHashSet();
        bl = false;
        this.requestedFields = new LinkedHashSet();
        this.errors = errors;
        this.permitPackageCycles = permitPackageCycles;
        this.loadExhaustively = loadExhaustively;
    }

    private Linker(Linker enclosing, Object additionalContext) {
        this.loader = enclosing.loader;
        this.fileLinkers = enclosing.fileLinkers;
        this.fileOptionsQueue = enclosing.fileOptionsQueue;
        this.protoTypeNames = enclosing.protoTypeNames;
        this.contextStack = CollectionsKt.plus((Collection)enclosing.contextStack, (Object)additionalContext);
        this.requestedTypes = enclosing.requestedTypes;
        this.requestedFields = enclosing.requestedFields;
        this.errors = enclosing.errors.at(additionalContext);
        this.permitPackageCycles = false;
        this.loadExhaustively = enclosing.loadExhaustively;
    }

    @NotNull
    public final FileLinker getFileLinker$wire_schema(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileLinker existing = this.fileLinkers.get(path);
        if (existing != null) {
            return existing;
        }
        ProtoFile protoFile = this.loader.withErrors(this.errors).load(path);
        FileLinker result = new FileLinker(protoFile, this.withContext(protoFile));
        Object object = this.fileLinkers;
        boolean bl = false;
        object.put((String)path, (FileLinker)result);
        object = this;
        Collection collection = ((Linker)object).fileOptionsQueue;
        boolean bl2 = false;
        collection.add(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Schema link(@NotNull Iterable<ProtoFile> sourceProtoFiles) {
        Object queue;
        Intrinsics.checkNotNullParameter(sourceProtoFiles, (String)"sourceProtoFiles");
        boolean bl = false;
        List sourceFiles = new ArrayList();
        Collection collection = sourceFiles;
        FileLinker fileLinker = this.getFileLinker$wire_schema("google/protobuf/descriptor.proto");
        boolean bl2 = false;
        collection.add(fileLinker);
        for (ProtoFile protoFile : sourceProtoFiles) {
            FileLinker fileLinker2 = new FileLinker(protoFile, this.withContext(protoFile));
            Object object = this.fileLinkers;
            String string = protoFile.getLocation().getPath();
            boolean bl3 = false;
            object.put((String)string, (FileLinker)fileLinker2);
            object = sourceFiles;
            boolean bl4 = false;
            object.add(fileLinker2);
        }
        if (this.loadExhaustively) {
            queue = UtilJVMKt.mutableQueueOf();
            Collection collection2 = (Collection)queue;
            Iterator fileLinker2 = this.fileLinkers.values();
            boolean bl5 = false;
            CollectionsKt.addAll((Collection)collection2, (Iterable)((Object)fileLinker2));
            while ((fileLinker2 = (FileLinker)queue.poll()) != null) {
                Iterator iterator = fileLinker2;
                fileLinker2 = CollectionsKt.plus((Collection)((FileLinker)((Object)iterator)).getProtoFile().getImports(), (Iterable)((FileLinker)((Object)iterator)).getProtoFile().getPublicImports()).iterator();
                while (fileLinker2.hasNext()) {
                    String importPath = (String)fileLinker2.next();
                    Map<String, FileLinker> map = this.fileLinkers;
                    boolean bl6 = false;
                    Map<String, FileLinker> map2 = map;
                    boolean bl7 = false;
                    if (map2.containsKey(importPath)) continue;
                    FileLinker imported = this.withContext(((FileLinker)((Object)iterator)).getProtoFile()).getFileLinker$wire_schema(importPath);
                    Collection collection3 = sourceFiles;
                    boolean bl8 = false;
                    collection3.add(imported);
                    collection3 = (Collection)queue;
                    bl8 = false;
                    collection3.add(imported);
                }
            }
        }
        for (FileLinker fileLinker2 : sourceFiles) {
            fileLinker2.requireTypesRegistered();
        }
        for (FileLinker fileLinker3 : sourceFiles) {
            fileLinker3.requireExtensionsLinked();
        }
        for (FileLinker fileLinker4 : sourceFiles) {
            fileLinker4.requireImportedExtensionsRegistered();
        }
        for (FileLinker fileLinker5 : sourceFiles) {
            fileLinker5.linkMembers();
        }
        for (FileLinker fileLinker6 : sourceFiles) {
            SyntaxRules syntaxRules = SyntaxRules.Companion.get(fileLinker6.getProtoFile().getSyntax());
            fileLinker6.linkOptions(syntaxRules, true);
        }
        for (FileLinker fileLinker7 : sourceFiles) {
            fileLinker7.requireImportedExtensionOptionsLinked(false);
        }
        while (true) {
            Object fileLinker4;
            queue = this.fileOptionsQueue;
            boolean bl9 = false;
            if (!(!queue.isEmpty())) break;
            Intrinsics.checkNotNull((Object)this.fileOptionsQueue.poll());
            ((FileLinker)fileLinker4).requireFileOptionsLinked(false);
        }
        for (FileLinker fileLinker8 : sourceFiles) {
            SyntaxRules syntaxRules = SyntaxRules.Companion.get(fileLinker8.getProtoFile().getSyntax());
            fileLinker8.validate(syntaxRules);
        }
        CycleChecker cycleChecker = new CycleChecker(this.fileLinkers, this.errors);
        cycleChecker.checkForImportCycles();
        if (!this.permitPackageCycles) {
            cycleChecker.checkForPackageCycles();
        }
        this.errors.throwIfNonEmpty();
        bl2 = false;
        List list = new ArrayList();
        for (FileLinker fileLinker7 : this.fileLinkers.values()) {
            boolean anyFieldIsUsed;
            boolean anyTypeIsUsed;
            block26: {
                boolean bl10;
                void $this$any$iv;
                boolean bl11;
                block24: {
                    void $this$any$iv2;
                    if (sourceFiles.contains(fileLinker7)) {
                        list.add(fileLinker7.getProtoFile());
                        continue;
                    }
                    Iterable iterable = fileLinker7.getProtoFile().typesAndNestedTypes();
                    boolean $i$f$any = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl11 = false;
                    } else {
                        for (Object element$iv : $this$any$iv2) {
                            Type type = (Type)element$iv;
                            boolean bl112 = false;
                            if (!this.requestedTypes.contains(type.getType())) continue;
                            bl11 = true;
                            break block24;
                        }
                        bl11 = false;
                    }
                }
                anyTypeIsUsed = bl11;
                Iterable $i$f$any = fileLinker7.getProtoFile().getExtendList();
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl10 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl12;
                        block25: {
                            Extend extend = (Extend)element$iv;
                            boolean bl13 = false;
                            Iterable $this$any$iv3 = extend.getFields();
                            boolean $i$f$any3 = false;
                            if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                bl12 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv3) {
                                    Field it = (Field)element$iv2;
                                    boolean bl14 = false;
                                    if (!this.requestedFields.contains(it)) continue;
                                    bl12 = true;
                                    break block25;
                                }
                                bl12 = false;
                            }
                        }
                        if (!bl12) continue;
                        bl10 = true;
                        break block26;
                    }
                    bl10 = anyFieldIsUsed = false;
                }
            }
            if (!anyTypeIsUsed && !anyFieldIsUsed) continue;
            list.add(fileLinker7.getProtoFile().retainLinked(CollectionsKt.toSet((Iterable)this.requestedTypes), this.requestedFields));
        }
        return new Schema(list);
    }

    @NotNull
    public final ProtoType resolveType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.resolveType(name, false);
    }

    @NotNull
    public final ProtoType resolveMessageType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.resolveType(name, true);
    }

    private final ProtoType resolveType(String name, boolean messageOnly) {
        Object object;
        ProtoType type = ProtoType.Companion.get(name);
        if (type.isScalar()) {
            if (messageOnly) {
                Linker linker = this;
                linker.errors.plusAssign(Intrinsics.stringPlus((String)"expected a message but was ", (Object)name));
            }
            return type;
        }
        if (type.isMap()) {
            if (messageOnly) {
                Linker linker = this;
                linker.errors.plusAssign(Intrinsics.stringPlus((String)"expected a message but was ", (Object)name));
            }
            ProtoType keyType = this.resolveType(String.valueOf(type.getKeyType()), false);
            ProtoType valueType = this.resolveType(String.valueOf(type.getValueType()), false);
            return ProtoType.Companion.get(keyType, valueType, name);
        }
        Type resolved = this.resolve(name, this.protoTypeNames);
        if (resolved == null) {
            for (FileLinker fileLinker : this.contextImportedTypes$wire_schema()) {
                fileLinker.requireTypesRegistered();
            }
            resolved = this.resolve(name, this.protoTypeNames);
        }
        if (resolved == null) {
            object = this;
            ((Linker)object).errors.plusAssign(Intrinsics.stringPlus((String)"unable to resolve ", (Object)name));
            return ProtoType.BYTES;
        }
        if (messageOnly && !(resolved instanceof MessageType)) {
            object = this;
            ((Linker)object).errors.plusAssign(Intrinsics.stringPlus((String)"expected a message but was ", (Object)name));
            return ProtoType.BYTES;
        }
        this.requestedTypes.add(resolved.getType());
        return resolved.getType();
    }

    @Nullable
    public final <T> T resolve(@NotNull String name, @NotNull Map<String, ? extends T> map) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (StringsKt.startsWith$default((String)name, (String)".", (boolean)false, (int)2, null)) {
            String string = name;
            int n = 1;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            T result = map.get(string2);
            if (result != null) {
                return result;
            }
        } else {
            T result;
            String prefix = this.resolveContext();
            while (true) {
                String string;
                CharSequence charSequence = prefix;
                boolean bl = false;
                if (!(charSequence.length() > 0)) break;
                result = map.get(prefix + '.' + name);
                if (result != null) {
                    return result;
                }
                int dot = StringsKt.lastIndexOf$default((CharSequence)prefix, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dot != -1) {
                    String string3 = prefix;
                    int n = 0;
                    boolean bl2 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, dot);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = "";
                }
                prefix = string;
            }
            result = map.get(name);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    private final String resolveContext() {
        int n = this.contextStack.size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                Object context = this.contextStack.get(i);
                if (context instanceof Type) {
                    return ((Type)context).getType().toString();
                }
                if (context instanceof ProtoFile) {
                    String packageName = ((ProtoFile)context).getPackageName();
                    String string = packageName;
                    return string == null ? "" : string;
                }
                if (!(context instanceof Field) || !((Field)context).isExtension()) continue;
                String string = ((Field)context).getPackageName();
                return string == null ? "" : string;
            } while (0 <= n);
        }
        throw new IllegalStateException();
    }

    @Nullable
    public final String packageName() {
        for (Object context : this.contextStack) {
            if (!(context instanceof ProtoFile)) continue;
            return ((ProtoFile)context).getPackageName();
        }
        return null;
    }

    @NotNull
    public final List<FileLinker> contextImportedTypes$wire_schema() {
        int n = 0;
        List result = new ArrayList();
        n = this.contextStack.size() + -1;
        if (0 <= n) {
            do {
                Location location;
                int i = n--;
                Object context = this.contextStack.get(i);
                Location location2 = context instanceof ProtoFile ? ((ProtoFile)context).getLocation() : (location = context instanceof Field && ((Field)context).isExtension() ? ((Field)context).getLocation() : null);
                if (location == null) continue;
                String path = location.getPath();
                FileLinker fileLinker = this.getFileLinker$wire_schema(path);
                for (String effectiveImport : fileLinker.effectiveImports()) {
                    result.add(this.getFileLinker$wire_schema(effectiveImport));
                }
            } while (0 <= n);
        }
        return result;
    }

    public final void addType(@NotNull ProtoType protoType, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Map<String, Type> map = this.protoTypeNames;
        String string = protoType.toString();
        boolean bl = false;
        map.put(string, type);
    }

    @Nullable
    public final Type get(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Type result = this.protoTypeNames.get(protoType.toString());
        if (result == null) {
            for (FileLinker fileLinker : this.contextImportedTypes$wire_schema()) {
                fileLinker.requireTypesRegistered();
            }
            result = this.protoTypeNames.get(protoType.toString());
        }
        if (result != null) {
            this.requestedTypes.add(protoType);
        }
        return result;
    }

    @Nullable
    public final Type getForOptions(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Type type = this.get(protoType);
        if (type == null) {
            return null;
        }
        Type result = type;
        FileLinker fileLinker = this.getFileLinker$wire_schema(result.getLocation().getPath());
        fileLinker.requireMembersLinked(result);
        return result;
    }

    public final void request(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.requestedFields.add(field);
    }

    @Nullable
    public final Field dereference(@NotNull Field self, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String field2 = field;
        if (StringsKt.startsWith$default((String)field2, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)field2, (String)"]", (boolean)false, (int)2, null)) {
            String string = field2;
            int n = 1;
            int n2 = field2.length() - 1;
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            field2 = string2;
        }
        ProtoType protoType = self.getType();
        Intrinsics.checkNotNull((Object)protoType);
        Type type = this.getForOptions(protoType);
        if (type instanceof MessageType) {
            Field messageField = ((MessageType)type).field(field2);
            if (messageField != null) {
                return messageField;
            }
            Map<String, Field> typeExtensions = ((MessageType)type).extensionFieldsMap();
            Field extensionField = this.resolve(field2, typeExtensions);
            if (extensionField != null) {
                return extensionField;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void validateFields(@NotNull Iterable<Field> fields, @NotNull List<Reserved> reserveds, @NotNull SyntaxRules syntaxRules) {
        Field field;
        int n;
        int n2;
        Object item$iv;
        Object error;
        Object key$iv32;
        Object $this$getOrPut$iv;
        int tag;
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter(reserveds, (String)"reserveds");
        Intrinsics.checkNotNullParameter((Object)syntaxRules, (String)"syntaxRules");
        boolean bl = false;
        LinkedHashMap tagToField = new LinkedHashMap();
        boolean bl2 = false;
        LinkedHashMap nameToField = new LinkedHashMap();
        boolean bl3 = false;
        LinkedHashMap jsonNameToField = new LinkedHashMap();
        for (Field iterator2 : fields) {
            Object object;
            Object object2;
            Set answer$iv;
            boolean bl4;
            tag = iterator2.getTag();
            if (!UtilKt.isValidTag(tag)) {
                this.errors.at(iterator2).plusAssign(Intrinsics.stringPlus((String)"tag is out of range: ", (Object)tag));
            }
            for (Reserved reserved : reserveds) {
                if (reserved.matchesTag(tag)) {
                    this.errors.at(iterator2).plusAssign("tag " + tag + " is reserved (" + reserved.getLocation() + ')');
                }
                if (!reserved.matchesName(iterator2.getName())) continue;
                this.errors.at(iterator2).plusAssign("name '" + iterator2.getName() + "' is reserved (" + reserved.getLocation() + ')');
            }
            Map map = tagToField;
            Integer key$iv2 = tag;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv2);
            if (value$iv == null) {
                boolean bl5 = false;
                bl4 = false;
                answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv2, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((Set)object2).add(iterator2);
            $this$getOrPut$iv = nameToField;
            key$iv32 = iterator2.getQualifiedName();
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv32);
            if (value$iv == null) {
                boolean bl6 = false;
                bl4 = false;
                answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv32, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(iterator2);
            if (!iterator2.isExtension()) {
                Object object3;
                $this$getOrPut$iv = jsonNameToField;
                key$iv32 = syntaxRules.jsonName(iterator2.getName(), iterator2.getDeclaredJsonName());
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv32);
                if (value$iv == null) {
                    boolean bl7 = false;
                    bl4 = false;
                    answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv32, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                ((Set)object3).add(iterator2);
            }
            ProtoType protoType = iterator2.getType();
            Intrinsics.checkNotNull((Object)protoType);
            syntaxRules.validateTypeReference(this.get(protoType), this.errors.at(iterator2));
        }
        Map map = tagToField;
        tag = 0;
        for (Map.Entry entry : map.entrySet()) {
            $this$getOrPut$iv = entry;
            boolean key$iv32 = false;
            int key = ((Number)$this$getOrPut$iv.getKey()).intValue();
            key$iv32 = entry;
            boolean $i$f$getOrPut = false;
            Set values = (Set)key$iv32.getValue();
            if (values.size() <= 1) continue;
            error = new StringBuilder();
            ((StringBuilder)error).append("multiple fields share tag " + key + ':');
            Object $this$forEachIndexed$iv = values;
            boolean $i$f$forEachIndexed232 = false;
            int index$iv = 0;
            Iterator iterator = $this$forEachIndexed$iv.iterator();
            while (iterator.hasNext()) {
                item$iv = iterator.next();
                n2 = index$iv++;
                n = 0;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Field field2 = (Field)item$iv;
                int index = n2;
                boolean bl8 = false;
                ((StringBuilder)error).append("\n  " + (index + 1) + ". " + field.getName() + " (" + field.getLocation() + ')');
            }
            $this$forEachIndexed$iv = this;
            ErrorCollector errorCollector = ((Linker)$this$forEachIndexed$iv).errors;
            String $i$f$forEachIndexed232 = ((StringBuilder)error).toString();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEachIndexed232, (String)"error.toString()");
            errorCollector.plusAssign($i$f$forEachIndexed232);
        }
        boolean hasCollidingFields = false;
        for (Set collidingFields : nameToField.values()) {
            if (collidingFields.size() <= 1) continue;
            hasCollidingFields = true;
            Field first = (Field)collidingFields.iterator().next();
            error = new StringBuilder();
            ((StringBuilder)error).append("multiple fields share name " + first.getName() + ':');
            Intrinsics.checkNotNullExpressionValue((Object)collidingFields, (String)"collidingFields");
            Object $this$forEachIndexed$iv232 = collidingFields;
            boolean $i$f$forEachIndexed22 = false;
            int index$iv = 0;
            Iterator iterator = $this$forEachIndexed$iv232.iterator();
            while (iterator.hasNext()) {
                item$iv = iterator.next();
                n2 = index$iv++;
                n = 0;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                field = (Field)item$iv;
                int index2 = n2;
                boolean bl9 = false;
                ((StringBuilder)error).append("\n  " + (index2 + 1) + ". " + field.getName() + " (" + field.getLocation() + ')');
            }
            $this$forEachIndexed$iv232 = this;
            ErrorCollector errorCollector = ((Linker)$this$forEachIndexed$iv232).errors;
            String $i$f$forEachIndexed22 = ((StringBuilder)error).toString();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEachIndexed22, (String)"error.toString()");
            errorCollector.plusAssign($i$f$forEachIndexed22);
        }
        if (!hasCollidingFields) {
            Object object = jsonNameToField;
            boolean first = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                error = object = iterator.next();
                boolean $this$forEachIndexed$iv232 = false;
                String jsonName = (String)error.getKey();
                Object $this$forEachIndexed$iv232 = object;
                boolean $i$f$forEachIndexed22 = false;
                Set fields2 = (Set)$this$forEachIndexed$iv232.getValue();
                if (fields2.size() <= 1) continue;
                StringBuilder error2 = new StringBuilder();
                error2.append("multiple fields share same JSON name '" + jsonName + "':");
                Iterable $this$forEachIndexed$iv = fields2;
                boolean $i$f$forEachIndexed3 = false;
                int index$iv = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv) {
                    void field4;
                    n = index$iv++;
                    boolean bl5 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Field index2 = (Field)item$iv2;
                    int index3 = n;
                    boolean bl11 = false;
                    error2.append("\n  " + (index3 + 1) + ". " + field4.getName() + " (" + field4.getLocation() + ')');
                }
                Linker linker = this;
                ErrorCollector errorCollector = linker.errors;
                String string = error2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"error.toString()");
                errorCollector.plusAssign(string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void validateEnumConstantNameUniqueness(@NotNull Iterable<? extends Type> nestedTypes) {
        Map.Entry<String, Set> $this$getOrPut$iv232;
        Intrinsics.checkNotNullParameter(nestedTypes, (String)"nestedTypes");
        boolean bl = false;
        Map nameToType = new LinkedHashMap();
        for (Type object : nestedTypes) {
            if (!(object instanceof EnumType)) continue;
            for (EnumConstant enumConstant : ((EnumType)object).getConstants()) {
                Object object2;
                Map map = nameToType;
                String key$iv = enumConstant.getName();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv232.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv232.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                $this$getOrPut$iv232 = object2;
                boolean bl4 = false;
                boolean bl5 = false;
                Set it = (Set)((Object)$this$getOrPut$iv232);
                boolean bl6 = false;
                Collection collection = it;
                Type type = object;
                boolean bl7 = false;
                collection.add(type);
            }
        }
        Map map = nameToType;
        boolean bl8 = false;
        Iterator<Object> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String error;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
            boolean $this$getOrPut$iv232 = false;
            String constant = (String)entry2.getKey();
            $this$getOrPut$iv232 = entry;
            boolean bl9 = false;
            Set set = (Set)$this$getOrPut$iv232.getValue();
            if (set.size() <= 1) continue;
            bl9 = false;
            boolean bl10 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl11 = false;
            boolean bl12 = false;
            StringBuilder $this$validateEnumConstantNameUniqueness_u24lambda_u2d12 = stringBuilder;
            boolean bl13 = false;
            $this$validateEnumConstantNameUniqueness_u24lambda_u2d12.append("multiple enums share constant " + constant + ':');
            Iterable $this$forEachIndexed$iv = set;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void enumType;
                int n = index$iv++;
                boolean bl14 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EnumType enumType2 = (EnumType)item$iv;
                int index = n;
                boolean bl15 = false;
                StringBuilder stringBuilder2 = new StringBuilder().append("\n  ").append(index + 1).append(". ").append(enumType.getType()).append('.').append(constant).append(" (");
                EnumConstant enumConstant = enumType.constant(constant);
                Intrinsics.checkNotNull((Object)enumConstant);
                $this$validateEnumConstantNameUniqueness_u24lambda_u2d12.append(stringBuilder2.append(enumConstant.getLocation()).append(')').toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            Linker linker = this;
            linker.errors.plusAssign(error);
        }
    }

    public final void validateImportForType(@NotNull Location location, @NotNull ProtoType type) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ProtoType type2 = type;
        if (type2.isMap()) {
            ProtoType protoType = type2.getValueType();
            Intrinsics.checkNotNull((Object)protoType);
            type2 = protoType;
        }
        if (type2.isScalar()) {
            return;
        }
        String path = location.getPath();
        Type type3 = this.get(type2);
        Intrinsics.checkNotNull((Object)type3);
        String requiredImport = type3.getLocation().getPath();
        FileLinker fileLinker = this.getFileLinker$wire_schema(path);
        if (!Intrinsics.areEqual((Object)path, (Object)requiredImport) && !fileLinker.effectiveImports().contains(requiredImport)) {
            Linker linker = this;
            linker.errors.plusAssign(path + " needs to import " + requiredImport);
        }
    }

    public final void validateImportForPath(@NotNull Location location, @NotNull String requiredImport) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)requiredImport, (String)"requiredImport");
        String path = location.getPath();
        FileLinker fileLinker = this.getFileLinker$wire_schema(path);
        if (!Intrinsics.areEqual((Object)path, (Object)requiredImport) && !fileLinker.effectiveImports().contains(requiredImport)) {
            Linker linker = this;
            linker.errors.plusAssign(path + " needs to import " + requiredImport);
        }
    }

    @NotNull
    public final Linker withContext(@NotNull Object context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Linker(this, context);
    }
}

