[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [PruningRules](./index.md)

# PruningRules

`class PruningRules`

A set of rules that describes which types and members to retain and which to remove.

Members may be pruned using either their identifier (package, type name, member name) or their
version (since and until options).

Despite the builder, instances of this class are not safe for concurrent use.

### Identifier Matching

If a member is a root in the set, its type is implicitly also considered a root. A type that is
a root without a specific member implicitly set all of that type's members as roots, but not its
nested types.

Identifiers in this set may be in the following forms:

* Package names, followed by `.*`, like `squareup.protos.person.*`. This matches types and
    services defined in the package and its descendant packages.

* Fully qualified type and service names, like `squareup.protos.person.Person`.

* Fully qualified member names, which are type names followed by a '#', followed by a member
    name, like `squareup.protos.person.Person#address`. Members may be fields, enum constants or
    RPCs.

An identifier set populated with `Movie` and `Actor#name` contains all members of `Movie` (such
as `Movie#name` and `Movie#release_date`). It contains the type `Actor` and one member
`Actor#name`, but not `Actor#birth_date` or `Actor#oscar_count`.

This set has *root identifiers* and *prune identifiers*, with the most precise identifier
taking precedence over the other ones. For instance, if there is one root identifier
`a.Movie` along a pruning identifier `a.*`, the type `a.Movie` is considered a root.

If the roots set is empty, that implies that all elements are considered roots. Use this to
prune unwanted types and members without also marking everything else as roots.

### Version Matching

Members may be declared with `wire.since` and `wire.until` options. For example, these options
declare a field `age` that was replaced with `birth_date` in version "5.0":

```
optional int32 age = 3 [(wire.until) = "5.0"];
optional Date birth_date = 4 [(wire.since) = "5.0"];
```

Client code should typically target a single version. In this example, versions &lt;= "4.0" will
have the `age` field only and versions &gt;= "5.0" will have the `birth_date` field only. One can
target a single version using [only](only.md).

Service code that supports many clients should support the union of versions of all supported
clients. Such code will have both the `age` and `birth_date` fields.

### Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | `class Builder` |

### Properties

| Name | Summary |
|---|---|
| [isEmpty](is-empty.md) | `val isEmpty: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [only](only.md) | `val only: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [prunes](prunes.md) | `val prunes: <ERROR CLASS>` |
| [roots](roots.md) | `val roots: <ERROR CLASS>` |
| [since](since.md) | `val since: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [until](until.md) | `val until: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |

### Functions

| Name | Summary |
|---|---|
| [isEnumConstantRetainedVersion](is-enum-constant-retained-version.md) | `fun isEnumConstantRetainedVersion(options: `[`Options`](../-options/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true unless [options](is-enum-constant-retained-version.md#com.squareup.wire.schema.PruningRules$isEnumConstantRetainedVersion(com.squareup.wire.schema.Options)/options) specifies a version that is outside of the configured range. |
| [isFieldRetainedVersion](is-field-retained-version.md) | `fun isFieldRetainedVersion(options: `[`Options`](../-options/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true unless [options](is-field-retained-version.md#com.squareup.wire.schema.PruningRules$isFieldRetainedVersion(com.squareup.wire.schema.Options)/options) specifies a version that is outside of the configured range. |
| [isRoot](is-root.md) | `fun isRoot(type: `[`ProtoType`](../-proto-type/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [type](is-root.md#com.squareup.wire.schema.PruningRules$isRoot(com.squareup.wire.schema.ProtoType)/type) is a root.`fun isRoot(protoMember: `[`ProtoMember`](../-proto-member/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [protoMember](is-root.md#com.squareup.wire.schema.PruningRules$isRoot(com.squareup.wire.schema.ProtoMember)/protoMember) is a root. |
| [prunes](prunes.md) | `fun prunes(type: `[`ProtoType`](../-proto-type/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [type](prunes.md#com.squareup.wire.schema.PruningRules$prunes(com.squareup.wire.schema.ProtoType)/type) should be pruned, even if it is a transitive dependency of a root. In that case, the referring member is also pruned.`fun prunes(protoMember: `[`ProtoMember`](../-proto-member/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [protoMember](prunes.md#com.squareup.wire.schema.PruningRules$prunes(com.squareup.wire.schema.ProtoMember)/protoMember) should be pruned. |
| [unusedPrunes](unused-prunes.md) | `fun unusedPrunes(): <ERROR CLASS>` |
| [unusedRoots](unused-roots.md) | `fun unusedRoots(): <ERROR CLASS>` |
