/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.WireEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

final class RuntimeEnumAdapter<E extends WireEnum>
extends EnumAdapter<E> {
    private final Class<E> type;
    @Nullable
    private Method fromValueMethod;

    RuntimeEnumAdapter(Class<E> type) {
        super(type);
        this.type = type;
    }

    private Method getFromValueMethod() {
        Method method = this.fromValueMethod;
        if (method != null) {
            return method;
        }
        try {
            this.fromValueMethod = this.type.getMethod("fromValue", Integer.TYPE);
            return this.fromValueMethod;
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    protected E fromValue(int value) {
        WireEnum constant;
        try {
            constant = (WireEnum)this.getFromValueMethod().invoke(null, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        return (E)constant;
    }

    public boolean equals(Object o) {
        return o instanceof RuntimeEnumAdapter && ((RuntimeEnumAdapter)o).type == this.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

