/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.FieldEncoding;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import okio.BufferedSource;
import okio.ByteString;

public final class ProtoReader {
    private static final int RECURSION_LIMIT = 65;
    private static final int FIELD_ENCODING_MASK = 7;
    static final int TAG_FIELD_ENCODING_BITS = 3;
    private static final int STATE_VARINT = 0;
    private static final int STATE_FIXED64 = 1;
    private static final int STATE_LENGTH_DELIMITED = 2;
    private static final int STATE_START_GROUP = 3;
    private static final int STATE_END_GROUP = 4;
    private static final int STATE_FIXED32 = 5;
    private static final int STATE_TAG = 6;
    private static final int STATE_PACKED_TAG = 7;
    private final BufferedSource source;
    private long pos = 0L;
    private long limit = Long.MAX_VALUE;
    private int recursionDepth;
    private int state = 2;
    private int tag = -1;
    private long pushedLimit = -1L;
    private FieldEncoding nextFieldEncoding;

    public ProtoReader(BufferedSource source) {
        this.source = source;
    }

    public long beginMessage() throws IOException {
        if (this.state != 2) {
            throw new IllegalStateException("Unexpected call to beginMessage()");
        }
        if (++this.recursionDepth > 65) {
            throw new IOException("Wire recursion limit exceeded");
        }
        long token = this.pushedLimit;
        this.pushedLimit = -1L;
        this.state = 6;
        return token;
    }

    public void endMessage(long token) throws IOException {
        if (this.state != 6) {
            throw new IllegalStateException("Unexpected call to endMessage()");
        }
        if (--this.recursionDepth < 0 || this.pushedLimit != -1L) {
            throw new IllegalStateException("No corresponding call to beginMessage()");
        }
        if (this.pos != this.limit && this.recursionDepth != 0) {
            throw new IOException("Expected to end at " + this.limit + " but was " + this.pos);
        }
        this.limit = token;
    }

    public int nextTag() throws IOException {
        if (this.state == 7) {
            this.state = 2;
            return this.tag;
        }
        if (this.state != 6) {
            throw new IllegalStateException("Unexpected call to nextTag()");
        }
        block8: while (this.pos < this.limit && !this.source.exhausted()) {
            int tagAndFieldEncoding = this.internalReadVarint32();
            if (tagAndFieldEncoding == 0) {
                throw new ProtocolException("Unexpected tag 0");
            }
            this.tag = tagAndFieldEncoding >> 3;
            int groupOrFieldEncoding = tagAndFieldEncoding & 7;
            switch (groupOrFieldEncoding) {
                case 3: {
                    this.skipGroup(this.tag);
                    continue block8;
                }
                case 4: {
                    throw new ProtocolException("Unexpected end group");
                }
                case 2: {
                    this.nextFieldEncoding = FieldEncoding.LENGTH_DELIMITED;
                    this.state = 2;
                    int length = this.internalReadVarint32();
                    if (length < 0) {
                        throw new ProtocolException("Negative length: " + length);
                    }
                    if (this.pushedLimit != -1L) {
                        throw new IllegalStateException();
                    }
                    this.pushedLimit = this.limit;
                    this.limit = this.pos + (long)length;
                    if (this.limit > this.pushedLimit) {
                        throw new EOFException();
                    }
                    return this.tag;
                }
                case 0: {
                    this.nextFieldEncoding = FieldEncoding.VARINT;
                    this.state = 0;
                    return this.tag;
                }
                case 1: {
                    this.nextFieldEncoding = FieldEncoding.FIXED64;
                    this.state = 1;
                    return this.tag;
                }
                case 5: {
                    this.nextFieldEncoding = FieldEncoding.FIXED32;
                    this.state = 5;
                    return this.tag;
                }
            }
            throw new ProtocolException("Unexpected field encoding: " + groupOrFieldEncoding);
        }
        return -1;
    }

    public FieldEncoding peekFieldEncoding() throws IOException {
        return this.nextFieldEncoding;
    }

    public void skip() throws IOException {
        switch (this.state) {
            case 2: {
                long byteCount = this.beforeLengthDelimitedScalar();
                this.source.skip(byteCount);
                break;
            }
            case 0: {
                this.readVarint64();
                break;
            }
            case 1: {
                this.readFixed64();
                break;
            }
            case 5: {
                this.readFixed32();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected call to skip()");
            }
        }
    }

    private void skipGroup(int expectedEndTag) throws IOException {
        block8: while (this.pos < this.limit && !this.source.exhausted()) {
            int tagAndFieldEncoding = this.internalReadVarint32();
            if (tagAndFieldEncoding == 0) {
                throw new ProtocolException("Unexpected tag 0");
            }
            int tag = tagAndFieldEncoding >> 3;
            int groupOrFieldEncoding = tagAndFieldEncoding & 7;
            switch (groupOrFieldEncoding) {
                case 3: {
                    this.skipGroup(tag);
                    continue block8;
                }
                case 4: {
                    if (tag == expectedEndTag) {
                        return;
                    }
                    throw new ProtocolException("Unexpected end group");
                }
                case 2: {
                    int length = this.internalReadVarint32();
                    this.pos += (long)length;
                    this.source.skip((long)length);
                    continue block8;
                }
                case 0: {
                    this.state = 0;
                    this.readVarint64();
                    continue block8;
                }
                case 1: {
                    this.state = 1;
                    this.readFixed64();
                    continue block8;
                }
                case 5: {
                    this.state = 5;
                    this.readFixed32();
                    continue block8;
                }
            }
            throw new ProtocolException("Unexpected field encoding: " + groupOrFieldEncoding);
        }
        throw new EOFException();
    }

    public ByteString readBytes() throws IOException {
        long byteCount = this.beforeLengthDelimitedScalar();
        return this.source.readByteString(byteCount);
    }

    public String readString() throws IOException {
        long byteCount = this.beforeLengthDelimitedScalar();
        return this.source.readUtf8(byteCount);
    }

    public int readVarint32() throws IOException {
        if (this.state != 0 && this.state != 2) {
            throw new ProtocolException("Expected VARINT or LENGTH_DELIMITED but was " + this.state);
        }
        int result = this.internalReadVarint32();
        this.afterPackableScalar(0);
        return result;
    }

    private int internalReadVarint32() throws IOException {
        ++this.pos;
        byte tmp = this.source.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        ++this.pos;
        tmp = this.source.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            ++this.pos;
            tmp = this.source.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                ++this.pos;
                tmp = this.source.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    ++this.pos;
                    tmp = this.source.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            ++this.pos;
                            if (this.source.readByte() < 0) continue;
                            return result;
                        }
                        throw new ProtocolException("Malformed VARINT");
                    }
                }
            }
        }
        return result;
    }

    public long readVarint64() throws IOException {
        if (this.state != 0 && this.state != 2) {
            throw new ProtocolException("Expected VARINT or LENGTH_DELIMITED but was " + this.state);
        }
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            ++this.pos;
            byte b = this.source.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            this.afterPackableScalar(0);
            return result;
        }
        throw new ProtocolException("WireInput encountered a malformed varint");
    }

    public int readFixed32() throws IOException {
        if (this.state != 5 && this.state != 2) {
            throw new ProtocolException("Expected FIXED32 or LENGTH_DELIMITED but was " + this.state);
        }
        this.source.require(4L);
        this.pos += 4L;
        int result = this.source.readIntLe();
        this.afterPackableScalar(5);
        return result;
    }

    public long readFixed64() throws IOException {
        if (this.state != 1 && this.state != 2) {
            throw new ProtocolException("Expected FIXED64 or LENGTH_DELIMITED but was " + this.state);
        }
        this.source.require(8L);
        this.pos += 8L;
        long result = this.source.readLongLe();
        this.afterPackableScalar(1);
        return result;
    }

    private void afterPackableScalar(int fieldEncoding) throws IOException {
        if (this.state == fieldEncoding) {
            this.state = 6;
        } else {
            if (this.pos > this.limit) {
                throw new IOException("Expected to end at " + this.limit + " but was " + this.pos);
            }
            if (this.pos == this.limit) {
                this.limit = this.pushedLimit;
                this.pushedLimit = -1L;
                this.state = 6;
            } else {
                this.state = 7;
            }
        }
    }

    private long beforeLengthDelimitedScalar() throws IOException {
        if (this.state != 2) {
            throw new ProtocolException("Expected LENGTH_DELIMITED but was " + this.state);
        }
        long byteCount = this.limit - this.pos;
        this.source.require(byteCount);
        this.state = 6;
        this.pos = this.limit;
        this.limit = this.pushedLimit;
        this.pushedLimit = -1L;
        return byteCount;
    }
}

