/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ImmutableList;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.WireField;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;

final class FieldBinding<M extends Message<M>, B extends Message.Builder<M, B>> {
    public final WireField.Label label;
    public final String name;
    public final int tag;
    public final String adapterString;
    public final boolean redacted;
    private final Field messageField;
    private final Field builderField;
    private final Method builderMethod;
    private ProtoAdapter<?> singleAdapter;
    private ProtoAdapter<Object> adapter;

    private static Field getBuilderField(Class<?> builderType, String name) {
        try {
            return builderType.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)("No builder field " + builderType.getName() + "." + name));
        }
    }

    private static Method getBuilderMethod(Class<?> builderType, String name, Class<?> type) {
        try {
            return builderType.getMethod(name, type);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("No builder method " + builderType.getName() + "." + name + "(" + type.getName() + ")"));
        }
    }

    FieldBinding(WireField wireField, Field messageField, Class<B> builderType) {
        this.label = wireField.label();
        this.name = messageField.getName();
        this.tag = wireField.tag();
        this.adapterString = wireField.adapter();
        this.redacted = wireField.redacted();
        this.messageField = messageField;
        this.builderField = FieldBinding.getBuilderField(builderType, this.name);
        this.builderMethod = FieldBinding.getBuilderMethod(builderType, this.name, messageField.getType());
    }

    ProtoAdapter<?> singleAdapter() {
        ProtoAdapter<?> result = this.singleAdapter;
        return result != null ? result : (this.singleAdapter = ProtoAdapter.get(this.adapterString));
    }

    ProtoAdapter<Object> adapter() {
        ProtoAdapter<Object> result = this.adapter;
        return result != null ? result : (this.adapter = this.singleAdapter().withLabel(this.label));
    }

    void value(B builder, Object value) {
        if (this.label.isRepeated()) {
            try {
                ImmutableList list = (ImmutableList)this.builderField.get(builder);
                if (list == Collections.emptyList()) {
                    list = new ImmutableList();
                    this.builderField.set(builder, list);
                }
                ((ImmutableList)list).list.add(value);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            this.set(builder, value);
        }
    }

    void set(B builder, Object value) {
        try {
            if (this.label.isOneOf()) {
                this.builderMethod.invoke(builder, value);
            } else {
                this.builderField.set(builder, value);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    Object get(M message) {
        try {
            return this.messageField.get(message);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    Object getFromBuilder(B builder) {
        try {
            return this.builderField.get(builder);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

