/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Extension;
import com.squareup.wire.Message;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ExtensionRegistry {
    static final ExtensionRegistry NO_EXTENSIONS = new ExtensionRegistry(new Class[0]);
    private final Map<Class<? extends Message>, List<Extension<?, ?>>> messageToExtensions = new LinkedHashMap();

    public ExtensionRegistry(Class<?> ... extensionClasses) {
        this(Arrays.asList(extensionClasses));
    }

    public ExtensionRegistry(List<Class<?>> extensionClasses) {
        for (Class<?> extensionClass : extensionClasses) {
            for (Field field : extensionClass.getDeclaredFields()) {
                if (!field.getType().equals(Extension.class)) continue;
                try {
                    this.registerExtension((Extension)field.get(null));
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    private <T extends Message<T>> void registerExtension(Extension<T, ?> extension) {
        Class<T> messageClass = extension.getExtendedType();
        List<Extension<?, ?>> extensions = this.messageToExtensions.get(messageClass);
        if (extensions == null) {
            extensions = new ArrayList();
            this.messageToExtensions.put(messageClass, extensions);
        }
        extensions.add(extension);
    }

    public <T extends Message<T>> List<Extension<T, ?>> extensions(Class<T> messageClass) {
        List<Extension<?, ?>> map = this.messageToExtensions.get(messageClass);
        return map != null ? map : Collections.emptyList();
    }

    public <T extends Message<T>> Extension<T, ?> get(Class<T> messageType, int tag) {
        for (Extension<T, ?> extension : this.extensions(messageType)) {
            if (extension.getTag() != tag) continue;
            return extension;
        }
        return null;
    }
}

