/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Extension;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.RuntimeEnumAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

final class TagMap {
    private final Object[] array;

    private TagMap(Builder builder) {
        this.array = new Object[builder.limit];
        System.arraycopy(builder.array, 0, this.array, 0, builder.limit);
    }

    public int size() {
        return this.array.length / 2;
    }

    public int encodedSize() {
        int result = 0;
        int i = 0;
        while (i < this.array.length) {
            Extension extension = (Extension)this.array[i];
            ProtoAdapter<Object> adapter = TagMap.adapter(extension);
            if (extension.getLabel().isPacked()) {
                int runSize = 0;
                int runEnd = this.runEnd(i);
                for (int j = i; j < runEnd; j += 2) {
                    runSize += adapter.encodedSize(this.array[j + 1]);
                }
                result += ProtoWriter.tagSize(extension.getTag());
                result += ProtoWriter.varint32Size(runSize);
                result += runSize;
                i = runEnd;
                continue;
            }
            result += adapter.encodedSize(extension.getTag(), this.array[i + 1]);
            i += 2;
        }
        return result;
    }

    public void encode(ProtoWriter writer) throws IOException {
        int i = 0;
        while (i < this.array.length) {
            Extension extension = (Extension)this.array[i];
            ProtoAdapter<Object> adapter = TagMap.adapter(extension);
            if (extension.getLabel().isPacked()) {
                int j;
                int runEnd = this.runEnd(i);
                int runSize = 0;
                for (j = i; j < runEnd; j += 2) {
                    runSize += adapter.encodedSize(this.array[j + 1]);
                }
                writer.writeTag(extension.getTag(), FieldEncoding.LENGTH_DELIMITED);
                writer.writeVarint32(runSize);
                for (j = i; j < runEnd; j += 2) {
                    adapter.encode(writer, this.array[j + 1]);
                }
                i = runEnd;
                continue;
            }
            adapter.encodeTagged(writer, extension.getTag(), this.array[i + 1]);
            i += 2;
        }
    }

    private int runEnd(int runStart) {
        int runEnd;
        Extension extension = (Extension)this.array[runStart];
        for (runEnd = runStart + 2; runEnd < this.array.length && ((Extension)this.array[runEnd]).getTag() == extension.getTag() && ((Extension)this.array[runEnd]).getAdapter().equals(extension.getAdapter()); runEnd += 2) {
        }
        return runEnd;
    }

    public Object get(Extension<?, ?> extension) {
        return TagMap.get(this.array, this.array.length, extension);
    }

    static Object get(Object[] array, int limit, Extension<?, ?> targetExtension) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < limit; i += 2) {
            Extension sourceExtension = (Extension)array[i];
            if (sourceExtension.getTag() != targetExtension.getTag()) continue;
            TagMap.transcode(list, sourceExtension, array[i + 1], targetExtension);
        }
        if (targetExtension.getLabel().isRepeated()) {
            return Collections.unmodifiableList(list);
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new IllegalArgumentException("found multiple values for non-repeated extension " + targetExtension);
    }

    static void transcode(List<Object> list, Extension<?, ?> sourceExtension, Object value, Extension<?, ?> targetExtension) {
        if (sourceExtension.getAdapter().equals(targetExtension.getAdapter())) {
            list.add(value);
            return;
        }
        try {
            Buffer buffer = new Buffer();
            TagMap.adapter(sourceExtension).encodeTagged(new ProtoWriter((BufferedSink)buffer), 1, value);
            ProtoReader reader = new ProtoReader((BufferedSource)buffer);
            long token = reader.beginMessage();
            while (reader.nextTag() != -1) {
                try {
                    list.add(TagMap.adapter(targetExtension).decode(reader));
                }
                catch (RuntimeEnumAdapter.EnumConstantNotFoundException e) {
                    list.add(e.value);
                }
            }
            reader.endMessage(token);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to transcode " + value + " to " + targetExtension, e);
        }
    }

    private static ProtoAdapter<Object> adapter(Extension<?, ?> sourceExtension) {
        return sourceExtension.getAdapter();
    }

    public Set<Extension<?, ?>> extensions(boolean includeUnknown) {
        LinkedHashSet<Extension> result = new LinkedHashSet<Extension>();
        for (int i = 0; i < this.array.length; i += 2) {
            Extension extension = (Extension)this.array[i];
            if (!includeUnknown && extension.isUnknown()) continue;
            result.add(extension);
        }
        return Collections.unmodifiableSet(result);
    }

    public boolean equals(Object o) {
        return o instanceof TagMap && Arrays.equals(((TagMap)o).array, this.array);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public static final class Builder {
        static final int INITIAL_CAPACITY = 8;
        private Object[] array;
        private int limit = 0;

        public Builder() {
            this.array = new Object[8];
        }

        public Builder(TagMap tagMap) {
            this.array = (Object[])tagMap.array.clone();
            this.limit = tagMap.array.length;
        }

        public Builder add(Extension<?, ?> extension, Object value) {
            if (extension == null) {
                throw new NullPointerException("extension == null");
            }
            if (value == null) {
                throw new NullPointerException("value == null");
            }
            if (this.limit == this.array.length) {
                int newLimit = Math.max(this.limit * 2, 8);
                Object[] newArray = new Object[newLimit];
                System.arraycopy(this.array, 0, newArray, 0, this.limit);
                this.array = newArray;
            }
            this.array[this.limit++] = extension;
            this.array[this.limit++] = value;
            return this;
        }

        public Object get(Extension<?, ?> extension) {
            return TagMap.get(this.array, this.limit, extension);
        }

        public Builder removeAll(int tag) {
            for (int i = 0; i < this.limit; i += 2) {
                int runStart = i;
                while (i < this.limit && ((Extension)this.array[i]).getTag() == tag) {
                    i += 2;
                }
                if (i <= runStart) continue;
                System.arraycopy(this.array, i, this.array, runStart, this.limit - i);
                Arrays.fill(this.array, this.limit - (i - runStart), this.limit, null);
                this.limit -= i - runStart;
                i = runStart;
            }
            return this;
        }

        public Builder redact() {
            Object[] oldArray = (Object[])this.array.clone();
            int oldLimit = this.limit;
            Arrays.fill(this.array, 0, this.limit, null);
            this.limit = 0;
            for (int i = 0; i < oldLimit; i += 2) {
                Object redactedValue;
                Extension extension = (Extension)oldArray[i];
                if (extension.isUnknown() || (redactedValue = TagMap.adapter(extension).redact(oldArray[i + 1])) == null) continue;
                this.array[this.limit++] = extension;
                this.array[this.limit++] = redactedValue;
            }
            return this;
        }

        public TagMap build() {
            return new TagMap(this);
        }
    }
}

