/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ExtendableMessage;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoEnum;
import java.util.List;
import okio.ByteString;

public final class Extension<T extends ExtendableMessage<T>, E>
implements Comparable<Extension<?, ?>> {
    private final Class<T> extendedType;
    private final Class<? extends Message> messageType;
    private final Class<? extends ProtoEnum> enumType;
    private final String name;
    private final int tag;
    private final Message.Datatype datatype;
    private final Message.Label label;

    public static <T extends ExtendableMessage<T>> Builder<T, Integer> int32Extending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.INT32);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Integer> sint32Extending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.SINT32);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Integer> uint32Extending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.UINT32);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Integer> fixed32Extending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.FIXED32);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Integer> sfixed32Extending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.SFIXED32);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Long> int64Extending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.INT64);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Long> sint64Extending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.SINT64);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Long> uint64Extending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.UINT64);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Long> fixed64Extending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.FIXED64);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Long> sfixed64Extending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.SFIXED64);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Boolean> boolExtending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.BOOL);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, String> stringExtending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.STRING);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, ByteString> bytesExtending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.BYTES);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Float> floatExtending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.FLOAT);
    }

    public static <T extends ExtendableMessage<T>> Builder<T, Double> doubleExtending(Class<T> extendedType) {
        return new Builder(extendedType, Message.Datatype.DOUBLE);
    }

    public static <T extends ExtendableMessage<T>, E extends Enum> Builder<T, E> enumExtending(Class<E> enumType, Class<T> extendedType) {
        return new Builder(extendedType, null, enumType, Message.Datatype.ENUM);
    }

    public static <T extends ExtendableMessage<T>, M extends Message> Builder<T, M> messageExtending(Class<M> messageType, Class<T> extendedType) {
        return new Builder(extendedType, messageType, null, Message.Datatype.MESSAGE);
    }

    private Extension(Class<T> extendedType, Class<? extends Message> messageType, Class<? extends ProtoEnum> enumType, String name, int tag, Message.Label label, Message.Datatype datatype) {
        this.extendedType = extendedType;
        this.name = name;
        this.tag = tag;
        this.datatype = datatype;
        this.label = label;
        this.messageType = messageType;
        this.enumType = enumType;
    }

    @Override
    public int compareTo(Extension<?, ?> o) {
        return this.tag - o.tag;
    }

    public boolean equals(Object other) {
        return other instanceof Extension && this.compareTo((Extension)other) == 0;
    }

    public int hashCode() {
        int hash = this.tag;
        hash = hash * 37 + this.datatype.hashCode();
        hash = hash * 37 + this.label.hashCode();
        hash = hash * 37 + this.extendedType.hashCode();
        hash = hash * 37 + (this.messageType != null ? this.messageType.hashCode() : 0);
        hash = hash * 37 + (this.enumType != null ? this.enumType.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return String.format("[%s %s %s = %d]", new Object[]{this.label, this.datatype, this.name, this.tag});
    }

    public Class<T> getExtendedType() {
        return this.extendedType;
    }

    public Class<? extends Message> getMessageType() {
        return this.messageType;
    }

    public Class<? extends ProtoEnum> getEnumType() {
        return this.enumType;
    }

    public String getName() {
        return this.name;
    }

    public int getTag() {
        return this.tag;
    }

    public Message.Datatype getDatatype() {
        return this.datatype;
    }

    public Message.Label getLabel() {
        return this.label;
    }

    public static final class Builder<T extends ExtendableMessage<T>, E> {
        private final Class<T> extendedType;
        private final Class<? extends Message> messageType;
        private final Class<? extends ProtoEnum> enumType;
        private final Message.Datatype datatype;
        private String name = null;
        private int tag = -1;
        private Message.Label label = null;

        private Builder(Class<T> extendedType, Message.Datatype datatype) {
            this.extendedType = extendedType;
            this.messageType = null;
            this.enumType = null;
            this.datatype = datatype;
        }

        private Builder(Class<T> extendedType, Class<? extends Message> messageType, Class<? extends ProtoEnum> enumType, Message.Datatype datatype) {
            this.extendedType = extendedType;
            this.messageType = messageType;
            this.enumType = enumType;
            this.datatype = datatype;
        }

        public Builder<T, E> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T, E> setTag(int tag) {
            this.tag = tag;
            return this;
        }

        public Extension<T, E> buildOptional() {
            this.label = Message.Label.OPTIONAL;
            this.validate();
            return new Extension(this.extendedType, this.messageType, this.enumType, this.name, this.tag, this.label, this.datatype);
        }

        public Extension<T, List<E>> buildRepeated() {
            this.label = Message.Label.REPEATED;
            this.validate();
            return new Extension(this.extendedType, this.messageType, this.enumType, this.name, this.tag, this.label, this.datatype);
        }

        public Extension<T, List<E>> buildPacked() {
            this.label = Message.Label.PACKED;
            this.validate();
            return new Extension(this.extendedType, this.messageType, this.enumType, this.name, this.tag, this.label, this.datatype);
        }

        private void validate() {
            if (this.extendedType == null) {
                throw new IllegalArgumentException("extendedType == null");
            }
            if (this.name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (this.datatype == null) {
                throw new IllegalArgumentException("datatype == null");
            }
            if (this.label == null) {
                throw new IllegalArgumentException("label == null");
            }
            if (this.tag <= 0) {
                throw new IllegalArgumentException("tag == " + this.tag);
            }
            if (this.datatype == Message.Datatype.MESSAGE) {
                if (this.messageType == null || this.enumType != null) {
                    throw new IllegalStateException("Message w/o messageType or w/ enumType");
                }
            } else if (this.datatype == Message.Datatype.ENUM) {
                if (this.messageType != null || this.enumType == null) {
                    throw new IllegalStateException("Enum w/ messageType or w/o enumType");
                }
            } else if (this.messageType != null || this.enumType != null) {
                throw new IllegalStateException("Scalar w/ messageType or enumType");
            }
        }
    }
}

