/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ByteString;
import com.squareup.wire.EnumAdapter;
import com.squareup.wire.ExtendableMessage;
import com.squareup.wire.Extension;
import com.squareup.wire.ExtensionMap;
import com.squareup.wire.ExtensionRegistry;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.ProtoField;
import com.squareup.wire.Wire;
import com.squareup.wire.WireInput;
import com.squareup.wire.WireOutput;
import com.squareup.wire.WireType;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class MessageAdapter<M extends Message> {
    private final Wire wire;
    private final Class<M> messageType;
    private final Class<Message.Builder<M>> builderType;
    private final Map<String, Integer> tagMap = new LinkedHashMap<String, Integer>();
    private final Map<Integer, FieldInfo> fieldInfoMap = new LinkedHashMap<Integer, FieldInfo>();

    Message.Builder<M> newBuilder() {
        try {
            return this.builderType.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    Collection<FieldInfo> getFields() {
        return this.fieldInfoMap.values();
    }

    FieldInfo getField(String name) {
        Integer key = this.tagMap.get(name);
        return key == null ? null : this.fieldInfoMap.get(key);
    }

    Object getFieldValue(M message, FieldInfo fieldInfo) {
        if (fieldInfo.messageField == null) {
            throw new AssertionError((Object)"Field is not of type \"Message\"");
        }
        try {
            return fieldInfo.messageField.get(message);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setBuilderField(Message.Builder<M> builder, int tag, Object value) {
        try {
            this.fieldInfoMap.get(tag).builderMethod.invoke(builder, value);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    MessageAdapter(Wire wire, Class<M> messageType) {
        this.wire = wire;
        this.messageType = messageType;
        this.builderType = this.getBuilderType(messageType);
        for (Field messageField : messageType.getDeclaredFields()) {
            ProtoField annotation = messageField.getAnnotation(ProtoField.class);
            if (annotation == null) continue;
            int tag = annotation.tag();
            String name = messageField.getName();
            this.tagMap.put(name, tag);
            Class<Object> enumOrMessageType = null;
            Message.Datatype datatype = annotation.type();
            if (datatype == Message.Datatype.ENUM) {
                enumOrMessageType = this.getEnumType(messageField);
            } else if (datatype == Message.Datatype.MESSAGE) {
                enumOrMessageType = this.getMessageType(messageField);
            }
            this.fieldInfoMap.put(tag, new FieldInfo(tag, name, datatype, annotation.label(), enumOrMessageType, messageField, this.getBuilderMethod(name, messageField.getType())));
        }
    }

    private Class<Message.Builder<M>> getBuilderType(Class<M> messageType) {
        try {
            return Class.forName(messageType.getName() + "$Builder");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No builder class found for message type " + messageType.getName());
        }
    }

    private Method getBuilderMethod(String name, Class<?> type) {
        try {
            return this.builderType.getMethod(name, type);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("No builder method " + this.builderType.getName() + "." + name + "(" + type.getName() + ")"));
        }
    }

    private Class<Message> getMessageType(Field field) {
        Type type;
        Class<Message> fieldType = field.getType();
        if (Message.class.isAssignableFrom(fieldType)) {
            return fieldType;
        }
        if (List.class.isAssignableFrom(fieldType) && (type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class && Message.class.isAssignableFrom((Class)type)) {
            return (Class)type;
        }
        return null;
    }

    private Class<Enum> getEnumType(Field field) {
        Type type;
        Class<Enum> fieldType = field.getType();
        if (Enum.class.isAssignableFrom(fieldType)) {
            return fieldType;
        }
        if (List.class.isAssignableFrom(fieldType) && (type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class && Enum.class.isAssignableFrom((Class)type)) {
            return (Class)type;
        }
        return null;
    }

    int getSerializedSize(M message) {
        int size = 0;
        for (FieldInfo fieldInfo : this.getFields()) {
            Object value = this.getFieldValue(message, fieldInfo);
            if (value == null) continue;
            int tag = fieldInfo.tag;
            Message.Datatype datatype = fieldInfo.datatype;
            Message.Label label = fieldInfo.label;
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    size += this.getPackedSize((List)value, tag, datatype);
                    continue;
                }
                size += this.getRepeatedSize((List)value, tag, datatype);
                continue;
            }
            size += this.getSerializedSize(tag, value, datatype);
        }
        if (message instanceof ExtendableMessage) {
            ExtendableMessage extendableMessage = (ExtendableMessage)message;
            if (extendableMessage.extensionMap != null) {
                size += this.getExtensionsSerializedSize(extendableMessage.extensionMap);
            }
        }
        return size += ((Message)message).getUnknownFieldsSerializedSize();
    }

    private <T extends ExtendableMessage<?>> int getExtensionsSerializedSize(ExtensionMap<T> map) {
        int size = 0;
        for (Extension<T, ?> extension : map.getExtensions()) {
            Object value = map.get(extension);
            int tag = extension.getTag();
            Message.Datatype datatype = extension.getDatatype();
            Message.Label label = extension.getLabel();
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    size += this.getPackedSize((List)value, tag, datatype);
                    continue;
                }
                size += this.getRepeatedSize((List)value, tag, datatype);
                continue;
            }
            size += this.getSerializedSize(tag, value, datatype);
        }
        return size;
    }

    private int getRepeatedSize(List<?> value, int tag, Message.Datatype datatype) {
        int size = 0;
        for (Object o : value) {
            size += this.getSerializedSize(tag, o, datatype);
        }
        return size;
    }

    private int getPackedSize(List<?> value, int tag, Message.Datatype datatype) {
        int packedLength = 0;
        for (Object o : value) {
            packedLength += this.getSerializedSizeNoTag(o, datatype);
        }
        int size = WireOutput.varint32Size(WireOutput.makeTag(tag, WireType.LENGTH_DELIMITED));
        size += WireOutput.varint32Size(packedLength);
        return size += packedLength;
    }

    void write(M message, WireOutput output) throws IOException {
        for (FieldInfo fieldInfo : this.getFields()) {
            Object value = this.getFieldValue(message, fieldInfo);
            if (value == null) continue;
            int tag = fieldInfo.tag;
            Message.Datatype datatype = fieldInfo.datatype;
            Message.Label label = fieldInfo.label;
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    this.writePacked(output, (List)value, tag, datatype);
                    continue;
                }
                this.writeRepeated(output, (List)value, tag, datatype);
                continue;
            }
            this.writeValue(output, tag, value, datatype);
        }
        if (message instanceof ExtendableMessage) {
            ExtendableMessage extendableMessage = (ExtendableMessage)message;
            if (extendableMessage.extensionMap != null) {
                this.writeExtensions(output, extendableMessage.extensionMap);
            }
        }
        ((Message)message).writeUnknownFieldMap(output);
    }

    private <T extends ExtendableMessage<?>> void writeExtensions(WireOutput output, ExtensionMap<T> extensionMap) throws IOException {
        for (Extension<T, ?> extension : extensionMap.getExtensions()) {
            Object value = extensionMap.get(extension);
            int tag = extension.getTag();
            Message.Datatype datatype = extension.getDatatype();
            Message.Label label = extension.getLabel();
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    this.writePacked(output, (List)value, tag, datatype);
                    continue;
                }
                this.writeRepeated(output, (List)value, tag, datatype);
                continue;
            }
            this.writeValue(output, tag, value, datatype);
        }
    }

    private void writeRepeated(WireOutput output, List<?> value, int tag, Message.Datatype datatype) throws IOException {
        for (Object o : value) {
            this.writeValue(output, tag, o, datatype);
        }
    }

    private void writePacked(WireOutput output, List<?> value, int tag, Message.Datatype datatype) throws IOException {
        int packedLength = 0;
        for (Object o : value) {
            packedLength += this.getSerializedSizeNoTag(o, datatype);
        }
        output.writeTag(tag, WireType.LENGTH_DELIMITED);
        output.writeVarint32(packedLength);
        for (Object o : value) {
            this.writeValueNoTag(output, o, datatype);
        }
    }

    byte[] toByteArray(M message) {
        byte[] result = new byte[this.getSerializedSize(message)];
        try {
            this.write(message, WireOutput.newInstance(result));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    String toString(M message) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.messageType.getSimpleName());
        sb.append("{");
        String sep = "";
        for (FieldInfo fieldInfo : this.getFields()) {
            Object value = this.getFieldValue(message, fieldInfo);
            if (value == null) continue;
            sb.append(sep);
            sep = ", ";
            sb.append(fieldInfo.name);
            sb.append("=");
            sb.append(value);
        }
        if (message instanceof ExtendableMessage) {
            ExtendableMessage extendableMessage = (ExtendableMessage)message;
            sb.append(sep);
            sb.append("{extensions=");
            sb.append(extendableMessage.extensionsToString());
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    private int getSerializedSize(int tag, Object value, Message.Datatype datatype) {
        return WireOutput.varintTagSize(tag) + this.getSerializedSizeNoTag(value, datatype);
    }

    private int getSerializedSizeNoTag(Object value, Message.Datatype datatype) {
        switch (datatype) {
            case INT32: {
                return WireOutput.int32Size((Integer)value);
            }
            case INT64: 
            case UINT64: {
                return WireOutput.varint64Size((Long)value);
            }
            case UINT32: {
                return WireOutput.varint32Size((Integer)value);
            }
            case SINT32: {
                return WireOutput.varint32Size(WireOutput.zigZag32((Integer)value));
            }
            case SINT64: {
                return WireOutput.varint64Size(WireOutput.zigZag64((Long)value));
            }
            case BOOL: {
                return 1;
            }
            case ENUM: {
                return this.getEnumSize((ProtoEnum)value);
            }
            case STRING: {
                int utf8Length = this.utf8Length((String)value);
                return WireOutput.varint32Size(utf8Length) + utf8Length;
            }
            case BYTES: {
                int length = ((ByteString)value).size();
                return WireOutput.varint32Size(length) + length;
            }
            case MESSAGE: {
                return this.getMessageSize((Message)value);
            }
            case FIXED32: 
            case SFIXED32: 
            case FLOAT: {
                return 4;
            }
            case FIXED64: 
            case SFIXED64: 
            case DOUBLE: {
                return 8;
            }
        }
        throw new RuntimeException();
    }

    private int utf8Length(String s) {
        int count = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }

    private <E extends ProtoEnum> int getEnumSize(E value) {
        EnumAdapter<?> adapter = this.wire.enumAdapter(value.getClass());
        return WireOutput.varint32Size(adapter.toInt(value));
    }

    private <M extends Message> int getMessageSize(M message) {
        int messageSize = message.getSerializedSize();
        return WireOutput.varint32Size(messageSize) + messageSize;
    }

    private void writeValue(WireOutput output, int tag, Object value, Message.Datatype datatype) throws IOException {
        output.writeTag(tag, datatype.wireType());
        this.writeValueNoTag(output, value, datatype);
    }

    private void writeValueNoTag(WireOutput output, Object value, Message.Datatype datatype) throws IOException {
        switch (datatype) {
            case INT32: {
                output.writeSignedVarint32((Integer)value);
                break;
            }
            case INT64: 
            case UINT64: {
                output.writeVarint64((Long)value);
                break;
            }
            case UINT32: {
                output.writeVarint32((Integer)value);
                break;
            }
            case SINT32: {
                output.writeVarint32(WireOutput.zigZag32((Integer)value));
                break;
            }
            case SINT64: {
                output.writeVarint64(WireOutput.zigZag64((Long)value));
                break;
            }
            case BOOL: {
                output.writeRawByte((Boolean)value != false ? 1 : 0);
                break;
            }
            case ENUM: {
                this.writeEnum((ProtoEnum)value, output);
                break;
            }
            case STRING: {
                byte[] bytes = ((String)value).getBytes("UTF-8");
                output.writeVarint32(bytes.length);
                output.writeRawBytes(bytes);
                break;
            }
            case BYTES: {
                ByteString byteString = (ByteString)value;
                output.writeVarint32(byteString.size());
                output.writeRawBytes(byteString.toByteArray());
                break;
            }
            case MESSAGE: {
                this.writeMessage((Message)value, output);
                break;
            }
            case FIXED32: 
            case SFIXED32: {
                output.writeFixed32((Integer)value);
                break;
            }
            case FIXED64: 
            case SFIXED64: {
                output.writeFixed64((Long)value);
                break;
            }
            case FLOAT: {
                output.writeFixed32(Float.floatToIntBits(((Float)value).floatValue()));
                break;
            }
            case DOUBLE: {
                output.writeFixed64(Double.doubleToLongBits((Double)value));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private <M extends Message> void writeMessage(M message, WireOutput output) throws IOException {
        output.writeVarint32(message.getSerializedSize());
        MessageAdapter<?> adapter = this.wire.messageAdapter(message.getClass());
        adapter.write(message, output);
    }

    private <E extends ProtoEnum> void writeEnum(E value, WireOutput output) throws IOException {
        EnumAdapter<?> adapter = this.wire.enumAdapter(value.getClass());
        output.writeVarint32(adapter.toInt(value));
    }

    M read(WireInput input) throws IOException {
        try {
            Message.Builder<M> builder = this.builderType.newInstance();
            Storage storage = new Storage();
            while (true) {
                Object value;
                Message.Label label;
                Message.Datatype datatype;
                FieldInfo fieldInfo;
                Extension<ExtendableMessage<?>, ?> extension = null;
                int tagAndType = input.readTag();
                int tag = tagAndType >> 3;
                WireType wireType = WireType.valueOf(tagAndType);
                if (tag == 0) {
                    for (int storedTag : storage.getTags()) {
                        fieldInfo = this.fieldInfoMap.get(storedTag);
                        if (fieldInfo != null) {
                            this.setBuilderField(builder, storedTag, storage.get(storedTag));
                            continue;
                        }
                        this.setExtension((ExtendableMessage.ExtendableBuilder)builder, this.getExtension(storedTag), storage.get(storedTag));
                    }
                    return builder.build();
                }
                fieldInfo = this.fieldInfoMap.get(tag);
                if (fieldInfo != null) {
                    datatype = fieldInfo.datatype;
                    label = fieldInfo.label;
                } else {
                    extension = this.getExtension(tag);
                    if (extension == null) {
                        this.readUnknownField(builder, input, tag, wireType);
                        continue;
                    }
                    datatype = extension.getDatatype();
                    label = extension.getLabel();
                }
                if (label.isPacked() && wireType == WireType.LENGTH_DELIMITED) {
                    int length = input.readVarint32();
                    long start = input.getPosition();
                    int oldLimit = input.pushLimit(length);
                    while (input.getPosition() < start + (long)length) {
                        value = this.readValue(input, tag, datatype);
                        if (datatype == Message.Datatype.ENUM && value instanceof Integer) {
                            builder.addVarint(tag, ((Integer)value).intValue());
                            continue;
                        }
                        storage.add(tag, value);
                    }
                    input.popLimit(oldLimit);
                    if (input.getPosition() == start + (long)length) continue;
                    throw new IOException("Packed data had wrong length!");
                }
                value = this.readValue(input, tag, datatype);
                if (datatype == Message.Datatype.ENUM && value instanceof Integer) {
                    builder.addVarint(tag, ((Integer)value).intValue());
                    continue;
                }
                if (label.isRepeated()) {
                    storage.add(tag, value);
                    continue;
                }
                if (extension != null) {
                    this.setExtension((ExtendableMessage.ExtendableBuilder)builder, extension, value);
                    continue;
                }
                this.setBuilderField(builder, tag, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Object readValue(WireInput input, int tag, Message.Datatype datatype) throws IOException {
        switch (datatype) {
            case INT32: 
            case UINT32: {
                return input.readVarint32();
            }
            case INT64: 
            case UINT64: {
                return input.readVarint64();
            }
            case SINT32: {
                return WireInput.decodeZigZag32(input.readVarint32());
            }
            case SINT64: {
                return WireInput.decodeZigZag64(input.readVarint64());
            }
            case BOOL: {
                return input.readVarint32() != 0;
            }
            case ENUM: {
                EnumAdapter<ProtoEnum> adapter = this.wire.enumAdapter(this.getEnumClass(tag));
                int value = input.readVarint32();
                try {
                    return adapter.fromInt(value);
                }
                catch (IllegalArgumentException e) {
                    return value;
                }
            }
            case STRING: {
                return input.readString();
            }
            case BYTES: {
                return input.readBytes();
            }
            case MESSAGE: {
                return this.readMessage(input, tag);
            }
            case FIXED32: 
            case SFIXED32: {
                return input.readFixed32();
            }
            case FIXED64: 
            case SFIXED64: {
                return input.readFixed64();
            }
            case FLOAT: {
                return Float.valueOf(Float.intBitsToFloat(input.readFixed32()));
            }
            case DOUBLE: {
                return Double.longBitsToDouble(input.readFixed64());
            }
        }
        throw new RuntimeException();
    }

    private Message readMessage(WireInput input, int tag) throws IOException {
        int length = input.readVarint32();
        if (input.recursionDepth >= 64) {
            throw new IOException("Wire recursion limit exceeded");
        }
        int oldLimit = input.pushLimit(length);
        ++input.recursionDepth;
        MessageAdapter<Message> adapter = this.wire.messageAdapter(this.getMessageClass(tag));
        Message message = adapter.read(input);
        input.checkLastTagWas(0);
        --input.recursionDepth;
        input.popLimit(oldLimit);
        return message;
    }

    private Class<Message> getMessageClass(int tag) {
        Extension<ExtendableMessage<?>, ?> extension;
        Class<Message> messageClass;
        FieldInfo fieldInfo = this.fieldInfoMap.get(tag);
        Class<Message> clazz = messageClass = fieldInfo == null ? null : fieldInfo.messageType;
        if (messageClass == null && (extension = this.getExtension(tag)) != null) {
            messageClass = extension.getMessageType();
        }
        return messageClass;
    }

    private void readUnknownField(Message.Builder builder, WireInput input, int tag, WireType type) throws IOException {
        switch (type) {
            case VARINT: {
                builder.addVarint(tag, input.readVarint64());
                break;
            }
            case FIXED32: {
                builder.addFixed32(tag, input.readFixed32());
                break;
            }
            case FIXED64: {
                builder.addFixed64(tag, input.readFixed64());
                break;
            }
            case LENGTH_DELIMITED: {
                int length = input.readVarint32();
                builder.addLengthDelimited(tag, input.readBytes(length));
                break;
            }
            case START_GROUP: {
                input.skipGroup();
                break;
            }
            case END_GROUP: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported wire type: " + (Object)((Object)type));
            }
        }
    }

    private Extension<ExtendableMessage<?>, ?> getExtension(int tag) {
        ExtensionRegistry registry = this.wire.registry;
        return registry == null ? null : registry.getExtension(this.messageType, tag);
    }

    Extension<ExtendableMessage<?>, ?> getExtension(String name) {
        ExtensionRegistry registry = this.wire.registry;
        return registry == null ? null : registry.getExtension(this.messageType, name);
    }

    private void setExtension(ExtendableMessage.ExtendableBuilder builder, Extension<?, ?> extension, Object value) {
        builder.setExtension(extension, value);
    }

    private Class<? extends ProtoEnum> getEnumClass(int tag) {
        Extension<ExtendableMessage<?>, ?> extension;
        Class<? extends ProtoEnum> enumType;
        FieldInfo fieldInfo = this.fieldInfoMap.get(tag);
        Class<? extends ProtoEnum> clazz = enumType = fieldInfo == null ? null : fieldInfo.enumType;
        if (enumType == null && (extension = this.getExtension(tag)) != null) {
            enumType = extension.getEnumType();
        }
        return enumType;
    }

    private static class Storage {
        private final Map<Integer, List<Object>> map = new LinkedHashMap<Integer, List<Object>>();

        private Storage() {
        }

        void add(int tag, Object value) {
            List<Object> list = this.map.get(tag);
            if (list == null) {
                list = new ArrayList<Object>();
                this.map.put(tag, list);
            }
            list.add(value);
        }

        Set<Integer> getTags() {
            return this.map.keySet();
        }

        List<Object> get(int tag) {
            return this.map.get(tag);
        }
    }

    public static final class FieldInfo {
        final int tag;
        final String name;
        final Message.Datatype datatype;
        final Message.Label label;
        final Class<? extends ProtoEnum> enumType;
        final Class<? extends Message> messageType;
        private final Field messageField;
        private final Method builderMethod;

        private FieldInfo(int tag, String name, Message.Datatype datatype, Message.Label label, Class<?> enumOrMessageType, Field messageField, Method builderMethod) {
            this.tag = tag;
            this.name = name;
            this.datatype = datatype;
            this.label = label;
            if (datatype == Message.Datatype.ENUM) {
                this.enumType = enumOrMessageType;
                this.messageType = null;
            } else if (datatype == Message.Datatype.MESSAGE) {
                this.messageType = enumOrMessageType;
                this.enumType = null;
            } else {
                this.enumType = null;
                this.messageType = null;
            }
            this.messageField = messageField;
            this.builderMethod = builderMethod;
        }
    }
}

