/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ByteString;
import com.squareup.wire.WireType;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class WireInput {
    private static final String UTF_8 = "UTF-8";
    private static final String ENCOUNTERED_A_NEGATIVE_SIZE = "Encountered a negative size";
    private static final String INPUT_ENDED_UNEXPECTEDLY = "The input ended unexpectedly in the middle of a field";
    private static final String PROTOCOL_MESSAGE_CONTAINED_AN_INVALID_TAG_ZERO = "Protocol message contained an invalid tag (zero).";
    private static final String PROTOCOL_MESSAGE_END_GROUP_TAG_DID_NOT_MATCH_EXPECTED_TAG = "Protocol message end-group tag did not match expected tag.";
    private static final String ENCOUNTERED_A_MALFORMED_VARINT = "WireInput encountered a malformed varint.";
    private static final int BUFFER_SIZE = 1024;
    private final InputStream input;
    private final byte[] buffer;
    private long bufferOffset = 0L;
    private int pos = 0;
    private int limit;
    private boolean inputStreamAtEof;
    private int lastTag;
    private int currentLimit = Integer.MAX_VALUE;
    public static final int RECURSION_LIMIT = 64;
    public int recursionDepth;

    public static WireInput newInstance(byte[] buf) {
        return new WireInput(buf, 0, buf.length);
    }

    public static WireInput newInstance(byte[] buf, int offset, int count) {
        return new WireInput(buf, offset, count);
    }

    public static WireInput newInstance(InputStream input) {
        return new WireInput(input);
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readVarint32();
        if (this.lastTag == 0) {
            throw new IOException(PROTOCOL_MESSAGE_CONTAINED_AN_INVALID_TAG_ZERO);
        }
        return this.lastTag;
    }

    public void checkLastTagWas(int value) throws IOException {
        if (this.lastTag != value) {
            throw new IOException(PROTOCOL_MESSAGE_END_GROUP_TAG_DID_NOT_MATCH_EXPECTED_TAG);
        }
    }

    public String readString() throws IOException {
        int count = this.readVarint32();
        if (this.bytesRemaining() >= count) {
            String result = new String(this.buffer, this.pos, count, UTF_8);
            this.pos += count;
            return result;
        }
        return new String(this.readRawBytes(count), UTF_8);
    }

    private int bytesRemaining() {
        return this.limit - this.pos;
    }

    public ByteString readBytes() throws IOException {
        int count = this.readVarint32();
        return this.readBytes(count);
    }

    public ByteString readBytes(int count) throws IOException {
        if (this.bytesRemaining() >= count) {
            ByteString result = ByteString.of(this.buffer, this.pos, count);
            this.pos += count;
            return result;
        }
        return ByteString.of(this.readRawBytes(count));
    }

    public int readVarint32() throws IOException {
        byte tmp = this.readRawByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = this.readRawByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = this.readRawByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = this.readRawByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = this.readRawByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.readRawByte() < 0) continue;
                            return result;
                        }
                        throw new IOException(ENCOUNTERED_A_MALFORMED_VARINT);
                    }
                }
            }
        }
        return result;
    }

    public long readVarint64() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException(ENCOUNTERED_A_MALFORMED_VARINT);
    }

    public int readFixed32() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    public long readFixed64() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        byte b5 = this.readRawByte();
        byte b6 = this.readRawByte();
        byte b7 = this.readRawByte();
        byte b8 = this.readRawByte();
        return (long)b1 & 0xFFL | ((long)b2 & 0xFFL) << 8 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 24 | ((long)b5 & 0xFFL) << 32 | ((long)b6 & 0xFFL) << 40 | ((long)b7 & 0xFFL) << 48 | ((long)b8 & 0xFFL) << 56;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private WireInput(InputStream input) {
        this.input = input;
        this.buffer = new byte[1024];
    }

    private WireInput(byte[] buffer, int start, int count) {
        this.input = null;
        this.buffer = buffer;
        this.bufferOffset = -start;
        this.pos = start;
        this.limit = start + count;
        this.inputStreamAtEof = true;
    }

    private void refillBuffer(int bytesRequested) throws IOException {
        int offset;
        int bytesRead;
        if (this.pos < this.limit || this.inputStreamAtEof) {
            return;
        }
        this.bufferOffset += (long)this.pos;
        this.pos = 0;
        bytesRequested = Math.min(bytesRequested, 1024);
        for (offset = 0; offset < bytesRequested; offset += bytesRead) {
            bytesRead = this.input.read(this.buffer, offset, 1024 - offset);
            if (bytesRead != -1) continue;
            this.limit = offset;
            this.inputStreamAtEof = true;
            return;
        }
        this.limit = offset;
        this.inputStreamAtEof = false;
    }

    public int pushLimit(int byteLimit) throws IOException {
        if (byteLimit < 0) {
            throw new IOException(ENCOUNTERED_A_NEGATIVE_SIZE);
        }
        int oldLimit = this.currentLimit;
        if ((byteLimit = (int)((long)byteLimit + (this.bufferOffset + (long)this.pos))) > oldLimit) {
            throw new EOFException(INPUT_ENDED_UNEXPECTEDLY);
        }
        this.currentLimit = byteLimit;
        return oldLimit;
    }

    public void popLimit(int oldLimit) {
        this.currentLimit = oldLimit;
    }

    public boolean isAtEnd() throws IOException {
        if (this.getPosition() == (long)this.currentLimit) {
            return true;
        }
        this.refillBuffer(1);
        return this.bytesRemaining() == 0 && this.inputStreamAtEof;
    }

    public long getPosition() {
        return this.bufferOffset + (long)this.pos;
    }

    public byte readRawByte() throws IOException {
        this.refillBuffer(1);
        if (this.bytesRemaining() == 0) {
            throw new EOFException(INPUT_ENDED_UNEXPECTEDLY);
        }
        return this.buffer[this.pos++];
    }

    public byte[] readRawBytes(int size) throws IOException {
        int count;
        if (size < 0) {
            throw new IOException(ENCOUNTERED_A_NEGATIVE_SIZE);
        }
        byte[] bytes = new byte[size];
        for (int offset = 0; offset < size; offset += count) {
            this.refillBuffer(size - offset);
            if (this.bytesRemaining() == 0) {
                throw new EOFException(INPUT_ENDED_UNEXPECTEDLY);
            }
            count = Math.min(size - offset, this.bytesRemaining());
            System.arraycopy(this.buffer, this.pos, bytes, offset, count);
            this.pos += count;
        }
        return bytes;
    }

    public void skipGroup() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && !this.skipField(tag)) {
        }
    }

    private boolean skipField(int tag) throws IOException {
        switch (WireType.valueOf(tag)) {
            case VARINT: {
                this.readVarint64();
                return false;
            }
            case FIXED32: {
                this.readFixed32();
                return false;
            }
            case FIXED64: {
                this.readFixed64();
                return false;
            }
            case LENGTH_DELIMITED: {
                this.readRawBytes(this.readVarint32());
                return false;
            }
            case START_GROUP: {
                this.skipGroup();
                this.checkLastTagWas(tag & 0xFFFFFFF8 | WireType.END_GROUP.value());
                return false;
            }
            case END_GROUP: {
                return true;
            }
        }
        throw new AssertionError();
    }
}

