/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.BuilderAdapter;
import com.squareup.wire.EnumAdapter;
import com.squareup.wire.Extension;
import com.squareup.wire.ExtensionRegistry;
import com.squareup.wire.Message;
import com.squareup.wire.MessageAdapter;
import com.squareup.wire.Preconditions;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.WireInput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Wire {
    private final Map<Class<? extends Message>, MessageAdapter<? extends Message>> messageAdapters = new LinkedHashMap<Class<? extends Message>, MessageAdapter<? extends Message>>();
    private final Map<Class<? extends Message.Builder>, BuilderAdapter<? extends Message.Builder>> builderAdapters = new LinkedHashMap<Class<? extends Message.Builder>, BuilderAdapter<? extends Message.Builder>>();
    private final Map<Class<? extends ProtoEnum>, EnumAdapter<? extends ProtoEnum>> enumAdapters = new LinkedHashMap<Class<? extends ProtoEnum>, EnumAdapter<? extends ProtoEnum>>();
    final ExtensionRegistry registry = new ExtensionRegistry();

    public Wire(Class<?> ... extensionClasses) {
        this(Arrays.asList(extensionClasses));
    }

    public Wire(List<Class<?>> extensionClasses) {
        for (Class<?> extensionClass : extensionClasses) {
            for (Field field : extensionClass.getDeclaredFields()) {
                if (!field.getType().equals(Extension.class)) continue;
                try {
                    Extension extension = (Extension)field.get(null);
                    this.registry.add(extension);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    synchronized <M extends Message> MessageAdapter<M> messageAdapter(Class<M> messageType) {
        MessageAdapter<Message> adapter = this.messageAdapters.get(messageType);
        if (adapter == null) {
            adapter = new MessageAdapter<M>(this, messageType);
            this.messageAdapters.put(messageType, adapter);
        }
        return adapter;
    }

    synchronized <B extends Message.Builder> BuilderAdapter<B> builderAdapter(Class<B> builderType) {
        BuilderAdapter<Message.Builder<Object>> adapter = this.builderAdapters.get(builderType);
        if (adapter == null) {
            adapter = new BuilderAdapter<B>(builderType);
            this.builderAdapters.put(builderType, adapter);
        }
        return adapter;
    }

    synchronized <E extends ProtoEnum> EnumAdapter<E> enumAdapter(Class<E> enumClass) {
        EnumAdapter<ProtoEnum> adapter = this.enumAdapters.get(enumClass);
        if (adapter == null) {
            adapter = new EnumAdapter<E>(enumClass);
            this.enumAdapters.put(enumClass, adapter);
        }
        return adapter;
    }

    public <M extends Message> M parseFrom(byte[] bytes, Class<M> messageClass) throws IOException {
        Preconditions.checkNotNull(bytes, "bytes");
        Preconditions.checkNotNull(messageClass, "messageClass");
        return this.parseFrom(WireInput.newInstance(bytes), messageClass);
    }

    public <M extends Message> M parseFrom(byte[] bytes, int offset, int count, Class<M> messageClass) throws IOException {
        Preconditions.checkNotNull(bytes, "bytes");
        Preconditions.checkArgument(offset >= 0, "offset < 0");
        Preconditions.checkArgument(count >= 0, "count < 0");
        Preconditions.checkArgument(offset + count <= bytes.length, "offset + count > bytes");
        Preconditions.checkNotNull(messageClass, "messageClass");
        return this.parseFrom(WireInput.newInstance(bytes, offset, count), messageClass);
    }

    public <M extends Message> M parseFrom(InputStream input, Class<M> messageClass) throws IOException {
        Preconditions.checkNotNull(input, "input");
        Preconditions.checkNotNull(messageClass, "messageClass");
        return this.parseFrom(WireInput.newInstance(input), messageClass);
    }

    private <M extends Message> M parseFrom(WireInput input, Class<M> messageClass) throws IOException {
        MessageAdapter<M> adapter = this.messageAdapter(messageClass);
        return adapter.read(input);
    }

    public static <T> T get(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }
}

