/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ProtoEnum;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

final class EnumAdapter<E extends Enum> {
    private final Map<Integer, E> fromInt = new LinkedHashMap<Integer, E>();
    private final Map<E, Integer> toInt = new LinkedHashMap<E, Integer>();

    EnumAdapter(Class<E> type) {
        for (Enum value : (Enum[])type.getEnumConstants()) {
            try {
                Field f = type.getField(value.name());
                if (!f.isAnnotationPresent(ProtoEnum.class)) continue;
                ProtoEnum annotation = f.getAnnotation(ProtoEnum.class);
                int tag = annotation.value();
                this.fromInt.put(tag, value);
                this.toInt.put(value, tag);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int toInt(E e) {
        return this.toInt.get(e);
    }

    public E fromInt(int value) {
        return (E)((Enum)this.fromInt.get(value));
    }
}

