/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireEnumConstant;
import com.squareup.wire.internal.JsonFormatter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/squareup/wire/internal/EnumJsonFormatter;", "E", "Lcom/squareup/wire/WireEnum;", "Lcom/squareup/wire/internal/JsonFormatter;", "adapter", "Lcom/squareup/wire/EnumAdapter;", "<init>", "(Lcom/squareup/wire/EnumAdapter;)V", "stringToValue", "", "", "valueToString", "unrecognizedClassConstructor", "Ljava/lang/reflect/Constructor;", "fromString", "value", "(Ljava/lang/String;)Lcom/squareup/wire/WireEnum;", "toStringOrNumber", "", "(Lcom/squareup/wire/WireEnum;)Ljava/lang/Object;", "wire-runtime"})
@SourceDebugExtension(value={"SMAP\nEnumJsonFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumJsonFormatter.kt\ncom/squareup/wire/internal/EnumJsonFormatter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1400#2,2:107\n1#3:109\n*S KotlinDebug\n*F\n+ 1 EnumJsonFormatter.kt\ncom/squareup/wire/internal/EnumJsonFormatter\n*L\n62#1:107,2\n*E\n"})
public final class EnumJsonFormatter<E extends WireEnum>
implements JsonFormatter<E> {
    @NotNull
    private final Map<String, E> stringToValue;
    @NotNull
    private final Map<E, String> valueToString;
    @Nullable
    private Constructor<E> unrecognizedClassConstructor;

    public EnumJsonFormatter(@NotNull EnumAdapter<E> adapter) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Map mutableStringToValue = new LinkedHashMap();
        Map mutableValueToString = new LinkedHashMap();
        KClass<?> kClass = adapter.getType();
        Intrinsics.checkNotNull(kClass);
        Class clazz = JvmClassMappingKt.getJavaClass(kClass);
        Intrinsics.checkNotNull((Object)clazz, (String)"null cannot be cast to non-null type java.lang.Class<E of com.squareup.wire.internal.EnumJsonFormatter>");
        Class enumType = clazz;
        WireEnum[] enumConstants = (WireEnum[])enumType.getEnumConstants();
        if (enumConstants == null) {
            Class<?>[] classArray = enumType.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
            for (Class<?> subClass : classArray) {
                String name = subClass.getSimpleName();
                if (Intrinsics.areEqual((Object)name, (Object)"Companion")) continue;
                Field[] fieldArray = subClass.getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
                Field field = (Field)ArraysKt.first((Object[])fieldArray);
                if (Intrinsics.areEqual((Object)field.getName(), (Object)"INSTANCE")) {
                    WireEnumConstant wireEnumConstant;
                    Object object;
                    WireEnum subClassInstance;
                    block6: {
                        Object object2 = field.get(null);
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type E of com.squareup.wire.internal.EnumJsonFormatter");
                        subClassInstance = (WireEnum)object2;
                        mutableStringToValue.put(subClass.getSimpleName(), subClassInstance);
                        mutableStringToValue.put(String.valueOf(subClassInstance.getValue()), subClassInstance);
                        mutableValueToString.put(subClassInstance, name);
                        Annotation[] annotationArray = subClass.getAnnotations();
                        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"getAnnotations(...)");
                        Object[] $this$firstOrNull$iv = annotationArray;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Annotation it = (Annotation)element$iv;
                            boolean bl = false;
                            if (!(it instanceof WireEnumConstant)) continue;
                            object = element$iv;
                            break block6;
                        }
                        object = null;
                    }
                    Object object3 = object;
                    WireEnumConstant wireEnumConstant2 = wireEnumConstant = object3 instanceof WireEnumConstant ? (WireEnumConstant)object3 : null;
                    if (wireEnumConstant == null || !(((CharSequence)wireEnumConstant.declaredName()).length() > 0)) continue;
                    mutableStringToValue.put(wireEnumConstant.declaredName(), subClassInstance);
                    mutableValueToString.put(subClassInstance, wireEnumConstant.declaredName());
                    continue;
                }
                Constructor<?>[] constructorArray = subClass.getConstructors();
                Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getConstructors(...)");
                Object object = ArraysKt.first((Object[])constructorArray);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.reflect.Constructor<E of com.squareup.wire.internal.EnumJsonFormatter>");
                this.unrecognizedClassConstructor = (Constructor)object;
            }
        } else {
            for (WireEnum constant : enumConstants) {
                Intrinsics.checkNotNull((Object)constant, (String)"null cannot be cast to non-null type kotlin.Enum<*>");
                String name = ((Enum)((Object)constant)).name();
                mutableStringToValue.put(name, constant);
                mutableStringToValue.put(String.valueOf(constant.getValue()), constant);
                mutableValueToString.put(constant, name);
                Field constantField = enumType.getDeclaredField(name);
                WireEnumConstant wireEnumConstant = constantField.getAnnotation(WireEnumConstant.class);
                if (wireEnumConstant == null || !(((CharSequence)wireEnumConstant.declaredName()).length() > 0)) continue;
                mutableStringToValue.put(wireEnumConstant.declaredName(), constant);
                mutableValueToString.put(constant, wireEnumConstant.declaredName());
            }
        }
        this.stringToValue = mutableStringToValue;
        this.valueToString = mutableValueToString;
    }

    @Override
    @Nullable
    public E fromString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        WireEnum wireEnum = (WireEnum)this.stringToValue.get(value);
        if (wireEnum == null) {
            Integer n = StringsKt.toIntOrNull((String)value);
            if (n != null) {
                int value2 = ((Number)n).intValue();
                boolean bl = false;
                Constructor<E> constructor = this.unrecognizedClassConstructor;
                if (constructor != null) {
                    Object[] objectArray = new Object[]{value2};
                    wireEnum = (WireEnum)constructor.newInstance(objectArray);
                } else {
                    wireEnum = null;
                }
            } else {
                wireEnum = null;
            }
        }
        return (E)wireEnum;
    }

    @Override
    @NotNull
    public Object toStringOrNumber(@NotNull E value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Object object = this.valueToString.get(value);
        if (object == null) {
            object = value.getValue();
        }
        return object;
    }
}

