/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.reflector;

import com.squareup.wire.GrpcStatus;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.SchemaEncoder;
import grpc.reflection.v1alpha.ErrorResponse;
import grpc.reflection.v1alpha.FileDescriptorResponse;
import grpc.reflection.v1alpha.ListServiceResponse;
import grpc.reflection.v1alpha.ServerReflectionRequest;
import grpc.reflection.v1alpha.ServerReflectionResponse;
import grpc.reflection.v1alpha.ServiceResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0006H\u0002J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/squareup/wire/reflector/SchemaReflector;", "", "schema", "Lcom/squareup/wire/schema/Schema;", "(Lcom/squareup/wire/schema/Schema;)V", "fileByFilename", "Lgrpc/reflection/v1alpha/ServerReflectionResponse;", "request", "Lgrpc/reflection/v1alpha/ServerReflectionRequest;", "fileContainingSymbol", "file_containing_symbol", "", "listServices", "process", "toFileDescriptorResponse", "Lgrpc/reflection/v1alpha/FileDescriptorResponse;", "Lokio/ByteString;", "wire-reflector"})
public final class SchemaReflector {
    private final Schema schema;

    @NotNull
    public final ServerReflectionResponse process(@NotNull ServerReflectionRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return request.getList_services() != null ? this.listServices() : (request.getFile_by_filename() != null ? this.fileByFilename(request) : (request.getFile_containing_symbol() != null ? this.fileContainingSymbol(request.getFile_containing_symbol()) : new ServerReflectionResponse(null, request, null, null, null, new ErrorResponse(GrpcStatus.INVALID_ARGUMENT.getCode(), "unsupported request", null, 4, null), null, 93, null)));
    }

    private final ServerReflectionResponse listServices() {
        boolean bl = false;
        List allServiceNames = new ArrayList();
        for (ProtoFile protoFile : this.schema.getProtoFiles()) {
            for (Service service : protoFile.getServices()) {
                String packagePrefix = protoFile.getPackageName() != null ? Intrinsics.stringPlus((String)protoFile.getPackageName(), (Object)".") : "";
                String serviceName = packagePrefix + service.name();
                Collection collection = allServiceNames;
                ServiceResponse serviceResponse = new ServiceResponse(serviceName, null, 2, null);
                boolean bl2 = false;
                collection.add(serviceResponse);
            }
        }
        return new ServerReflectionResponse(null, null, null, null, new ListServiceResponse(allServiceNames, null, 2, null), null, null, 111, null);
    }

    private final ServerReflectionResponse fileByFilename(ServerReflectionRequest request) {
        String string = request.getFile_by_filename();
        Intrinsics.checkNotNull((Object)string);
        ProtoFile protoFile = this.schema.protoFile(string);
        Intrinsics.checkNotNull((Object)protoFile);
        ProtoFile protoFile2 = protoFile;
        return new ServerReflectionResponse(null, null, this.toFileDescriptorResponse(new SchemaEncoder(this.schema).encode(protoFile2)), null, null, null, null, 123, null);
    }

    private final ServerReflectionResponse fileContainingSymbol(String file_containing_symbol) {
        String symbol = StringsKt.removePrefix((String)file_containing_symbol, (CharSequence)".");
        Service service = this.schema.getService(symbol);
        Location location = null;
        if (service != null) {
            location = service.location();
        } else {
            Type type = this.schema.getType(symbol);
            if (type != null) {
                location = type.getLocation();
            } else {
                String method = StringsKt.substringAfterLast$default((String)symbol, (String)".", null, (int)2, null);
                String fullServiceName = StringsKt.substringBeforeLast$default((String)symbol, (String)".", null, (int)2, null);
                Service serviceWithMethod = this.schema.getService(fullServiceName);
                if (serviceWithMethod != null) {
                    location = serviceWithMethod.location();
                } else {
                    String string = "TODO: fail the call somehow?";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
        ProtoFile protoFile = this.schema.protoFile(location.getPath());
        Intrinsics.checkNotNull((Object)protoFile);
        ProtoFile protoFile2 = protoFile;
        FileDescriptorResponse result = this.toFileDescriptorResponse(new SchemaEncoder(this.schema).encode(protoFile2));
        return new ServerReflectionResponse(null, null, result, null, null, null, null, 123, null);
    }

    private final FileDescriptorResponse toFileDescriptorResponse(ByteString $this$toFileDescriptorResponse) {
        return new FileDescriptorResponse(CollectionsKt.listOf((Object)$this$toFileDescriptorResponse), null, 2, null);
    }

    public SchemaReflector(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.schema = schema;
    }
}

