/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.squareup.wire.Message;
import com.squareup.wire.MessageJsonAdapter;
import com.squareup.wire.Uint64;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/squareup/wire/WireJsonAdapterFactory;", "Lcom/squareup/moshi/JsonAdapter$Factory;", "()V", "create", "Lcom/squareup/moshi/JsonAdapter;", "type", "Ljava/lang/reflect/Type;", "annotations", "", "", "moshi", "Lcom/squareup/moshi/Moshi;", "Companion", "wire-moshi-adapter"})
public final class WireJsonAdapterFactory
implements JsonAdapter.Factory {
    private static final JsonAdapter<ByteString> BYTE_STRING_JSON_ADAPTER;
    private static final JsonAdapter<Long> UINT64_JSON_ADAPTER;
    private static final JsonAdapter<List<Long>> LIST_OF_UINT64_JSON_ADAPTER;
    public static final Companion Companion;

    @Nullable
    public JsonAdapter<?> create(@NotNull Type type, @NotNull Set<? extends Annotation> annotations, @NotNull Moshi moshi) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)moshi, (String)"moshi");
        if ((type == Long.class || type == Long.TYPE) && Types.nextAnnotations(annotations, Uint64.class) != null) {
            return UINT64_JSON_ADAPTER;
        }
        Class rawType = Types.getRawType((Type)type);
        if (Intrinsics.areEqual((Object)rawType, List.class) && ((ParameterizedType)type).getActualTypeArguments()[0] == Long.class && Types.nextAnnotations(annotations, Uint64.class) != null) {
            return LIST_OF_UINT64_JSON_ADAPTER;
        }
        Collection collection = annotations;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return null;
        }
        if (Intrinsics.areEqual((Object)rawType, ByteString.class)) {
            return BYTE_STRING_JSON_ADAPTER;
        }
        return Message.class.isAssignableFrom(rawType) ? (JsonAdapter)new MessageJsonAdapter(moshi, type) : null;
    }

    static {
        Companion = new Companion(null);
        BYTE_STRING_JSON_ADAPTER = new JsonAdapter<ByteString>(){

            public void toJson(@NotNull JsonWriter out, @Nullable ByteString byteString) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                ByteString byteString2 = byteString;
                out.value(byteString2 != null ? byteString2.base64() : null);
            }

            @Nullable
            public ByteString fromJson(@NotNull JsonReader input) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                String string = input.nextString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"input.nextString()");
                return ByteString.Companion.decodeBase64(string);
            }
        }.nullSafe();
        UINT64_JSON_ADAPTER = new JsonAdapter<Long>(){
            private final BigInteger power64;
            private final BigInteger maxLong;

            @Nullable
            public Long fromJson(@NotNull JsonReader reader) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
                BigInteger bigInteger = new BigInteger(reader.nextString());
                return bigInteger.compareTo(this.maxLong) > 0 ? Long.valueOf(bigInteger.subtract(this.power64).longValue()) : Long.valueOf(bigInteger.longValue());
            }

            public void toJson(@NotNull JsonWriter writer, @Nullable Long value) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                Long l = value;
                if (l == null) {
                    Intrinsics.throwNpe();
                }
                if (l < 0L) {
                    BigInteger unsigned = this.power64.add(BigInteger.valueOf(value));
                    writer.value((Number)unsigned);
                } else {
                    writer.value(value.longValue());
                }
            }
            {
                this.power64 = new BigInteger("18446744073709551616");
                this.maxLong = BigInteger.valueOf(Long.MAX_VALUE);
            }
        }.nullSafe();
        LIST_OF_UINT64_JSON_ADAPTER = new JsonAdapter<List<? extends Long>>(){

            @Nullable
            public List<Long> fromJson(@NotNull JsonReader reader) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
                ArrayList<Object> result = new ArrayList<Object>();
                reader.beginArray();
                while (reader.hasNext()) {
                    Object object = WireJsonAdapterFactory.Companion.getUINT64_JSON_ADAPTER$wire_moshi_adapter().fromJson(reader);
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                    result.add(object);
                }
                reader.endArray();
                return result;
            }

            public void toJson(@NotNull JsonWriter writer, @Nullable List<Long> value) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                writer.beginArray();
                List<Long> list = value;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                Iterator<Long> iterator = list.iterator();
                while (iterator.hasNext()) {
                    long v = ((Number)iterator.next()).longValue();
                    WireJsonAdapterFactory.Companion.getUINT64_JSON_ADAPTER$wire_moshi_adapter().toJson(writer, (Object)v);
                }
                writer.endArray();
            }
        }.nullSafe();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bRP\u0010\t\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000b \u0006*\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n \u0006*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000b \u0006*\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR8\u0010\r\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/squareup/wire/WireJsonAdapterFactory$Companion;", "", "()V", "BYTE_STRING_JSON_ADAPTER", "Lcom/squareup/moshi/JsonAdapter;", "Lokio/ByteString;", "kotlin.jvm.PlatformType", "getBYTE_STRING_JSON_ADAPTER$wire_moshi_adapter", "()Lcom/squareup/moshi/JsonAdapter;", "LIST_OF_UINT64_JSON_ADAPTER", "", "", "getLIST_OF_UINT64_JSON_ADAPTER$wire_moshi_adapter", "UINT64_JSON_ADAPTER", "getUINT64_JSON_ADAPTER$wire_moshi_adapter", "wire-moshi-adapter"})
    public static final class Companion {
        public final JsonAdapter<ByteString> getBYTE_STRING_JSON_ADAPTER$wire_moshi_adapter() {
            return BYTE_STRING_JSON_ADAPTER;
        }

        public final JsonAdapter<Long> getUINT64_JSON_ADAPTER$wire_moshi_adapter() {
            return UINT64_JSON_ADAPTER;
        }

        public final JsonAdapter<List<Long>> getLIST_OF_UINT64_JSON_ADAPTER$wire_moshi_adapter() {
            return LIST_OF_UINT64_JSON_ADAPTER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

