/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.java;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import com.squareup.wire.Extension;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoType;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.lang.model.element.Modifier;
import okio.ByteString;

public final class JavaGenerator {
    static final ClassName BYTE_STRING = ClassName.get(ByteString.class);
    static final ClassName STRING = ClassName.get(String.class);
    static final ClassName LIST = ClassName.get(List.class);
    static final ClassName MESSAGE = ClassName.get(Message.class);
    static final ClassName ADAPTER = ClassName.get(ProtoAdapter.class);
    static final ClassName BUILDER = ClassName.get(Message.Builder.class);
    static final ClassName EXTENSION = ClassName.get(Extension.class);
    static final TypeName MESSAGE_OPTIONS = ClassName.get((String)"com.google.protobuf", (String)"MessageOptions", (String[])new String[0]);
    static final TypeName FIELD_OPTIONS = ClassName.get((String)"com.google.protobuf", (String)"FieldOptions", (String[])new String[0]);
    static final TypeName ENUM_OPTIONS = ClassName.get((String)"com.google.protobuf", (String)"EnumOptions", (String[])new String[0]);
    private static final ImmutableSet<String> JAVA_KEYWORDS = ImmutableSet.of((Object)"abstract", (Object)"assert", (Object)"boolean", (Object)"break", (Object)"byte", (Object)"case", (Object[])new String[]{"catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"});
    private static final Map<ProtoType, TypeName> SCALAR_TYPES_MAP = ImmutableMap.builder().put((Object)ProtoType.BOOL, (Object)TypeName.BOOLEAN.box()).put((Object)ProtoType.BYTES, (Object)ClassName.get(ByteString.class)).put((Object)ProtoType.DOUBLE, (Object)TypeName.DOUBLE.box()).put((Object)ProtoType.FLOAT, (Object)TypeName.FLOAT.box()).put((Object)ProtoType.FIXED32, (Object)TypeName.INT.box()).put((Object)ProtoType.FIXED64, (Object)TypeName.LONG.box()).put((Object)ProtoType.INT32, (Object)TypeName.INT.box()).put((Object)ProtoType.INT64, (Object)TypeName.LONG.box()).put((Object)ProtoType.SFIXED32, (Object)TypeName.INT.box()).put((Object)ProtoType.SFIXED64, (Object)TypeName.LONG.box()).put((Object)ProtoType.SINT32, (Object)TypeName.INT.box()).put((Object)ProtoType.SINT64, (Object)TypeName.LONG.box()).put((Object)ProtoType.STRING, (Object)ClassName.get(String.class)).put((Object)ProtoType.UINT32, (Object)TypeName.INT.box()).put((Object)ProtoType.UINT64, (Object)TypeName.LONG.box()).build();
    private static final String URL_CHARS = "[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]";
    private final Schema schema;
    private final ImmutableMap<ProtoType, TypeName> nameToJavaName;
    private final ImmutableMap<Field, ProtoFile> extensionFieldToFile;
    private final boolean emitOptions;
    private final ImmutableSet<String> enumOptions;

    private JavaGenerator(Schema schema, ImmutableMap<ProtoType, TypeName> nameToJavaName, ImmutableMap<Field, ProtoFile> extensionFieldToFile, boolean emitOptions, ImmutableSet<String> enumOptions) {
        this.schema = schema;
        this.nameToJavaName = nameToJavaName;
        this.extensionFieldToFile = extensionFieldToFile;
        this.emitOptions = emitOptions;
        this.enumOptions = enumOptions;
    }

    public JavaGenerator withOptions(boolean emitOptions, Collection<String> enumOptions) {
        return new JavaGenerator(this.schema, this.nameToJavaName, this.extensionFieldToFile, emitOptions, (ImmutableSet<String>)ImmutableSet.copyOf(enumOptions));
    }

    public static JavaGenerator get(Schema schema) {
        ImmutableMap.Builder nameToJavaName = ImmutableMap.builder();
        ImmutableMap.Builder extensionFieldToFile = ImmutableMap.builder();
        nameToJavaName.putAll(SCALAR_TYPES_MAP);
        for (ProtoFile protoFile : schema.protoFiles()) {
            String javaPackage = JavaGenerator.javaPackage(protoFile);
            JavaGenerator.putAll((ImmutableMap.Builder<ProtoType, TypeName>)nameToJavaName, javaPackage, null, (List<Type>)protoFile.types());
            for (Extend extend : protoFile.extendList()) {
                for (Field field : extend.fields()) {
                    extensionFieldToFile.put((Object)field, (Object)protoFile);
                }
            }
            for (Service service : protoFile.services()) {
                ClassName className = ClassName.get((String)javaPackage, (String)service.type().simpleName(), (String[])new String[0]);
                nameToJavaName.put((Object)service.type(), (Object)className);
            }
        }
        return new JavaGenerator(schema, (ImmutableMap<ProtoType, TypeName>)nameToJavaName.build(), (ImmutableMap<Field, ProtoFile>)extensionFieldToFile.build(), false, (ImmutableSet<String>)ImmutableSet.of());
    }

    private static void putAll(ImmutableMap.Builder<ProtoType, TypeName> wireToJava, String javaPackage, ClassName enclosingClassName, List<Type> types) {
        for (Type type : types) {
            ClassName className = enclosingClassName != null ? enclosingClassName.nestedClass(type.name().simpleName()) : ClassName.get((String)javaPackage, (String)type.name().simpleName(), (String[])new String[0]);
            wireToJava.put((Object)type.name(), (Object)className);
            JavaGenerator.putAll(wireToJava, javaPackage, className, (List<Type>)type.nestedTypes());
        }
    }

    public Schema schema() {
        return this.schema;
    }

    public ClassName extensionsClass(ProtoFile protoFile) {
        return ClassName.get((String)JavaGenerator.javaPackage(protoFile), (String)("Ext_" + protoFile.name()), (String[])new String[0]);
    }

    public ClassName extensionsClass(Field field) {
        ProtoFile protoFile = (ProtoFile)this.extensionFieldToFile.get((Object)field);
        return protoFile != null ? this.extensionsClass(protoFile) : null;
    }

    public TypeName typeName(ProtoType protoType) {
        TypeName candidate = (TypeName)this.nameToJavaName.get((Object)protoType);
        Preconditions.checkArgument((candidate != null ? 1 : 0) != 0, (String)"unexpected type %s", (Object[])new Object[]{protoType});
        return candidate;
    }

    private static String javaPackage(ProtoFile protoFile) {
        Object javaPackageOption = protoFile.options().get("java_package");
        if (javaPackageOption != null) {
            return String.valueOf(javaPackageOption);
        }
        if (protoFile.packageName() != null) {
            return protoFile.packageName();
        }
        return "";
    }

    public boolean isEnum(ProtoType type) {
        return this.schema.getType(type) instanceof EnumType;
    }

    EnumConstant enumDefault(ProtoType type) {
        EnumType wireEnum = (EnumType)this.schema.getType(type);
        return (EnumConstant)wireEnum.constants().get(0);
    }

    static TypeName listOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)LIST, (TypeName[])new TypeName[]{type});
    }

    static TypeName messageOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)MESSAGE, (TypeName[])new TypeName[]{type});
    }

    static TypeName adapterOf(TypeName messageType) {
        return ParameterizedTypeName.get((ClassName)ADAPTER, (TypeName[])new TypeName[]{messageType});
    }

    static TypeName builderOf(TypeName messageType, ClassName builderType) {
        return ParameterizedTypeName.get((ClassName)BUILDER, (TypeName[])new TypeName[]{messageType, builderType});
    }

    static TypeName extensionOf(TypeName messageType, TypeName fieldType) {
        return ParameterizedTypeName.get((ClassName)EXTENSION, (TypeName[])new TypeName[]{messageType, fieldType});
    }

    static String sanitizeJavadoc(String documentation) {
        documentation = documentation.replaceAll("[^\\S\n]+\n", "\n");
        documentation = documentation.replaceAll("\\s+$", "");
        documentation = documentation.replaceAll("@see (http:[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]+)", "@see <a href=\"$1\">$1</a>");
        return documentation;
    }

    public TypeSpec generateEnum(EnumType type) {
        FieldSpec options;
        ClassName javaType = (ClassName)this.typeName(type.name());
        TypeSpec.Builder builder = TypeSpec.enumBuilder((String)javaType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(WireEnum.class);
        if (!type.documentation().isEmpty()) {
            builder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(type.documentation())});
        }
        builder.addField(TypeName.INT, "value", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
        constructorBuilder.addStatement("this.value = value", new Object[0]);
        constructorBuilder.addParameter(TypeName.INT, "value", new Modifier[0]);
        LinkedHashSet<Field> allOptionFieldsBuilder = new LinkedHashSet<Field>();
        for (EnumConstant constant : type.constants()) {
            for (Field optionField : constant.options().map().keySet()) {
                String fullyQualifiedName = optionField.packageName() + "." + optionField.name();
                if (!this.enumOptions.contains((Object)fullyQualifiedName) || !allOptionFieldsBuilder.add(optionField)) continue;
                TypeName optionJavaType = this.typeName(optionField.type());
                builder.addField(optionJavaType, optionField.name(), new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
                constructorBuilder.addParameter(optionJavaType, optionField.name(), new Modifier[0]);
                constructorBuilder.addStatement("this.$L = $L", new Object[]{optionField.name(), optionField.name()});
            }
        }
        ImmutableList allOptionFields = ImmutableList.copyOf(allOptionFieldsBuilder);
        String enumArgsFormat = "$L" + Strings.repeat((String)", $L", (int)allOptionFields.size());
        builder.addMethod(constructorBuilder.build());
        for (EnumConstant constant : type.constants()) {
            Object[] enumArgs = new Object[allOptionFields.size() + 1];
            enumArgs[0] = constant.tag();
            for (int i = 0; i < allOptionFields.size(); ++i) {
                Field key = (Field)allOptionFields.get(i);
                Object value = constant.options().map().get(key);
                enumArgs[i + 1] = value != null ? this.fieldInitializer(key.type(), value) : null;
            }
            TypeSpec.Builder constantBuilder = TypeSpec.anonymousClassBuilder((String)enumArgsFormat, (Object[])enumArgs);
            if (!constant.documentation().isEmpty()) {
                constantBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(constant.documentation())});
            }
            builder.addEnumConstant(constant.name(), constantBuilder.build());
        }
        builder.addField(FieldSpec.builder((TypeName)JavaGenerator.adapterOf((TypeName)javaType), (String)"ADAPTER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.forEnum($T.class)", new Object[]{ProtoAdapter.class, javaType}).build());
        if (this.emitOptions && (options = this.optionsField(ENUM_OPTIONS, "ENUM_OPTIONS", type.options())) != null) {
            builder.addField(options);
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"getValue").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.INT).addStatement("return value", new Object[0]).build());
        return builder.build();
    }

    public TypeSpec generateMessage(MessageType type) {
        ClassName javaType = (ClassName)this.typeName(type.name());
        ClassName builderJavaType = javaType.nestedClass("Builder");
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)javaType.simpleName());
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        if (javaType.enclosingClassName() != null) {
            builder.addModifiers(new Modifier[]{Modifier.STATIC});
        }
        if (!type.documentation().isEmpty()) {
            builder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(type.documentation())});
        }
        builder.superclass(JavaGenerator.messageOf((TypeName)javaType));
        builder.addField(FieldSpec.builder((TypeName)JavaGenerator.adapterOf((TypeName)javaType), (String)"ADAPTER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.forMessage($T.class)", new Object[]{ProtoAdapter.class, javaType}).build());
        builder.addField(FieldSpec.builder((TypeName)TypeName.LONG, (String)"serialVersionUID", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$LL", new Object[]{0L}).build());
        if (this.emitOptions) {
            FieldSpec messageOptions = this.optionsField(MESSAGE_OPTIONS, "MESSAGE_OPTIONS", type.options());
            if (messageOptions != null) {
                builder.addField(messageOptions);
            }
            for (Field field : type.fieldsAndOneOfFields()) {
                String fieldName = "FIELD_OPTIONS_" + field.name().toUpperCase(Locale.US);
                FieldSpec fieldOptions = this.optionsField(FIELD_OPTIONS, fieldName, field.options());
                if (fieldOptions == null) continue;
                builder.addField(fieldOptions);
            }
        }
        for (Field field : type.fieldsAndOneOfFields()) {
            TypeName fieldJavaType = this.fieldType(field);
            if ((field.type().isScalar() || this.isEnum(field.type())) && !field.isRepeated() && !field.isPacked()) {
                builder.addField(this.defaultField(field, fieldJavaType));
            }
            String name = JavaGenerator.sanitize(field.name());
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)fieldJavaType, (String)name, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            fieldBuilder.addAnnotation(this.wireFieldAnnotation(field));
            if (!field.documentation().isEmpty()) {
                fieldBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(field.documentation())});
            }
            if (field.isDeprecated()) {
                fieldBuilder.addAnnotation(Deprecated.class);
            }
            builder.addField(fieldBuilder.build());
        }
        builder.addMethod(this.messageFieldsConstructor(type));
        builder.addMethod(this.messageBuilderConstructor(type, builderJavaType));
        builder.addMethod(this.messageEquals(type));
        builder.addMethod(this.messageHashCode(type));
        builder.addType(this.builder(type, javaType, builderJavaType));
        for (Type nestedType : type.nestedTypes()) {
            TypeSpec typeSpec = nestedType instanceof MessageType ? this.generateMessage((MessageType)nestedType) : this.generateEnum((EnumType)nestedType);
            builder.addType(typeSpec);
        }
        return builder.build();
    }

    private FieldSpec optionsField(TypeName optionsType, String fieldName, Options options) {
        CodeBlock.Builder initializer = CodeBlock.builder();
        initializer.add("$[new $T.Builder()", new Object[]{optionsType});
        boolean empty = true;
        for (Map.Entry entry : options.map().entrySet()) {
            Field extensionRoot = (Field)entry.getKey();
            if (extensionRoot.name().equals("default") || extensionRoot.name().equals("deprecated") || extensionRoot.name().equals("packed")) continue;
            ClassName extensionClass = this.extensionsClass(extensionRoot);
            initializer.add("\n.setExtension($T.$L, $L)", new Object[]{extensionClass, extensionRoot.name(), this.fieldInitializer(extensionRoot.type(), entry.getValue())});
            empty = false;
        }
        initializer.add("\n.build()$]", new Object[0]);
        if (empty) {
            return null;
        }
        return FieldSpec.builder((TypeName)optionsType, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(initializer.build()).build();
    }

    private TypeName fieldType(Field field) {
        TypeName messageType = this.typeName(field.type());
        return field.isRepeated() ? JavaGenerator.listOf(messageType) : messageType;
    }

    private FieldSpec defaultField(Field field, TypeName fieldType) {
        String defaultFieldName = "DEFAULT_" + field.name().toUpperCase(Locale.US);
        return FieldSpec.builder((TypeName)fieldType, (String)defaultFieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(this.defaultValue(field)).build();
    }

    private AnnotationSpec wireFieldAnnotation(Field field) {
        AnnotationSpec.Builder result = AnnotationSpec.builder(WireField.class);
        int tag = field.tag();
        result.addMember("tag", String.valueOf(tag), new Object[0]);
        result.addMember("adapter", "$S", new Object[]{this.adapterString(field.type())});
        if (!field.isOptional()) {
            if (field.isPacked()) {
                result.addMember("label", "$T.PACKED", new Object[]{WireField.Label.class});
            } else if (field.label() != null) {
                result.addMember("label", "$T.$L", new Object[]{WireField.Label.class, field.label()});
            }
        }
        if (field.isDeprecated()) {
            result.addMember("deprecated", "true", new Object[0]);
        }
        if (field.options().optionMatches(".*\\.redacted", "true")) {
            result.addMember("redacted", "true", new Object[0]);
        }
        return result.build();
    }

    private String adapterString(ProtoType type) {
        return type.isScalar() ? ProtoAdapter.class.getName() + '#' + type.toString().toUpperCase(Locale.US) : this.reflectionName((ClassName)this.typeName(type)) + "#ADAPTER";
    }

    private String reflectionName(ClassName className) {
        return className.packageName() + '.' + Joiner.on((char)'$').join((Iterable)className.simpleNames());
    }

    private MethodSpec messageFieldsConstructor(MessageType type) {
        MethodSpec.Builder result = MethodSpec.constructorBuilder();
        result.addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Field field : type.fieldsAndOneOfFields()) {
            TypeName javaType = this.fieldType(field);
            String sanitizedName = JavaGenerator.sanitize(field.name());
            result.addParameter(javaType, sanitizedName, new Modifier[0]);
            if (field.isRepeated()) {
                result.addStatement("this.$L = immutableCopyOf($L)", new Object[]{sanitizedName, sanitizedName});
                continue;
            }
            result.addStatement("this.$L = $L", new Object[]{sanitizedName, sanitizedName});
        }
        return result.build();
    }

    private MethodSpec messageBuilderConstructor(MessageType type, ClassName builderJavaType) {
        MethodSpec.Builder result = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)builderJavaType, "builder", new Modifier[0]);
        ImmutableList fields = type.fieldsAndOneOfFields();
        if (fields.size() > 0) {
            result.addCode("this(", new Object[0]);
            for (int i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    result.addCode(", ", new Object[0]);
                }
                Field field = (Field)fields.get(i);
                result.addCode("builder.$L", new Object[]{JavaGenerator.sanitize(field.name())});
            }
            result.addCode(");\n", new Object[0]);
        }
        result.addStatement("setBuilder(builder)", new Object[0]);
        return result.build();
    }

    private MethodSpec messageEquals(MessageType type) {
        TypeName javaType = this.typeName(type.name());
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, "other", new Modifier[0]);
        ImmutableList fields = type.fieldsAndOneOfFields();
        if (fields.isEmpty() && type.extensions().isEmpty()) {
            result.addStatement("return other instanceof $T", new Object[]{javaType});
            return result.build();
        }
        result.addStatement("if (other == this) return true", new Object[0]);
        result.addStatement("if (!(other instanceof $T)) return false", new Object[]{javaType});
        if (fields.size() == 1 && type.extensions().isEmpty()) {
            String name = JavaGenerator.sanitize(((Field)fields.get(0)).name());
            result.addStatement("return equals($L, (($T) other).$L)", new Object[]{this.addThisIfOneOf(name, "other", "o"), javaType, name});
            return result.build();
        }
        result.addStatement("$T o = ($T) other", new Object[]{javaType, javaType});
        if (!type.extensions().isEmpty()) {
            result.addStatement("if (!extensionsEqual(o)) return false", new Object[0]);
        }
        result.addCode("$[return ", new Object[0]);
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                result.addCode("\n&& ", new Object[0]);
            }
            Field field = (Field)fields.get(i);
            String name = JavaGenerator.sanitize(field.name());
            result.addCode("equals($L, o.$L)", new Object[]{this.addThisIfOneOf(name, "other", "o"), name});
        }
        result.addCode(";\n$]", new Object[0]);
        return result.build();
    }

    private MethodSpec messageHashCode(MessageType type) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE);
        ImmutableList fields = type.fieldsAndOneOfFields();
        if (fields.isEmpty() && type.extensions().isEmpty()) {
            result.addStatement("return 0", new Object[0]);
            return result.build();
        }
        if (fields.size() == 1 && type.extensions().isEmpty()) {
            Field field = (Field)fields.get(0);
            String name = JavaGenerator.sanitize(field.name());
            result.addStatement("int result = hashCode", new Object[0]);
            result.addStatement("return result != 0 ? result : (hashCode = $L != null ? $L.hashCode() : $L)", new Object[]{this.addThisIfOneOf(name, "result"), this.addThisIfOneOf(name, "result"), this.nullHashValue(field)});
            return result.build();
        }
        result.addStatement("int result = hashCode", new Object[0]);
        result.beginControlFlow("if (result == 0)", new Object[0]);
        boolean afterFirstAssignment = false;
        if (!type.extensions().isEmpty()) {
            result.addStatement("result = extensionsHashCode()", new Object[0]);
            afterFirstAssignment = true;
        }
        for (Field field : fields) {
            String name = JavaGenerator.sanitize(field.name());
            name = this.addThisIfOneOf(name, "result");
            if (afterFirstAssignment) {
                result.addStatement("result = result * 37 + ($L != null ? $L.hashCode() : $L)", new Object[]{name, name, this.nullHashValue(field)});
                continue;
            }
            result.addStatement("result = $L != null ? $L.hashCode() : $L", new Object[]{name, name, this.nullHashValue(field)});
            afterFirstAssignment = true;
        }
        result.addStatement("hashCode = result", new Object[0]);
        result.endControlFlow();
        result.addStatement("return result", new Object[0]);
        return result.build();
    }

    private TypeSpec builder(MessageType type, ClassName javaType, ClassName builderType) {
        TypeSpec.Builder result = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        result.superclass(JavaGenerator.builderOf((TypeName)javaType, builderType));
        ImmutableList fields = type.fieldsAndOneOfFields();
        for (Field field : fields) {
            TypeName fieldJavaType = this.fieldType(field);
            FieldSpec.Builder fieldSpec = FieldSpec.builder((TypeName)fieldJavaType, (String)JavaGenerator.sanitize(field.name()), (Modifier[])new Modifier[]{Modifier.PUBLIC});
            if (field.isPacked() || field.isRepeated()) {
                fieldSpec.initializer("$T.emptyList()", new Object[]{Collections.class});
            }
            result.addField(fieldSpec.build());
        }
        result.addMethod(this.builderNoArgsConstructor());
        result.addMethod(this.builderCopyConstructor(type));
        for (Field field : type.fields()) {
            result.addMethod(this.setter((TypeName)builderType, null, field));
        }
        for (OneOf oneOf : type.oneOfs()) {
            for (Field field : oneOf.fields()) {
                result.addMethod(this.setter((TypeName)builderType, oneOf, field));
            }
        }
        result.addMethod(this.builderBuild(type, javaType));
        return result.build();
    }

    private MethodSpec builderNoArgsConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
    }

    private MethodSpec builderCopyConstructor(MessageType message) {
        TypeName javaType = this.typeName(message.name());
        MethodSpec.Builder result = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(javaType, "message", new Modifier[0]);
        result.addStatement("super(message)", new Object[0]);
        ImmutableList fields = message.fieldsAndOneOfFields();
        if (!fields.isEmpty()) {
            result.addStatement("if (message == null) return", new Object[0]);
        }
        for (Field field : fields) {
            String fieldName = JavaGenerator.sanitize(field.name());
            if (field.isRepeated()) {
                result.addStatement("this.$L = copyOf(message.$L)", new Object[]{fieldName, fieldName});
                continue;
            }
            result.addStatement("this.$L = message.$L", new Object[]{fieldName, fieldName});
        }
        return result.build();
    }

    private MethodSpec setter(TypeName builderType, OneOf oneOf, Field field) {
        TypeName javaType = this.fieldType(field);
        String fieldName = JavaGenerator.sanitize(field.name());
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(javaType, fieldName, new Modifier[0]).returns(builderType);
        if (!field.documentation().isEmpty()) {
            result.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(field.documentation())});
        }
        if (field.isDeprecated()) {
            result.addAnnotation(Deprecated.class);
        }
        if (field.isRepeated()) {
            result.addStatement("this.$L = canonicalizeList($L)", new Object[]{fieldName, fieldName});
        } else {
            result.addStatement("this.$L = $L", new Object[]{fieldName, fieldName});
            if (oneOf != null) {
                for (Field other : oneOf.fields()) {
                    if (field == other) continue;
                    result.addStatement("this.$L = null", new Object[]{JavaGenerator.sanitize(other.name())});
                }
            }
        }
        result.addStatement("return this", new Object[0]);
        return result.build();
    }

    private MethodSpec builderBuild(MessageType message, ClassName javaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)javaType);
        ImmutableList requiredFields = message.getRequiredFields();
        if (!requiredFields.isEmpty()) {
            CodeBlock.Builder conditionals = CodeBlock.builder().add("$[", new Object[0]);
            CodeBlock.Builder missingArgs = CodeBlock.builder();
            for (int i = 0; i < requiredFields.size(); ++i) {
                Field requiredField = (Field)requiredFields.get(i);
                if (i > 0) {
                    conditionals.add("\n|| ", new Object[0]);
                }
                conditionals.add("$L == null", new Object[]{requiredField.name()});
                if (i > 0) {
                    missingArgs.add(",\n", new Object[0]);
                }
                missingArgs.add("$1L, $1S", new Object[]{requiredField.name()});
            }
            result.beginControlFlow("if ($L)", new Object[]{conditionals.add("$]", new Object[0]).build()}).addStatement("throw missingRequiredFields($L)", new Object[]{missingArgs.build()}).endControlFlow();
        }
        result.addStatement("return new $T(this)", new Object[]{javaType});
        return result.build();
    }

    private CodeBlock defaultValue(Field field) {
        Object defaultValue = field.getDefault();
        if (defaultValue == null && this.isEnum(field.type())) {
            defaultValue = this.enumDefault(field.type()).name();
        }
        if (field.type().isScalar() || defaultValue != null) {
            return this.fieldInitializer(field.type(), defaultValue);
        }
        throw new IllegalStateException("Field " + field + " cannot have default value");
    }

    private CodeBlock fieldInitializer(ProtoType type, Object value) {
        TypeName javaType = this.typeName(type);
        if (value instanceof List) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("$T.asList(", new Object[]{Arrays.class});
            boolean first = true;
            for (Object o : (List)value) {
                if (!first) {
                    builder.add(",", new Object[0]);
                }
                first = false;
                builder.add("\n$>$>$L$<$<", new Object[]{this.fieldInitializer(type, o)});
            }
            builder.add(")", new Object[0]);
            return builder.build();
        }
        if (value instanceof Map) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("new $T.Builder()", new Object[]{javaType});
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Field field = (Field)entry.getKey();
                CodeBlock valueInitializer = this.fieldInitializer(field.type(), entry.getValue());
                ClassName extensionClass = this.extensionsClass(field);
                if (extensionClass != null) {
                    builder.add("\n$>$>.setExtension($T.$L, $L)$<$<", new Object[]{extensionClass, field.name(), valueInitializer});
                    continue;
                }
                builder.add("\n$>$>.$L($L)$<$<", new Object[]{field.name(), valueInitializer});
            }
            builder.add("\n$>$>.build()$<$<", new Object[0]);
            return builder.build();
        }
        if (javaType.equals(TypeName.BOOLEAN.box())) {
            return JavaGenerator.codeBlock("$L", value != null ? value : Boolean.valueOf(false));
        }
        if (javaType.equals(TypeName.INT.box())) {
            return JavaGenerator.codeBlock("$L", value != null ? new BigDecimal(String.valueOf(value)).intValue() : 0);
        }
        if (javaType.equals(TypeName.LONG.box())) {
            return JavaGenerator.codeBlock("$LL", value != null ? Long.toString(new BigDecimal(String.valueOf(value)).longValue()) : Long.valueOf(0L));
        }
        if (javaType.equals(TypeName.FLOAT.box())) {
            return JavaGenerator.codeBlock("$Lf", value != null ? String.valueOf(value) : Float.valueOf(0.0f));
        }
        if (javaType.equals(TypeName.DOUBLE.box())) {
            return JavaGenerator.codeBlock("$Ld", value != null ? String.valueOf(value) : Double.valueOf(0.0));
        }
        if (javaType.equals(STRING)) {
            return JavaGenerator.codeBlock("$S", value != null ? (String)value : "");
        }
        if (javaType.equals(BYTE_STRING)) {
            if (value == null) {
                return JavaGenerator.codeBlock("$T.EMPTY", ByteString.class);
            }
            return JavaGenerator.codeBlock("$T.decodeBase64($S)", ByteString.class, ByteString.of((byte[])String.valueOf(value).getBytes(Charsets.ISO_8859_1)).base64());
        }
        if (this.isEnum(type) && value != null) {
            return JavaGenerator.codeBlock("$T.$L", javaType, value);
        }
        throw new IllegalStateException(type + " is not an allowed scalar type");
    }

    private String addThisIfOneOf(String name, String ... matches) {
        for (String match : matches) {
            if (!match.equals(name)) continue;
            return "this." + name;
        }
        return name;
    }

    private static String sanitize(String name) {
        return JAVA_KEYWORDS.contains((Object)name) ? "_" + name : name;
    }

    private static CodeBlock codeBlock(String format, Object ... args) {
        return CodeBlock.builder().add(format, args).build();
    }

    private int nullHashValue(Field field) {
        return field.isRepeated() ? 1 : 0;
    }

    public TypeSpec generateExtensionsClass(ClassName javaTypeName, ProtoFile protoFile) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)javaTypeName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        for (Extend extend : protoFile.extendList()) {
            ProtoType extendType = extend.type();
            TypeName javaType = this.typeName(extendType);
            if (!this.emitOptions && (extendType.equals((Object)Options.FIELD_OPTIONS) || extendType.equals((Object)Options.MESSAGE_OPTIONS))) continue;
            for (Field field : extend.fields()) {
                builder.addField(this.extensionField(protoFile, javaType, field));
            }
        }
        return builder.build();
    }

    private FieldSpec extensionField(ProtoFile protoFile, TypeName extendType, Field field) {
        TypeName fieldType = this.typeName(field.type());
        if (field.isRepeated()) {
            fieldType = JavaGenerator.listOf(fieldType);
        }
        return FieldSpec.builder((TypeName)JavaGenerator.extensionOf(extendType, fieldType), (String)field.name(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$[$T.get($T.class,\n$T.$L,\n$S,\n$L,\n$S)$]", new Object[]{Extension.class, extendType, WireField.Label.class, this.extensionLabel(field), protoFile.packageName() + "." + field.name(), field.tag(), this.adapterString(field.type())}).build();
    }

    private String extensionLabel(Field field) {
        switch (field.label()) {
            case OPTIONAL: {
                return "OPTIONAL";
            }
            case REQUIRED: {
                return "REQUIRED";
            }
            case REPEATED: {
                return field.isPacked() ? "PACKED" : "REPEATED";
            }
        }
        throw new AssertionError((Object)("Unexpected extension label \"" + field.label() + "\""));
    }

    public TypeSpec generateRegistry(ClassName javaTypeName) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)javaTypeName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        ImmutableSet.Builder extensionClassesBuilder = ImmutableSet.builder();
        for (ProtoFile protoFile : this.schema().protoFiles()) {
            if (protoFile.extendList().isEmpty()) continue;
            extensionClassesBuilder.add((Object)this.extensionsClass(protoFile));
        }
        ImmutableList extensionClasses = extensionClassesBuilder.build().asList();
        CodeBlock.Builder initializer = CodeBlock.builder();
        if (extensionClasses.isEmpty()) {
            initializer.add("$T.emptyList()", new Object[]{Collections.class});
        } else {
            initializer.add("$>$>$T.unmodifiableList($T.asList(", new Object[]{Collections.class, Arrays.class});
            int size = extensionClasses.size();
            for (int i = 0; i < size; ++i) {
                TypeName typeName = (TypeName)extensionClasses.get(i);
                initializer.add("\n$T.class", new Object[]{typeName});
                if (i + 1 >= extensionClasses.size()) continue;
                initializer.add(",", new Object[0]);
            }
            initializer.add("))$<$<", new Object[0]);
        }
        WildcardTypeName wildcard = extensionClasses.size() == 1 ? (TypeName)extensionClasses.get(0) : WildcardTypeName.subtypeOf(Object.class);
        TypeName listType = JavaGenerator.listOf((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{wildcard}));
        builder.addField(FieldSpec.builder((TypeName)listType, (String)"EXTENSIONS", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(initializer.build()).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).build());
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        return builder.build();
    }
}

