/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.squareup.wire.WireEnum;
import com.squareup.wire.internal.EnumJsonFormatter;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0012\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/squareup/wire/EnumTypeAdapter;", "E", "", "Lcom/squareup/wire/WireEnum;", "Lcom/google/gson/TypeAdapter;", "enumJsonFormatter", "Lcom/squareup/wire/internal/EnumJsonFormatter;", "(Lcom/squareup/wire/internal/EnumJsonFormatter;)V", "read", "input", "Lcom/google/gson/stream/JsonReader;", "(Lcom/google/gson/stream/JsonReader;)Ljava/lang/Enum;", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "(Lcom/google/gson/stream/JsonWriter;Ljava/lang/Enum;)V", "wire-gson-support"})
public final class EnumTypeAdapter<E extends Enum<E>>
extends TypeAdapter<E> {
    @NotNull
    private final EnumJsonFormatter<E> enumJsonFormatter;

    public EnumTypeAdapter(@NotNull EnumJsonFormatter<E> enumJsonFormatter) {
        Intrinsics.checkNotNullParameter(enumJsonFormatter, (String)"enumJsonFormatter");
        this.enumJsonFormatter = enumJsonFormatter;
    }

    public void write(@NotNull JsonWriter out, @NotNull E value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        out.value(this.enumJsonFormatter.toStringOrNumber((WireEnum)value));
    }

    @NotNull
    public E read(@NotNull JsonReader input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.path");
        String path = string;
        String nextString = input.nextString();
        Intrinsics.checkNotNullExpressionValue((Object)nextString, (String)"nextString");
        Enum enum_ = (Enum)this.enumJsonFormatter.fromString(nextString);
        if (enum_ == null) {
            throw new IOException("Unexpected " + nextString + " at path " + path);
        }
        return (E)enum_;
    }
}

