/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.squareup.wire.internal.JsonFormatter;
import com.squareup.wire.internal.JsonIntegration;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u0001:\u0003\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J \u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0016J4\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\n\u001a\u00020\u00022\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\b2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0016J\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0003\"\u0004\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\u0003\u00a8\u0006\u0018"}, d2={"Lcom/squareup/wire/GsonJsonIntegration;", "Lcom/squareup/wire/internal/JsonIntegration;", "Lcom/google/gson/Gson;", "Lcom/google/gson/TypeAdapter;", "", "()V", "formatterAdapter", "jsonFormatter", "Lcom/squareup/wire/internal/JsonFormatter;", "frameworkAdapter", "framework", "type", "Ljava/lang/reflect/Type;", "listAdapter", "elementAdapter", "mapAdapter", "keyFormatter", "valueAdapter", "structAdapter", "serializeNulls", "T", "FormatterJsonAdapter", "ListJsonAdapter", "MapJsonAdapter", "wire-gson-support"})
public final class GsonJsonIntegration
extends JsonIntegration<Gson, TypeAdapter<Object>> {
    public static final GsonJsonIntegration INSTANCE;

    @NotNull
    public TypeAdapter<Object> frameworkAdapter(@NotNull Gson framework, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)framework, (String)"framework");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TypeAdapter typeAdapter = framework.getAdapter(TypeToken.get((Type)type)).nullSafe();
        if (typeAdapter == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any?>");
        }
        return typeAdapter;
    }

    @NotNull
    public TypeAdapter<Object> listAdapter(@NotNull TypeAdapter<Object> elementAdapter) {
        Intrinsics.checkNotNullParameter(elementAdapter, (String)"elementAdapter");
        TypeAdapter typeAdapter = new ListJsonAdapter<Object>(elementAdapter).nullSafe();
        if (typeAdapter == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any?>");
        }
        return typeAdapter;
    }

    @NotNull
    public TypeAdapter<Object> mapAdapter(@NotNull Gson framework, @NotNull JsonFormatter<?> keyFormatter, @NotNull TypeAdapter<Object> valueAdapter) {
        Intrinsics.checkNotNullParameter((Object)framework, (String)"framework");
        Intrinsics.checkNotNullParameter(keyFormatter, (String)"keyFormatter");
        Intrinsics.checkNotNullParameter(valueAdapter, (String)"valueAdapter");
        TypeAdapter typeAdapter = new MapJsonAdapter(keyFormatter, valueAdapter).nullSafe();
        if (typeAdapter == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any?>");
        }
        return typeAdapter;
    }

    @NotNull
    public final <T> TypeAdapter<T> serializeNulls(@NotNull TypeAdapter<T> $this$serializeNulls) {
        Intrinsics.checkNotNullParameter($this$serializeNulls, (String)"$this$serializeNulls");
        TypeAdapter<T> delegate = $this$serializeNulls;
        return new TypeAdapter<T>(delegate){
            final /* synthetic */ TypeAdapter $delegate;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(@NotNull JsonWriter writer, T value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                boolean oldSerializeNulls = writer.getSerializeNulls();
                writer.setSerializeNulls(true);
                try {
                    this.$delegate.write(writer, value);
                }
                finally {
                    writer.setSerializeNulls(oldSerializeNulls);
                }
            }

            public T read(@NotNull JsonReader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                return (T)this.$delegate.read(reader);
            }
            {
                this.$delegate = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public TypeAdapter<Object> structAdapter(@NotNull Gson framework) {
        Intrinsics.checkNotNullParameter((Object)framework, (String)"framework");
        TypeAdapter typeAdapter = framework.getAdapter(Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)typeAdapter, (String)"framework.getAdapter(Object::class.java)");
        TypeAdapter typeAdapter2 = this.serializeNulls(typeAdapter).nullSafe();
        if (typeAdapter2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any?>");
        }
        return typeAdapter2;
    }

    @NotNull
    public TypeAdapter<Object> formatterAdapter(@NotNull JsonFormatter<?> jsonFormatter) {
        Intrinsics.checkNotNullParameter(jsonFormatter, (String)"jsonFormatter");
        TypeAdapter typeAdapter = new FormatterJsonAdapter(jsonFormatter).nullSafe();
        if (typeAdapter == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any?>");
        }
        return typeAdapter;
    }

    private GsonJsonIntegration() {
    }

    static {
        GsonJsonIntegration gsonJsonIntegration;
        INSTANCE = gsonJsonIntegration = new GsonJsonIntegration();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0007\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/squareup/wire/GsonJsonIntegration$FormatterJsonAdapter;", "T", "", "Lcom/google/gson/TypeAdapter;", "formatter", "Lcom/squareup/wire/internal/JsonFormatter;", "(Lcom/squareup/wire/internal/JsonFormatter;)V", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "(Lcom/google/gson/stream/JsonReader;)Ljava/lang/Object;", "write", "", "writer", "Lcom/google/gson/stream/JsonWriter;", "value", "(Lcom/google/gson/stream/JsonWriter;Ljava/lang/Object;)V", "wire-gson-support"})
    private static final class FormatterJsonAdapter<T>
    extends TypeAdapter<T> {
        private final JsonFormatter<T> formatter;

        public void write(@NotNull JsonWriter writer, @NotNull T value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Object stringOrNumber = this.formatter.toStringOrNumber(value);
            if (stringOrNumber instanceof Number) {
                writer.value((Number)stringOrNumber);
            } else {
                Object object = stringOrNumber;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                writer.value((String)object);
            }
        }

        @Nullable
        public T read(@NotNull JsonReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            String string = reader.nextString();
            try {
                String string2 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"string");
                return (T)this.formatter.fromString(string2);
            }
            catch (RuntimeException _) {
                throw (Throwable)new JsonSyntaxException("decode failed: " + string + " at path " + reader.getPath());
            }
        }

        public FormatterJsonAdapter(@NotNull JsonFormatter<T> formatter) {
            Intrinsics.checkNotNullParameter(formatter, (String)"formatter");
            this.formatter = formatter;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/squareup/wire/GsonJsonIntegration$ListJsonAdapter;", "T", "Lcom/google/gson/TypeAdapter;", "", "single", "(Lcom/google/gson/TypeAdapter;)V", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "write", "", "writer", "Lcom/google/gson/stream/JsonWriter;", "value", "wire-gson-support"})
    private static final class ListJsonAdapter<T>
    extends TypeAdapter<List<? extends T>> {
        private final TypeAdapter<T> single;

        @NotNull
        public List<T> read(@NotNull JsonReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            boolean bl = false;
            List result = new ArrayList();
            reader.beginArray();
            while (reader.hasNext()) {
                result.add(this.single.read(reader));
            }
            reader.endArray();
            return result;
        }

        public void write(@NotNull JsonWriter writer, @Nullable List<? extends T> value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            writer.beginArray();
            List<T> list = value;
            Intrinsics.checkNotNull(list);
            for (T v : list) {
                this.single.write(writer, v);
            }
            writer.endArray();
        }

        public ListJsonAdapter(@NotNull TypeAdapter<T> single) {
            Intrinsics.checkNotNullParameter(single, (String)"single");
            this.single = single;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00050\u0004B!\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/squareup/wire/GsonJsonIntegration$MapJsonAdapter;", "K", "", "V", "Lcom/google/gson/TypeAdapter;", "", "keyFormatter", "Lcom/squareup/wire/internal/JsonFormatter;", "valueAdapter", "(Lcom/squareup/wire/internal/JsonFormatter;Lcom/google/gson/TypeAdapter;)V", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "write", "", "writer", "Lcom/google/gson/stream/JsonWriter;", "value", "wire-gson-support"})
    private static final class MapJsonAdapter<K, V>
    extends TypeAdapter<Map<K, ? extends V>> {
        private final JsonFormatter<K> keyFormatter;
        private final TypeAdapter<V> valueAdapter;

        @NotNull
        public Map<K, V> read(@NotNull JsonReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            boolean bl = false;
            Map result = new LinkedHashMap();
            reader.beginObject();
            while (reader.hasNext()) {
                Object value;
                Object key;
                String name;
                String string = name = reader.nextName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                if (this.keyFormatter.fromString(string) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type K");
                }
                Intrinsics.checkNotNull((Object)this.valueAdapter.read(reader));
                result.put(key, value);
            }
            reader.endObject();
            return result;
        }

        /*
         * WARNING - void declaration
         */
        public void write(@NotNull JsonWriter writer, @Nullable Map<K, ? extends V> value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            writer.beginObject();
            Map<K, V> map = value;
            Intrinsics.checkNotNull(map);
            Map<K, V> map2 = map;
            boolean bl = false;
            Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                void k;
                Map.Entry<K, V> entry;
                Map.Entry<K, V> entry2 = entry = iterator.next();
                boolean bl2 = false;
                map2 = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                V v = entry2.getValue();
                writer.name(this.keyFormatter.toStringOrNumber((Object)k).toString());
                this.valueAdapter.write(writer, v);
            }
            writer.endObject();
        }

        public MapJsonAdapter(@NotNull JsonFormatter<K> keyFormatter, @NotNull TypeAdapter<V> valueAdapter) {
            Intrinsics.checkNotNullParameter(keyFormatter, (String)"keyFormatter");
            Intrinsics.checkNotNullParameter(valueAdapter, (String)"valueAdapter");
            this.keyFormatter = keyFormatter;
            this.valueAdapter = valueAdapter;
        }
    }
}

