/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.squareup.wire.FieldBinding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.RuntimeMessageAdapter;
import com.squareup.wire.WireField;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class MessageTypeAdapter<M extends Message<M, B>, B extends Message.Builder<M, B>>
extends TypeAdapter<M> {
    private static final BigInteger POWER_64 = new BigInteger("18446744073709551616");
    private final Gson gson;
    private final RuntimeMessageAdapter<M, B> messageAdapter;
    private final Map<String, FieldBinding<M, B>> fieldBindings;

    public MessageTypeAdapter(Gson gson, TypeToken<M> type) {
        this.gson = gson;
        this.messageAdapter = RuntimeMessageAdapter.create((Class)type.getRawType());
        LinkedHashMap<String, FieldBinding> fieldBindings = new LinkedHashMap<String, FieldBinding>();
        for (FieldBinding binding : this.messageAdapter.fieldBindings().values()) {
            fieldBindings.put(binding.name, binding);
        }
        this.fieldBindings = Collections.unmodifiableMap(fieldBindings);
    }

    public void write(JsonWriter out, M message) throws IOException {
        if (message == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        for (FieldBinding tagBinding : this.messageAdapter.fieldBindings().values()) {
            Object value = tagBinding.get(message);
            if (value == null) continue;
            out.name(tagBinding.name);
            this.emitJson(out, value, tagBinding.singleAdapter(), tagBinding.label);
        }
        out.endObject();
    }

    private void emitJson(JsonWriter out, Object value, ProtoAdapter<?> adapter, WireField.Label label) throws IOException {
        if (adapter == ProtoAdapter.UINT64) {
            if (label.isRepeated()) {
                List longs = (List)value;
                out.beginArray();
                int count = longs.size();
                for (int i = 0; i < count; ++i) {
                    this.emitUint64((Long)longs.get(i), out);
                }
                out.endArray();
            } else {
                this.emitUint64((Long)value, out);
            }
        } else {
            this.gson.toJson(value, value.getClass(), out);
        }
    }

    private void emitUint64(Long value, JsonWriter out) throws IOException {
        if (value < 0L) {
            BigInteger unsigned = POWER_64.add(BigInteger.valueOf(value));
            out.value((Number)unsigned);
        } else {
            out.value((Number)value);
        }
    }

    public M read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Message.Builder builder = this.messageAdapter.newBuilder();
        in.beginObject();
        while (in.peek() == JsonToken.NAME) {
            String name = in.nextName();
            FieldBinding<M, B> fieldBinding = this.fieldBindings.get(name);
            if (fieldBinding != null) {
                Object value = this.parseValue(fieldBinding.label, this.singleType(fieldBinding), this.parse(in));
                fieldBinding.set(builder, value);
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        return (M)builder.build();
    }

    private JsonElement parse(JsonReader in) {
        return (JsonElement)this.gson.fromJson(in, JsonElement.class);
    }

    private Object parseValue(WireField.Label label, Type valueType, JsonElement valueElement) {
        if (label.isRepeated()) {
            if (valueElement.isJsonNull()) {
                return Collections.emptyList();
            }
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (JsonElement element : valueElement.getAsJsonArray()) {
                valueList.add(this.readJson(valueType, element));
            }
            return valueList;
        }
        return this.readJson(valueType, valueElement);
    }

    private Object readJson(Type valueType, JsonElement element) {
        return this.gson.fromJson(element, valueType);
    }

    private Type singleType(FieldBinding<M, B> tagBinding) {
        return tagBinding.singleAdapter().javaType;
    }
}

