/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.squareup.wire.ByteString;
import com.squareup.wire.ExtendableMessage;
import com.squareup.wire.Extension;
import com.squareup.wire.Message;
import com.squareup.wire.MessageAdapter;
import com.squareup.wire.UnknownFieldMap;
import com.squareup.wire.Wire;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class MessageTypeAdapter<M extends Message>
extends TypeAdapter<M> {
    private static final BigInteger POWER_64 = new BigInteger("18446744073709551616");
    private final Wire wire;
    private final Gson gson;
    private final Class<M> type;

    public MessageTypeAdapter(Wire wire, Gson gson, TypeToken<M> type) {
        this.wire = wire;
        this.gson = gson;
        this.type = type.getRawType();
    }

    public void write(JsonWriter out, M message) throws IOException {
        Collection unknownFields;
        if (message == null) {
            out.nullValue();
            return;
        }
        MessageAdapter messageAdapter = this.wire.messageAdapter(message.getClass());
        out.beginObject();
        for (MessageAdapter.FieldInfo fieldInfo : messageAdapter.getFields()) {
            Object value = messageAdapter.getFieldValue(message, fieldInfo);
            if (value == null) continue;
            out.name(fieldInfo.name);
            this.emitJson(out, value, fieldInfo.datatype, fieldInfo.label);
        }
        if (message instanceof ExtendableMessage) {
            this.emitExtensions((ExtendableMessage)message, out);
        }
        if ((unknownFields = message.unknownFields()) != null) {
            for (List fieldList : unknownFields) {
                int tag = ((UnknownFieldMap.FieldValue)fieldList.get(0)).getTag();
                out.name("" + tag);
                out.beginArray();
                boolean first = true;
                for (UnknownFieldMap.FieldValue unknownField : fieldList) {
                    switch (unknownField.getWireType()) {
                        case VARINT: {
                            if (first) {
                                out.value("varint");
                            }
                            out.value((Number)unknownField.getAsLong());
                            break;
                        }
                        case FIXED32: {
                            if (first) {
                                out.value("fixed32");
                            }
                            out.value((Number)unknownField.getAsInteger());
                            break;
                        }
                        case FIXED64: {
                            if (first) {
                                out.value("fixed64");
                            }
                            out.value((Number)unknownField.getAsLong());
                            break;
                        }
                        case LENGTH_DELIMITED: {
                            if (first) {
                                out.value("length-delimited");
                            }
                            out.value(unknownField.getAsBytes().toString());
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown wire type " + unknownField.getWireType()));
                        }
                    }
                    first = false;
                }
                out.endArray();
            }
        }
        out.endObject();
    }

    private <M extends ExtendableMessage<?>> void emitExtensions(ExtendableMessage<M> message, JsonWriter out) throws IOException {
        for (Extension extension : message.getExtensions()) {
            this.emitExtension(message, extension, out);
        }
    }

    private <M extends ExtendableMessage<?>, E> void emitExtension(ExtendableMessage<M> message, Extension<M, E> extension, JsonWriter out) throws IOException {
        out.name(extension.getName());
        Object value = message.getExtension(extension);
        this.emitJson(out, value, extension.getDatatype(), extension.getLabel());
    }

    private void emitJson(JsonWriter out, Object value, Message.Datatype datatype, Message.Label label) throws IOException {
        if (datatype == Message.Datatype.UINT64) {
            if (label.isRepeated()) {
                List longs = (List)value;
                out.beginArray();
                int count = longs.size();
                for (int i = 0; i < count; ++i) {
                    this.emitUint64((Long)longs.get(i), out);
                }
                out.endArray();
            } else {
                this.emitUint64((Long)value, out);
            }
        } else {
            this.gson.toJson(value, value.getClass(), out);
        }
    }

    private void emitUint64(Long value, JsonWriter out) throws IOException {
        if (value < 0L) {
            BigInteger unsigned = POWER_64.add(BigInteger.valueOf(value));
            out.value((Number)unsigned);
        } else {
            out.value((Number)value);
        }
    }

    public M read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        MessageAdapter messageAdapter = this.wire.messageAdapter(this.type);
        Message.Builder builder = messageAdapter.newBuilder();
        in.beginObject();
        while (in.peek() == JsonToken.NAME) {
            String name = in.nextName();
            MessageAdapter.FieldInfo fieldInfo = messageAdapter.getField(name);
            if (fieldInfo == null) {
                Extension extension = messageAdapter.getExtension(name);
                if (extension == null) {
                    this.parseUnknownField(in, builder, Integer.parseInt(name));
                    continue;
                }
                Type valueType = this.getType(extension);
                Object value = this.parseValue(extension.getLabel(), valueType, this.parse(in));
                ((ExtendableMessage.ExtendableBuilder)builder).setExtension(extension, value);
                continue;
            }
            Type valueType = this.getType(fieldInfo);
            Object value = this.parseValue(fieldInfo.label, valueType, this.parse(in));
            messageAdapter.setBuilderField(builder, fieldInfo.tag, value);
        }
        in.endObject();
        return (M)builder.build();
    }

    private JsonElement parse(JsonReader in) {
        return (JsonElement)this.gson.fromJson(in, JsonElement.class);
    }

    private Type getType(MessageAdapter.FieldInfo fieldInfo) {
        Type valueType = fieldInfo.datatype == Message.Datatype.ENUM ? fieldInfo.enumType : (fieldInfo.datatype == Message.Datatype.MESSAGE ? fieldInfo.messageType : this.javaType(fieldInfo.datatype));
        return valueType;
    }

    private Object parseValue(Message.Label label, Type valueType, JsonElement valueElement) {
        if (label.isRepeated()) {
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (JsonElement element : valueElement.getAsJsonArray()) {
                valueList.add(this.readJson(valueType, element));
            }
            return valueList;
        }
        return this.readJson(valueType, valueElement);
    }

    private Type getType(Extension<ExtendableMessage<?>, ?> extension) {
        Message.Datatype datatype = extension.getDatatype();
        if (datatype == Message.Datatype.ENUM) {
            return extension.getEnumType();
        }
        if (datatype == Message.Datatype.MESSAGE) {
            return extension.getMessageType();
        }
        return this.javaType(datatype);
    }

    private void parseUnknownField(JsonReader in, Message.Builder<M> builder, int tag) throws IOException {
        in.beginArray();
        UnknownFieldMap.UnknownFieldType type = UnknownFieldMap.UnknownFieldType.of((String)in.nextString());
        block6: while (in.peek() != JsonToken.END_ARRAY) {
            switch (type) {
                case VARINT: {
                    builder.addVarint(tag, (long)in.nextInt());
                    continue block6;
                }
                case FIXED32: {
                    builder.addFixed32(tag, in.nextInt());
                    continue block6;
                }
                case FIXED64: {
                    builder.addFixed64(tag, (long)in.nextInt());
                    continue block6;
                }
                case LENGTH_DELIMITED: {
                    builder.addLengthDelimited(tag, ByteString.of((String)in.nextString()));
                    continue block6;
                }
            }
            throw new AssertionError((Object)("Unknown field type " + type));
        }
        in.endArray();
    }

    private Object readJson(Type valueType, JsonElement element) {
        return this.gson.fromJson(element, valueType);
    }

    private Type javaType(Message.Datatype datatype) {
        switch (datatype) {
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: {
                return Integer.TYPE;
            }
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return Long.TYPE;
            }
            case BOOL: {
                return Boolean.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case STRING: {
                return String.class;
            }
            case BYTES: {
                return ByteString.class;
            }
        }
        throw new AssertionError((Object)("Unknown datatype: " + datatype));
    }
}

