/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.kotlin.grpcserver;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.SchemaEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J2\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/squareup/wire/kotlin/grpcserver/FileDescriptorGenerator;", "", "()V", "DESCRIPTOR_MAP_FUNCTION_PREFIX", "", "DM_CHUNK_SIZE", "", "FDS_CHUNK_SIZE", "descriptorMapClass", "Lcom/squareup/kotlinpoet/ParameterizedTypeName;", "addDescriptorDataProperty", "", "builder", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "protoFile", "Lcom/squareup/wire/schema/ProtoFile;", "schema", "Lcom/squareup/wire/schema/Schema;", "addDescriptorForFunction", "addDescriptorMapProperty", "encoded", "", "addFileDescriptorFunction", "encodeFileAndDependencies", "subDescriptorMapCodeBlock", "encodedList", "", "Lkotlin/Pair;", "index", "wire-grpc-server-generator"})
@SourceDebugExtension(value={"SMAP\nFileDescriptorGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileDescriptorGenerator.kt\ncom/squareup/wire/kotlin/grpcserver/FileDescriptorGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CodeBlock.kt\ncom/squareup/kotlinpoet/CodeBlocks\n*L\n1#1,183:1\n1864#2,3:184\n1855#2:187\n1856#2:189\n1789#2,2:190\n1789#2,3:194\n1791#2:197\n522#3:188\n522#3:192\n522#3:193\n*S KotlinDebug\n*F\n+ 1 FileDescriptorGenerator.kt\ncom/squareup/wire/kotlin/grpcserver/FileDescriptorGenerator\n*L\n86#1:184,3\n95#1:187\n95#1:189\n125#1:190,2\n132#1:194,3\n125#1:197\n96#1:188\n128#1:192\n131#1:193\n*E\n"})
public final class FileDescriptorGenerator {
    @NotNull
    public static final FileDescriptorGenerator INSTANCE = new FileDescriptorGenerator();
    @NotNull
    private static final ParameterizedTypeName descriptorMapClass;
    private static final int FDS_CHUNK_SIZE = 80;
    private static final int DM_CHUNK_SIZE = 20;
    @NotNull
    private static final String DESCRIPTOR_MAP_FUNCTION_PREFIX = "createDescriptorMap";

    private FileDescriptorGenerator() {
    }

    public final void addDescriptorDataProperty(@NotNull TypeSpec.Builder builder, @Nullable ProtoFile protoFile, @NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.addDescriptorForFunction(builder);
        this.addFileDescriptorFunction(builder);
        if (protoFile != null) {
            Map<String, String> encoded = this.encodeFileAndDependencies(protoFile, schema);
            this.addDescriptorMapProperty(builder, encoded);
        }
    }

    private final Map<String, String> encodeFileAndDependencies(ProtoFile protoFile, Schema schema) {
        Map encoded = new LinkedHashMap();
        Set visited = new LinkedHashSet();
        Object[] objectArray = new String[]{protoFile.getLocation().getPath()};
        List todo = CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)todo).isEmpty()) {
            String path = (String)CollectionsKt.removeLast((List)todo);
            if (visited.contains(path)) continue;
            visited.add(path);
            ProtoFile file = schema.protoFile(path);
            if (file == null) continue;
            todo.addAll(file.getImports());
            encoded.put(file.getLocation().getPath(), new SchemaEncoder(schema).encode(file).base64());
        }
        return encoded;
    }

    /*
     * WARNING - void declaration
     */
    private final void addDescriptorMapProperty(TypeSpec.Builder builder, Map<String, String> encoded) {
        List initLines = new ArrayList();
        List encodedListChunked = CollectionsKt.chunked((Iterable)MapsKt.toList(encoded), (int)20);
        Iterable $this$forEachIndexed$iv = encodedListChunked;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void subEncodedList;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl = false;
            INSTANCE.subDescriptorMapCodeBlock(builder, (List<Pair<String, String>>)subEncodedList, index);
            if (index > 0) {
                int n2 = index - 1;
                initLines.set(n2, (String)initLines.get(n2) + " +");
            }
            initLines.add(DESCRIPTOR_MAP_FUNCTION_PREFIX + index + "()");
        }
        CodeBlock.Builder initializerBuilder = CodeBlock.Companion.builder();
        Iterable $this$forEach$iv = initLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeBlock.Builder builder2;
            String line = (String)element$iv;
            boolean bl = false;
            CodeBlock.Builder $this$withIndent$iv = initializerBuilder;
            boolean $i$f$withIndent = false;
            CodeBlock.Builder $this$addDescriptorMapProperty_u24lambda_u242_u24lambda_u241 = builder2 = $this$withIndent$iv.indent();
            boolean bl2 = false;
            $this$addDescriptorMapProperty_u24lambda_u242_u24lambda_u241.addStatement(line, new Object[0]);
            builder2.unindent();
        }
        KModifier[] kModifierArray = new KModifier[]{KModifier.PRIVATE};
        builder.addProperty(PropertySpec.Companion.builder("descriptorMap", (TypeName)descriptorMapClass, new KModifier[0]).addModifiers(kModifierArray).initializer(initializerBuilder.build()).build());
    }

    /*
     * WARNING - void declaration
     */
    private final void subDescriptorMapCodeBlock(TypeSpec.Builder builder, List<Pair<String, String>> encodedList, int index) {
        void $this$fold$iv;
        void initial$iv;
        Object object = new KModifier[]{KModifier.PRIVATE};
        FunSpec.Builder builder2 = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(DESCRIPTOR_MAP_FUNCTION_PREFIX + index).addModifiers(object), (TypeName)((TypeName)descriptorMapClass), null, (int)2, null);
        object = encodedList;
        CodeBlock.Builder builder3 = CodeBlock.Companion.builder().addStatement("val subMap = mapOf(", new Object[0]);
        FunSpec.Builder builder4 = builder2;
        TypeSpec.Builder builder5 = builder;
        boolean $i$f$fold = false;
        CodeBlock.Builder accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void $this$withIndent$iv;
            CodeBlock.Builder builder6;
            CodeBlock.Builder builder7;
            Pair pair = (Pair)element$iv;
            void b = accumulator$iv;
            boolean bl = false;
            String name = (String)pair.component1();
            String data = (String)pair.component2();
            void $this$withIndent$iv2 = b;
            boolean $i$f$withIndent = false;
            CodeBlock.Builder $this$subDescriptorMapCodeBlock_u24lambda_u246_u24lambda_u245 = builder7 = $this$withIndent$iv2.indent();
            boolean bl2 = false;
            CodeBlock.Builder builder8 = $this$subDescriptorMapCodeBlock_u24lambda_u246_u24lambda_u245.addStatement('\"' + name + "\" to descriptorFor(arrayOf(", new Object[0]);
            boolean $i$f$withIndent2 = false;
            CodeBlock.Builder $this$subDescriptorMapCodeBlock_u24lambda_u246_u24lambda_u245_u24lambda_u244 = builder6 = $this$withIndent$iv.indent();
            boolean bl3 = false;
            Iterable $this$fold$iv2 = StringsKt.chunked((CharSequence)data, (int)80);
            boolean $i$f$fold2 = false;
            CodeBlock.Builder accumulator$iv2 = $this$subDescriptorMapCodeBlock_u24lambda_u246_u24lambda_u245_u24lambda_u244;
            for (Object element$iv2 : $this$fold$iv2) {
                void c;
                String string = (String)element$iv2;
                CodeBlock.Builder b2 = accumulator$iv2;
                boolean bl4 = false;
                accumulator$iv2 = b2.addStatement('\"' + (String)c + "\",", new Object[0]);
            }
            builder6.unindent().addStatement(")),", new Object[0]);
            accumulator$iv = builder7.unindent();
        }
        void var35_35 = accumulator$iv;
        builder5.addFunction(builder4.addCode(var35_35.addStatement(")", new Object[0]).addStatement("return subMap", new Object[0]).build()).build());
    }

    private final void addFileDescriptorFunction(TypeSpec.Builder builder) {
        KModifier[] kModifierArray = new KModifier[]{KModifier.PRIVATE};
        FunSpec.Builder builder2 = FunSpec.Companion.builder("fileDescriptor").addModifiers(kModifierArray).addParameter("path", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]);
        kModifierArray = new KClass[]{Reflection.getOrCreateKotlinClass(String.class)};
        builder.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)builder2.addParameter("visited", (TypeName)ParameterizedTypeName.Companion.get(Reflection.getOrCreateKotlinClass(Set.class), (KClass[])kModifierArray), new KModifier[0]), (KClass)Reflection.getOrCreateKotlinClass(Descriptors.FileDescriptor.class), null, (int)2, null).addCode("val proto = descriptorMap[path]!!\nval deps = proto.dependencyList.filter { !visited.contains(it) }.map { fileDescriptor(it, visited + path) }\nreturn Descriptors.FileDescriptor.buildFrom(proto, deps.toTypedArray())", new Object[0]).build());
    }

    private final void addDescriptorForFunction(TypeSpec.Builder builder) {
        KModifier[] kModifierArray = new KModifier[]{KModifier.PRIVATE};
        FunSpec.Builder builder2 = FunSpec.Companion.builder("descriptorFor").addModifiers(kModifierArray);
        kModifierArray = new KClass[]{Reflection.getOrCreateKotlinClass(String.class)};
        builder.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)builder2.addParameter("data", (TypeName)ParameterizedTypeName.Companion.get(Reflection.getOrCreateKotlinClass(Object[].class), (KClass[])kModifierArray), new KModifier[0]), (KClass)Reflection.getOrCreateKotlinClass(DescriptorProtos.FileDescriptorProto.class), null, (int)2, null).addCode("val str = data.fold(java.lang.StringBuilder()) { b, s -> b.append(s) }.toString()\nval bytes = java.util.Base64.getDecoder().decode(str)\nreturn DescriptorProtos.FileDescriptorProto.parseFrom(bytes)", new Object[0]).build());
    }

    static {
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(String.class), Reflection.getOrCreateKotlinClass(DescriptorProtos.FileDescriptorProto.class)};
        descriptorMapClass = ParameterizedTypeName.Companion.get(Reflection.getOrCreateKotlinClass(Map.class), kClassArray);
    }
}

