/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.kotlin.grpcserver;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.wire.kotlin.grpcserver.BindableAdapterGenerator;
import com.squareup.wire.kotlin.grpcserver.BlockingStubGenerator;
import com.squareup.wire.kotlin.grpcserver.ClassNameGenerator;
import com.squareup.wire.kotlin.grpcserver.ImplBaseGenerator;
import com.squareup.wire.kotlin.grpcserver.MethodDescriptorGenerator;
import com.squareup.wire.kotlin.grpcserver.ServiceDescriptorGenerator;
import com.squareup.wire.kotlin.grpcserver.StubGenerator;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ,\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/squareup/wire/kotlin/grpcserver/KotlinGrpcGenerator;", "", "typeToKotlinName", "", "Lcom/squareup/wire/schema/ProtoType;", "Lcom/squareup/kotlinpoet/TypeName;", "singleMethodServices", "", "suspendingCalls", "(Ljava/util/Map;ZZ)V", "generateGrpcServer", "Lkotlin/Pair;", "Lcom/squareup/kotlinpoet/ClassName;", "Lcom/squareup/kotlinpoet/TypeSpec;", "service", "Lcom/squareup/wire/schema/Service;", "protoFile", "Lcom/squareup/wire/schema/ProtoFile;", "schema", "Lcom/squareup/wire/schema/Schema;", "Companion", "wire-grpc-server-generator"})
@SourceDebugExtension(value={"SMAP\nKotlinGrpcGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGrpcGenerator.kt\ncom/squareup/wire/kotlin/grpcserver/KotlinGrpcGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1855#2,2:61\n*S KotlinDebug\n*F\n+ 1 KotlinGrpcGenerator.kt\ncom/squareup/wire/kotlin/grpcserver/KotlinGrpcGenerator\n*L\n47#1:61,2\n*E\n"})
public final class KotlinGrpcGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ProtoType, TypeName> typeToKotlinName;
    private final boolean singleMethodServices;
    private final boolean suspendingCalls;

    public KotlinGrpcGenerator(@NotNull Map<ProtoType, ? extends TypeName> typeToKotlinName, boolean singleMethodServices, boolean suspendingCalls) {
        Intrinsics.checkNotNullParameter(typeToKotlinName, (String)"typeToKotlinName");
        this.typeToKotlinName = typeToKotlinName;
        this.singleMethodServices = singleMethodServices;
        this.suspendingCalls = suspendingCalls;
    }

    @NotNull
    public final Pair<ClassName, TypeSpec> generateGrpcServer(@NotNull Service service, @Nullable ProtoFile protoFile, @NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Companion.Options options = new Companion.Options(this.singleMethodServices, this.suspendingCalls);
        ClassNameGenerator classNameGenerator = new ClassNameGenerator(this.typeToKotlinName);
        ClassName grpcClassName = classNameGenerator.classNameFor(service.type(), "WireGrpc");
        TypeSpec.Builder builder = TypeSpec.Companion.objectBuilder(grpcClassName);
        ServiceDescriptorGenerator.INSTANCE.addServiceDescriptor$wire_grpc_server_generator(builder, service, protoFile, schema);
        Iterable $this$forEach$iv = service.rpcs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rpc rpc = (Rpc)element$iv;
            boolean bl = false;
            MethodDescriptorGenerator.INSTANCE.addMethodDescriptor$wire_grpc_server_generator(classNameGenerator, builder, service, rpc);
        }
        ImplBaseGenerator.INSTANCE.addImplBase$wire_grpc_server_generator(classNameGenerator, builder, service, options);
        BindableAdapterGenerator.INSTANCE.addBindableAdapter$wire_grpc_server_generator(classNameGenerator, builder, service, options);
        StubGenerator.INSTANCE.addStub$wire_grpc_server_generator(classNameGenerator, builder, service, options);
        BlockingStubGenerator.INSTANCE.addBlockingStub$wire_grpc_server_generator(classNameGenerator, builder, service, options);
        return TuplesKt.to((Object)grpcClassName, (Object)builder.build());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/squareup/wire/kotlin/grpcserver/KotlinGrpcGenerator$Companion;", "", "()V", "Options", "wire-grpc-server-generator"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/squareup/wire/kotlin/grpcserver/KotlinGrpcGenerator$Companion$Options;", "", "singleMethodServices", "", "suspendingCalls", "(ZZ)V", "getSingleMethodServices", "()Z", "getSuspendingCalls", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "wire-grpc-server-generator"})
        public static final class Options {
            private final boolean singleMethodServices;
            private final boolean suspendingCalls;

            public Options(boolean singleMethodServices, boolean suspendingCalls) {
                this.singleMethodServices = singleMethodServices;
                this.suspendingCalls = suspendingCalls;
            }

            public final boolean getSingleMethodServices() {
                return this.singleMethodServices;
            }

            public final boolean getSuspendingCalls() {
                return this.suspendingCalls;
            }

            public final boolean component1() {
                return this.singleMethodServices;
            }

            public final boolean component2() {
                return this.suspendingCalls;
            }

            @NotNull
            public final Options copy(boolean singleMethodServices, boolean suspendingCalls) {
                return new Options(singleMethodServices, suspendingCalls);
            }

            public static /* synthetic */ Options copy$default(Options options, boolean bl, boolean bl2, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = options.singleMethodServices;
                }
                if ((n & 2) != 0) {
                    bl2 = options.suspendingCalls;
                }
                return options.copy(bl, bl2);
            }

            @NotNull
            public String toString() {
                return "Options(singleMethodServices=" + this.singleMethodServices + ", suspendingCalls=" + this.suspendingCalls + ')';
            }

            public int hashCode() {
                int n;
                int result;
                int n2 = this.singleMethodServices ? 1 : 0;
                if (n2 != 0) {
                    n2 = result = 1;
                }
                if ((n = this.suspendingCalls) != 0) {
                    n = 1;
                }
                result = result * 31 + n;
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Options)) {
                    return false;
                }
                Options options = (Options)other;
                if (this.singleMethodServices != options.singleMethodServices) {
                    return false;
                }
                return this.suspendingCalls == options.suspendingCalls;
            }
        }
    }
}

