/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.GrpcCall;
import com.squareup.wire.GrpcHttpUrlKt;
import com.squareup.wire.GrpcMethod;
import com.squareup.wire.GrpcStreamingCall;
import com.squareup.wire.Service;
import com.squareup.wire.internal.RealGrpcCall;
import com.squareup.wire.internal.RealGrpcStreamingCall;
import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\f\u001a\u0002H\r\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u000fJ#\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011H\u0002J:\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180\u0016\"\b\b\u0000\u0010\u0017*\u00020\u0001\"\b\b\u0001\u0010\u0018*\u00020\u00012\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180\u001aJ!\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0000\u00a2\u0006\u0002\b!J:\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180#\"\b\b\u0000\u0010\u0017*\u00020\u0001\"\b\b\u0001\u0010\u0018*\u00020\u00012\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180\u001aR\u0018\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Lcom/squareup/wire/GrpcClient;", "", "client", "Lokhttp3/OkHttpClient;", "baseUrl", "Lokhttp3/HttpUrl;", "Lcom/squareup/wire/GrpcHttpUrl;", "(Lokhttp3/OkHttpClient;Lokhttp3/HttpUrl;)V", "getBaseUrl$wire_grpc_client", "()Lokhttp3/HttpUrl;", "getClient$wire_grpc_client", "()Lokhttp3/OkHttpClient;", "create", "T", "Lcom/squareup/wire/Service;", "()Lcom/squareup/wire/Service;", "service", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Lcom/squareup/wire/Service;", "implementationClass", "Ljava/lang/Class;", "newCall", "Lcom/squareup/wire/GrpcCall;", "S", "R", "method", "Lcom/squareup/wire/GrpcMethod;", "Lokhttp3/Call;", "path", "", "requestBody", "Lokhttp3/RequestBody;", "Lcom/squareup/wire/GrpcRequestBody;", "newCall$wire_grpc_client", "newStreamingCall", "Lcom/squareup/wire/GrpcStreamingCall;", "Builder", "wire-grpc-client"})
public final class GrpcClient {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final HttpUrl baseUrl;

    @NotNull
    public final /* synthetic */ <T extends Service> T create() {
        int $i$f$create = 0;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.create(Reflection.getOrCreateKotlinClass(Service.class));
    }

    @NotNull
    public final <T extends Service> T create(@NotNull KClass<T> service) {
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        try {
            Class<?> implementationClass = this.implementationClass(service);
            Object[] objectArray = implementationClass.getDeclaredConstructors();
            Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"implementationClass.declaredConstructors");
            Constructor onlyConstructor = (Constructor)ArraysKt.single((Object[])objectArray);
            Object instance = onlyConstructor.newInstance(this);
            Object t = JvmClassMappingKt.getJavaClass(service).cast(instance);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"service.java.cast(instance)");
            return (T)((Service)t);
        }
        catch (Exception _) {
            String string = "failed to create gRPC class for " + service + ": is it a Wire-generated gRPC interface?";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final <T extends Service> Class<?> implementationClass(KClass<T> service) {
        String string = service.getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String interfaceName = string;
        int simpleNameOffset = StringsKt.lastIndexOf$default((CharSequence)interfaceName, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
        String string2 = interfaceName;
        int n = 0;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, simpleNameOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String packageName = string4;
        String string5 = interfaceName;
        bl = false;
        String string6 = string5;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.substring(simpleNameOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
        String interfaceSimpleName = string7;
        String implementationName = packageName + "Grpc" + interfaceSimpleName;
        Class<?> clazz = Class.forName(implementationName);
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(implementationName)");
        return clazz;
    }

    @NotNull
    public final <S, R> GrpcCall<S, R> newCall(@NotNull GrpcMethod<S, R> method) {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        return new RealGrpcCall<S, R>(this, method);
    }

    @NotNull
    public final <S, R> GrpcStreamingCall<S, R> newStreamingCall(@NotNull GrpcMethod<S, R> method) {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        return new RealGrpcStreamingCall<S, R>(this, method);
    }

    @NotNull
    public final Call newCall$wire_grpc_client(@NotNull String path, @NotNull RequestBody requestBody) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)requestBody, (String)"requestBody");
        Request.Builder builder = new Request.Builder();
        HttpUrl httpUrl = this.baseUrl.resolve(path);
        if (httpUrl == null) {
            Intrinsics.throwNpe();
        }
        return this.client.newCall(builder.url(httpUrl).addHeader("te", "trailers").addHeader("grpc-trace-bin", "").addHeader("grpc-accept-encoding", "gzip").addHeader("grpc-encoding", "gzip").method("POST", requestBody).build());
    }

    @NotNull
    public final OkHttpClient getClient$wire_grpc_client() {
        return this.client;
    }

    @NotNull
    public final HttpUrl getBaseUrl$wire_grpc_client() {
        return this.baseUrl;
    }

    private GrpcClient(OkHttpClient client, HttpUrl baseUrl) {
        this.client = client;
        this.baseUrl = baseUrl;
    }

    public /* synthetic */ GrpcClient(OkHttpClient client, HttpUrl baseUrl, DefaultConstructorMarker $constructor_marker) {
        this(client, baseUrl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00002\n\u0010\b\u001a\u00060\u0004j\u0002`\u0005J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/squareup/wire/GrpcClient$Builder;", "", "()V", "baseUrl", "Lokhttp3/HttpUrl;", "Lcom/squareup/wire/GrpcHttpUrl;", "client", "Lokhttp3/OkHttpClient;", "url", "", "build", "Lcom/squareup/wire/GrpcClient;", "wire-grpc-client"})
    public static final class Builder {
        private OkHttpClient client;
        private HttpUrl baseUrl;

        @NotNull
        public final Builder client(@NotNull OkHttpClient client) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            this.client = client;
            return this;
        }

        @NotNull
        public final Builder baseUrl(@NotNull String baseUrl) {
            Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
            this.baseUrl = GrpcHttpUrlKt.toHttpUrl(baseUrl);
            return this;
        }

        @NotNull
        public final Builder baseUrl(@NotNull HttpUrl url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            this.baseUrl = url;
            return this;
        }

        @NotNull
        public final GrpcClient build() {
            OkHttpClient okHttpClient = this.client;
            if (okHttpClient == null) {
                Intrinsics.throwNpe();
            }
            HttpUrl httpUrl = this.baseUrl;
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            return new GrpcClient(okHttpClient, httpUrl, null);
        }
    }
}

