/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.GrpcEncoding;
import com.squareup.wire.ProtoAdapter;
import java.io.Closeable;
import java.net.ProtocolException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\r\u0010\f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\rR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/squareup/wire/GrpcReader;", "T", "Ljava/io/Closeable;", "source", "Lokio/BufferedSource;", "messageAdapter", "Lcom/squareup/wire/ProtoAdapter;", "grpcEncoding", "Lcom/squareup/wire/GrpcEncoding;", "(Lokio/BufferedSource;Lcom/squareup/wire/ProtoAdapter;Lcom/squareup/wire/GrpcEncoding;)V", "close", "", "readMessage", "()Ljava/lang/Object;", "wire-grpc-client"})
public final class GrpcReader<T>
implements Closeable {
    private final BufferedSource source;
    private final ProtoAdapter<T> messageAdapter;
    private final GrpcEncoding grpcEncoding;

    @Nullable
    public final T readMessage() {
        GrpcEncoding grpcEncoding;
        if (this.source.exhausted()) {
            return null;
        }
        byte compressedFlag = this.source.readByte();
        if (compressedFlag == 0) {
            grpcEncoding = GrpcEncoding.IdentityGrpcEncoding.INSTANCE;
        } else if (compressedFlag == 1) {
            grpcEncoding = this.grpcEncoding;
            if (grpcEncoding == null) {
                throw (Throwable)new ProtocolException("message is encoded but message-encoding header was omitted");
            }
        } else {
            throw (Throwable)new ProtocolException("unexpected compressed-flag: " + compressedFlag);
        }
        GrpcEncoding messageEncoding = grpcEncoding;
        long encodedLength = (long)this.source.readInt() & 0xFFFFFFFFL;
        Buffer encodedMessage = new Buffer();
        encodedMessage.write((Source)this.source, encodedLength);
        return (T)this.messageAdapter.decode(Okio.buffer((Source)messageEncoding.decode((BufferedSource)encodedMessage)));
    }

    @Override
    public void close() {
        this.source.close();
    }

    public GrpcReader(@NotNull BufferedSource source, @NotNull ProtoAdapter<T> messageAdapter, @Nullable GrpcEncoding grpcEncoding) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(messageAdapter, (String)"messageAdapter");
        this.source = source;
        this.messageAdapter = messageAdapter;
        this.grpcEncoding = grpcEncoding;
    }

    public /* synthetic */ GrpcReader(BufferedSource bufferedSource, ProtoAdapter protoAdapter, GrpcEncoding grpcEncoding, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            grpcEncoding = null;
        }
        this(bufferedSource, protoAdapter, grpcEncoding);
    }
}

