/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.GrpcCall;
import com.squareup.wire.GrpcClient;
import com.squareup.wire.GrpcMethod;
import com.squareup.wire.GrpcResponseCloseable;
import com.squareup.wire.internal.GrpcKt;
import com.squareup.wire.internal.GrpcMessageSource;
import com.squareup.wire.internal.LateInitTimeout;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0014\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J)\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00028\u00002\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010%H\u0016\u00a2\u0006\u0002\u0010&J\u0019\u0010'\u001a\u00028\u00012\u0006\u0010#\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0015\u0010)\u001a\u00028\u00012\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J\u0019\u0010+\u001a\u00060\u000bj\u0002`\f2\u0006\u0010#\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\u000eH\u0016J\b\u0010.\u001a\u00020\u000eH\u0016J\u0011\u0010/\u001a\u00028\u0001*\u000200H\u0002\u00a2\u0006\u0002\u00101R\u0016\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R:\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00062"}, d2={"Lcom/squareup/wire/internal/RealGrpcCall;", "S", "", "R", "Lcom/squareup/wire/GrpcCall;", "grpcClient", "Lcom/squareup/wire/GrpcClient;", "method", "Lcom/squareup/wire/GrpcMethod;", "(Lcom/squareup/wire/GrpcClient;Lcom/squareup/wire/GrpcMethod;)V", "call", "Lokhttp3/Call;", "Lcom/squareup/wire/internal/Call;", "canceled", "", "getMethod", "()Lcom/squareup/wire/GrpcMethod;", "requestMetadata", "", "", "getRequestMetadata", "()Ljava/util/Map;", "setRequestMetadata", "(Ljava/util/Map;)V", "<set-?>", "responseMetadata", "getResponseMetadata", "timeout", "Lokio/Timeout;", "getTimeout", "()Lokio/Timeout;", "cancel", "", "clone", "enqueue", "request", "callback", "Lcom/squareup/wire/GrpcCall$Callback;", "(Ljava/lang/Object;Lcom/squareup/wire/GrpcCall$Callback;)V", "execute", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeBlocking", "(Ljava/lang/Object;)Ljava/lang/Object;", "initCall", "(Ljava/lang/Object;)Lokhttp3/Call;", "isCanceled", "isExecuted", "readExactlyOneAndClose", "Lokhttp3/Response;", "(Lokhttp3/Response;)Ljava/lang/Object;", "wire-grpc-client"})
@SourceDebugExtension(value={"SMAP\nRealGrpcCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealGrpcCall.kt\ncom/squareup/wire/internal/RealGrpcCall\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 GrpcResponse.kt\ncom/squareup/wire/GrpcResponseCloseable\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n314#2,11:150\n38#3,8:161\n1#4:169\n*S KotlinDebug\n*F\n+ 1 RealGrpcCall.kt\ncom/squareup/wire/internal/RealGrpcCall\n*L\n57#1:150,11\n107#1:161,8\n*E\n"})
public final class RealGrpcCall<S, R>
implements GrpcCall<S, R> {
    @NotNull
    private final GrpcClient grpcClient;
    @NotNull
    private final GrpcMethod<S, R> method;
    @Nullable
    private Call call;
    private boolean canceled;
    @NotNull
    private final Timeout timeout;
    @NotNull
    private Map<String, String> requestMetadata;
    @Nullable
    private Map<String, String> responseMetadata;

    public RealGrpcCall(@NotNull GrpcClient grpcClient, @NotNull GrpcMethod<S, R> method) {
        Intrinsics.checkNotNullParameter((Object)grpcClient, (String)"grpcClient");
        Intrinsics.checkNotNullParameter(method, (String)"method");
        this.grpcClient = grpcClient;
        this.method = method;
        this.timeout = (Timeout)new LateInitTimeout();
        this.requestMetadata = MapsKt.emptyMap();
    }

    @Override
    @NotNull
    public GrpcMethod<S, R> getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public Timeout getTimeout() {
        return this.timeout;
    }

    @Override
    @NotNull
    public Map<String, String> getRequestMetadata() {
        return this.requestMetadata;
    }

    @Override
    public void setRequestMetadata(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.requestMetadata = map;
    }

    @Override
    @Nullable
    public Map<String, String> getResponseMetadata() {
        return this.responseMetadata;
    }

    @Override
    public void cancel() {
        block0: {
            this.canceled = true;
            Call call = this.call;
            if (call == null) break block0;
            call.cancel();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCanceled() {
        if (this.canceled) return true;
        Call call = this.call;
        if (call == null) return false;
        if (!call.isCanceled()) return false;
        return true;
    }

    @Override
    @Nullable
    public Object execute(@NotNull S request, @NotNull Continuation<? super R> $completion) {
        Call call = this.initCall(request);
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super R> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ RealGrpcCall<S, R> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                this.this$0.cancel();
            }
        });
        call.enqueue(new Callback(continuation, this){
            final /* synthetic */ CancellableContinuation<R> $continuation;
            final /* synthetic */ RealGrpcCall<S, R> this$0;
            {
                this.$continuation = $continuation;
                this.this$0 = $receiver;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    RealGrpcCall.access$setResponseMetadata$p(this.this$0, MapsKt.toMap((Iterable)((Iterable)response.headers())));
                    Object message = RealGrpcCall.access$readExactlyOneAndClose(this.this$0, response);
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)message));
                }
                catch (IOException e) {
                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
                }
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Override
    @NotNull
    public R executeBlocking(@NotNull S request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Call call = this.initCall(request);
        Response response = call.execute();
        this.responseMetadata = MapsKt.toMap((Iterable)((Iterable)response.headers()));
        return this.readExactlyOneAndClose(response);
    }

    @Override
    public void enqueue(@NotNull S request, @NotNull GrpcCall.Callback<S, R> callback) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Call call = this.initCall(request);
        call.enqueue(new Callback(callback, this){
            final /* synthetic */ GrpcCall.Callback<S, R> $callback;
            final /* synthetic */ RealGrpcCall<S, R> this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$callback.onFailure(this.this$0, e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    RealGrpcCall.access$setResponseMetadata$p(this.this$0, MapsKt.toMap((Iterable)((Iterable)response.headers())));
                    Object message = RealGrpcCall.access$readExactlyOneAndClose(this.this$0, response);
                    this.$callback.onSuccess((GrpcCall)this.this$0, message);
                }
                catch (IOException e) {
                    this.$callback.onFailure(this.this$0, e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R readExactlyOneAndClose(Response $this$readExactlyOneAndClose) {
        Response $this$use$iv = $this$readExactlyOneAndClose;
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            Object t;
            Response it = $this$use$iv;
            boolean bl = false;
            Closeable closeable = (Closeable)((Object)GrpcKt.messageSource($this$readExactlyOneAndClose, this.getMethod().getResponseAdapter()));
            Throwable throwable = null;
            try {
                IOException exception;
                Object t2;
                GrpcMessageSource reader = (GrpcMessageSource)((Object)closeable);
                boolean bl2 = false;
                try {
                    t2 = reader.readExactlyOneAndClose();
                }
                catch (IOException e) {
                    IOException iOException = GrpcKt.grpcResponseToException($this$readExactlyOneAndClose, e);
                    Intrinsics.checkNotNull((Object)iOException);
                    throw iOException;
                }
                Object result = t2;
                IOException iOException = exception = GrpcKt.grpcResponseToException$default($this$readExactlyOneAndClose, null, 1, null);
                if (iOException != null) {
                    throw iOException;
                }
                t = result;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        CloseableKt.closeFinally((Closeable)closeable, throwable);
                        throw throwable3;
                    }
                }
                catch (Throwable e$iv) {
                    exception$iv = e$iv;
                    throw e$iv;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            Object t3 = t;
            return (R)t3;
        }
        finally {
            GrpcResponseCloseable.access$closeFinally($this$use$iv, exception$iv);
        }
    }

    @Override
    public boolean isExecuted() {
        Call call = this.call;
        return call != null ? call.isExecuted() : false;
    }

    @Override
    @NotNull
    public GrpcCall<S, R> clone() {
        Timeout timeout;
        RealGrpcCall<S, R> result = new RealGrpcCall<S, R>(this.grpcClient, this.getMethod());
        Timeout oldTimeout = this.getTimeout();
        Timeout newTimeout = timeout = result.getTimeout();
        boolean bl = false;
        newTimeout.timeout(oldTimeout.timeoutNanos(), TimeUnit.NANOSECONDS);
        if (oldTimeout.hasDeadline()) {
            newTimeout.deadlineNanoTime(oldTimeout.deadlineNanoTime());
        }
        result.setRequestMetadata(MapsKt.plus(result.getRequestMetadata(), this.getRequestMetadata()));
        return result;
    }

    private final Call initCall(S request) {
        Call result;
        if (!(this.call == null)) {
            boolean $i$a$-check-RealGrpcCall$initCall$22 = false;
            String $i$a$-check-RealGrpcCall$initCall$22 = "already executed";
            throw new IllegalStateException($i$a$-check-RealGrpcCall$initCall$22.toString());
        }
        RequestBody requestBody = GrpcKt.newRequestBody(this.grpcClient.getMinMessageToCompress$wire_grpc_client(), this.getMethod().getRequestAdapter(), request);
        this.call = result = this.grpcClient.newCall$wire_grpc_client(this.getMethod(), this.getRequestMetadata(), requestBody);
        if (this.canceled) {
            result.cancel();
        }
        Timeout timeout = this.getTimeout();
        Intrinsics.checkNotNull((Object)timeout, (String)"null cannot be cast to non-null type com.squareup.wire.internal.LateInitTimeout");
        ((LateInitTimeout)timeout).init(result.timeout());
        return result;
    }

    public static final /* synthetic */ void access$setResponseMetadata$p(RealGrpcCall $this, Map map) {
        $this.responseMetadata = map;
    }

    public static final /* synthetic */ Object access$readExactlyOneAndClose(RealGrpcCall $this, Response $receiver) {
        return $this.readExactlyOneAndClose($receiver);
    }
}

