(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'wire-library-wire-runtime', 'okio-okio'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('wire-library-wire-runtime'), require('okio-okio'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'wire-library-wire-grpc-client'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'wire-library-wire-grpc-client'.");
    }if (typeof this['wire-library-wire-runtime'] === 'undefined') {
      throw new Error("Error loading module 'wire-library-wire-grpc-client'. Its dependency 'wire-library-wire-runtime' was not found. Please, check whether 'wire-library-wire-runtime' is loaded prior to 'wire-library-wire-grpc-client'.");
    }if (typeof this['okio-okio'] === 'undefined') {
      throw new Error("Error loading module 'wire-library-wire-grpc-client'. Its dependency 'okio-okio' was not found. Please, check whether 'okio-okio' is loaded prior to 'wire-library-wire-grpc-client'.");
    }root['wire-library-wire-grpc-client'] = factory(typeof this['wire-library-wire-grpc-client'] === 'undefined' ? {} : this['wire-library-wire-grpc-client'], kotlin, this['wire-library-wire-runtime'], this['okio-okio']);
  }
}(this, function (_, Kotlin, $module$wire_library_wire_runtime, $module$okio_okio) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Throwable = Error;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var Annotation = Kotlin.kotlin.Annotation;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var ProtocolException = $module$wire_library_wire_runtime.com.squareup.wire.internal.ProtocolException;
  var buffer = $module$okio_okio.okio.buffer_gyfaj4$;
  var Buffer = $module$okio_okio.okio.Buffer;
  var Unit = Kotlin.kotlin.Unit;
  var equals = Kotlin.equals;
  var MessageSink = $module$wire_library_wire_runtime.com.squareup.wire.MessageSink;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var L4294967295 = new Kotlin.Long(-1, 0);
  var buffer_0 = $module$okio_okio.okio.buffer_px5ndk$;
  var MessageSource = $module$wire_library_wire_runtime.com.squareup.wire.MessageSource;
  var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init_pdl1vj$;
  var NotImplementedError_init = Kotlin.kotlin.NotImplementedError;
  GrpcDecoder$IdentityGrpcDecoder.prototype = Object.create(GrpcDecoder.prototype);
  GrpcDecoder$IdentityGrpcDecoder.prototype.constructor = GrpcDecoder$IdentityGrpcDecoder;
  GrpcDecoder$GzipGrpcDecoder.prototype = Object.create(GrpcDecoder.prototype);
  GrpcDecoder$GzipGrpcDecoder.prototype.constructor = GrpcDecoder$GzipGrpcDecoder;
  GrpcEncoder$IdentityGrpcEncoder.prototype = Object.create(GrpcEncoder.prototype);
  GrpcEncoder$IdentityGrpcEncoder.prototype.constructor = GrpcEncoder$IdentityGrpcEncoder;
  GrpcEncoder$GzipGrpcEncoder.prototype = Object.create(GrpcEncoder.prototype);
  GrpcEncoder$GzipGrpcEncoder.prototype.constructor = GrpcEncoder$GzipGrpcEncoder;
  function GrpcCall() {
  }
  function GrpcCall$Callback() {
  }
  GrpcCall$Callback.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Callback',
    interfaces: []
  };
  GrpcCall.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'GrpcCall',
    interfaces: []
  };
  function GrpcMethod(path, requestAdapter, responseAdapter) {
    this.path = path;
    this.requestAdapter = requestAdapter;
    this.responseAdapter = responseAdapter;
  }
  GrpcMethod.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcMethod',
    interfaces: []
  };
  var use = defineInlineFunction('wire-library-wire-grpc-client.com.squareup.wire.use_sn843q$', wrapFunction(function () {
    var Throwable = Error;
    return function ($receiver, block) {
      var exception = null;
      try {
        return block($receiver);
      } catch (e) {
        if (Kotlin.isType(e, Throwable)) {
          exception = e;
          throw e;
        } else
          throw e;
      }
      finally {
        closeFinally($receiver, exception);
      }
    };
  }));
  function closeFinally($receiver, cause) {
    if ($receiver != null)
      if (cause == null)
        $receiver.close();
      else
        try {
          $receiver.close();
        } catch (closeException) {
          if (Kotlin.isType(closeException, Throwable)) {
            addSuppressed(cause, closeException);
          } else
            throw closeException;
        }
  }
  function GrpcStreamingCall() {
  }
  GrpcStreamingCall.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'GrpcStreamingCall',
    interfaces: []
  };
  function WireGrpcExperimental() {
  }
  WireGrpcExperimental.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WireGrpcExperimental',
    interfaces: [Annotation]
  };
  function GrpcDecoder(name) {
    this.name = name;
  }
  function GrpcDecoder$IdentityGrpcDecoder() {
    GrpcDecoder$IdentityGrpcDecoder_instance = this;
    GrpcDecoder.call(this, 'identity');
  }
  GrpcDecoder$IdentityGrpcDecoder.prototype.decode_q9ig0q$ = function (source) {
    return source;
  };
  GrpcDecoder$IdentityGrpcDecoder.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'IdentityGrpcDecoder',
    interfaces: [GrpcDecoder]
  };
  var GrpcDecoder$IdentityGrpcDecoder_instance = null;
  function GrpcDecoder$IdentityGrpcDecoder_getInstance() {
    if (GrpcDecoder$IdentityGrpcDecoder_instance === null) {
      new GrpcDecoder$IdentityGrpcDecoder();
    }return GrpcDecoder$IdentityGrpcDecoder_instance;
  }
  function GrpcDecoder$GzipGrpcDecoder() {
    GrpcDecoder$GzipGrpcDecoder_instance = this;
    GrpcDecoder.call(this, 'gzip');
  }
  GrpcDecoder$GzipGrpcDecoder.prototype.decode_q9ig0q$ = function (source) {
    return asGzip_0(source);
  };
  GrpcDecoder$GzipGrpcDecoder.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'GzipGrpcDecoder',
    interfaces: [GrpcDecoder]
  };
  var GrpcDecoder$GzipGrpcDecoder_instance = null;
  function GrpcDecoder$GzipGrpcDecoder_getInstance() {
    if (GrpcDecoder$GzipGrpcDecoder_instance === null) {
      new GrpcDecoder$GzipGrpcDecoder();
    }return GrpcDecoder$GzipGrpcDecoder_instance;
  }
  GrpcDecoder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcDecoder',
    interfaces: []
  };
  function toGrpcDecoding($receiver) {
    var tmp$;
    switch ($receiver) {
      case 'identity':
        tmp$ = GrpcDecoder$IdentityGrpcDecoder_getInstance();
        break;
      case 'gzip':
        tmp$ = GrpcDecoder$GzipGrpcDecoder_getInstance();
        break;
      case 'deflate':
        throw new ProtocolException('deflate not yet supported');
      case 'snappy':
        throw new ProtocolException('snappy not yet supported');
      default:throw new ProtocolException('unsupported grpc-encoding: ' + $receiver);
    }
    return tmp$;
  }
  function GrpcEncoder(name) {
    this.name = name;
  }
  function GrpcEncoder$IdentityGrpcEncoder() {
    GrpcEncoder$IdentityGrpcEncoder_instance = this;
    GrpcEncoder.call(this, 'identity');
  }
  GrpcEncoder$IdentityGrpcEncoder.prototype.encode_ttbp7m$ = function (sink) {
    return sink;
  };
  GrpcEncoder$IdentityGrpcEncoder.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'IdentityGrpcEncoder',
    interfaces: [GrpcEncoder]
  };
  var GrpcEncoder$IdentityGrpcEncoder_instance = null;
  function GrpcEncoder$IdentityGrpcEncoder_getInstance() {
    if (GrpcEncoder$IdentityGrpcEncoder_instance === null) {
      new GrpcEncoder$IdentityGrpcEncoder();
    }return GrpcEncoder$IdentityGrpcEncoder_instance;
  }
  function GrpcEncoder$GzipGrpcEncoder() {
    GrpcEncoder$GzipGrpcEncoder_instance = this;
    GrpcEncoder.call(this, 'gzip');
  }
  GrpcEncoder$GzipGrpcEncoder.prototype.encode_ttbp7m$ = function (sink) {
    return buffer(asGzip(sink));
  };
  GrpcEncoder$GzipGrpcEncoder.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'GzipGrpcEncoder',
    interfaces: [GrpcEncoder]
  };
  var GrpcEncoder$GzipGrpcEncoder_instance = null;
  function GrpcEncoder$GzipGrpcEncoder_getInstance() {
    if (GrpcEncoder$GzipGrpcEncoder_instance === null) {
      new GrpcEncoder$GzipGrpcEncoder();
    }return GrpcEncoder$GzipGrpcEncoder_instance;
  }
  GrpcEncoder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcEncoder',
    interfaces: []
  };
  function toGrpcEncoder($receiver) {
    var tmp$;
    switch ($receiver) {
      case 'identity':
        tmp$ = GrpcEncoder$IdentityGrpcEncoder_getInstance();
        break;
      case 'gzip':
        tmp$ = GrpcEncoder$GzipGrpcEncoder_getInstance();
        break;
      case 'deflate':
        throw new ProtocolException('deflate not yet supported');
      case 'snappy':
        throw new ProtocolException('snappy not yet supported');
      default:throw new ProtocolException('unsupported grpc-encoding: ' + $receiver);
    }
    return tmp$;
  }
  function GrpcMessageSink(sink, messageAdapter, callForCancel, grpcEncoding) {
    this.sink_0 = sink;
    this.messageAdapter_0 = messageAdapter;
    this.callForCancel_0 = callForCancel;
    this.grpcEncoding_0 = grpcEncoding;
    this.closed_0 = false;
  }
  GrpcMessageSink.prototype.write_trkh7z$ = function (message) {
    if (!!this.closed_0) {
      var message_0 = 'closed';
      throw IllegalStateException_init(message_0.toString());
    }var encodedMessage = new Buffer();
    var $receiver = toGrpcEncoder(this.grpcEncoding_0).encode_ttbp7m$(encodedMessage);
    var closed = false;
    try {
      this.messageAdapter_0.encode_qla68p$($receiver, message);
    } catch (first) {
      if (Kotlin.isType(first, Throwable)) {
        try {
          closed = true;
          $receiver.close();
        } catch (second) {
          if (Kotlin.isType(second, Throwable)) {
            addSuppressed(first, second);
          } else
            throw second;
        }
        throw first;
      } else
        throw first;
    }
    finally {
      if (!closed) {
        $receiver.close();
      }}
    var compressedFlag = equals(this.grpcEncoding_0, 'identity') ? 0 : 1;
    this.sink_0.writeByte_za3lpa$(compressedFlag);
    this.sink_0.writeInt_za3lpa$(encodedMessage.size.toInt());
    this.sink_0.writeAll_sby9nd$(encodedMessage);
    this.sink_0.flush();
  };
  GrpcMessageSink.prototype.cancel = function () {
    var tmp$;
    if (!!this.closed_0) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }(tmp$ = this.callForCancel_0) != null ? (tmp$.cancel(), Unit) : null;
  };
  GrpcMessageSink.prototype.close = function () {
    if (this.closed_0)
      return;
    this.closed_0 = true;
    this.sink_0.close();
  };
  GrpcMessageSink.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcMessageSink',
    interfaces: [MessageSink]
  };
  function GrpcMessageSource(source, messageAdapter, grpcEncoding) {
    if (grpcEncoding === void 0)
      grpcEncoding = null;
    this.source_0 = source;
    this.messageAdapter_0 = messageAdapter;
    this.grpcEncoding_0 = grpcEncoding;
  }
  GrpcMessageSource.prototype.read = function () {
    var tmp$, tmp$_0, tmp$_1;
    if (this.source_0.exhausted())
      return null;
    var compressedFlag = this.source_0.readByte();
    if (compressedFlag === 0)
      tmp$_1 = GrpcDecoder$IdentityGrpcDecoder_getInstance();
    else if (compressedFlag === 1) {
      tmp$_0 = (tmp$ = this.grpcEncoding_0) != null ? toGrpcDecoding(tmp$) : null;
      if (tmp$_0 == null) {
        throw new ProtocolException('message is encoded but message-encoding header was omitted');
      }tmp$_1 = tmp$_0;
    } else
      throw new ProtocolException('unexpected compressed-flag: ' + compressedFlag);
    var messageDecoding = tmp$_1;
    var encodedLength = Kotlin.Long.fromInt(this.source_0.readInt()).and(L4294967295);
    var encodedMessage = (new Buffer()).write_9ujt9g$(this.source_0, encodedLength);
    var $receiver = buffer_0(messageDecoding.decode_q9ig0q$(encodedMessage));
    var tmp$_2;
    var closed = false;
    try {
      tmp$_2 = this.messageAdapter_0.decode_q9ig0q$($receiver);
    } catch (first) {
      if (Kotlin.isType(first, Throwable)) {
        try {
          closed = true;
          $receiver.close();
        } catch (second) {
          if (Kotlin.isType(second, Throwable)) {
            addSuppressed(first, second);
          } else
            throw second;
        }
        throw first;
      } else
        throw first;
    }
    finally {
      if (!closed) {
        $receiver.close();
      }}
    return tmp$_2;
  };
  GrpcMessageSource.prototype.readExactlyOneAndClose = function () {
    var closed = false;
    try {
      var tmp$;
      tmp$ = this.read();
      if (tmp$ == null) {
        throw new ProtocolException('expected 1 message but got none');
      }var result = tmp$;
      var end = this.read();
      if (end != null)
        throw new ProtocolException('expected 1 message but got multiple');
      return result;
    } catch (first) {
      if (Kotlin.isType(first, Throwable)) {
        try {
          closed = true;
          this.close();
        } catch (second) {
          if (Kotlin.isType(second, Throwable)) {
            addSuppressed(first, second);
          } else
            throw second;
        }
        throw first;
      } else
        throw first;
    }
    finally {
      if (!closed) {
        this.close();
      }}
  };
  GrpcMessageSource.prototype.close = function () {
    this.source_0.close();
  };
  GrpcMessageSource.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcMessageSource',
    interfaces: [MessageSource]
  };
  var use_0 = defineInlineFunction('wire-library-wire-grpc-client.com.squareup.wire.internal.use_dwuh8n$', wrapFunction(function () {
    var addSuppressed = _.com.squareup.wire.internal.addSuppressed_oz8fe6$;
    var Throwable = Error;
    return function ($receiver, close, block) {
      var tmp$;
      var closed = false;
      try {
        tmp$ = block($receiver);
      } catch (first) {
        if (Kotlin.isType(first, Throwable)) {
          try {
            closed = true;
            close($receiver);
          } catch (second) {
            if (Kotlin.isType(second, Throwable)) {
              addSuppressed(first, second);
            } else
              throw second;
          }
          throw first;
        } else
          throw first;
      }
      finally {
        if (!closed) {
          close($receiver);
        }}
      return tmp$;
    };
  }));
  function GrpcClient() {
  }
  GrpcClient.prototype.newCall_8ij2xl$ = function (method) {
    throw UnsupportedOperationException_init("wire-grpc-client doesn't support JS yet.");
  };
  GrpcClient.prototype.newStreamingCall_8ij2xl$ = function (method) {
    throw UnsupportedOperationException_init("wire-grpc-client doesn't support JS yet.");
  };
  GrpcClient.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcClient',
    interfaces: []
  };
  function GrpcHeaders() {
  }
  GrpcHeaders.prototype.get_61zpoe$ = function (name) {
    throw new NotImplementedError_init();
  };
  GrpcHeaders.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcHeaders',
    interfaces: []
  };
  function GrpcHttpUrl() {
  }
  GrpcHttpUrl.prototype.resolve_61zpoe$ = function (link) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Not yet implemented');
  };
  GrpcHttpUrl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcHttpUrl',
    interfaces: []
  };
  function toHttpUrl($receiver) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Not yet implemented');
  }
  function GrpcRequest() {
  }
  GrpcRequest.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcRequest',
    interfaces: []
  };
  function GrpcRequestBuilder() {
  }
  GrpcRequestBuilder.prototype.url_mkvohj$ = function (url) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Not yet implemented');
  };
  GrpcRequestBuilder.prototype.addHeader_puj7f4$ = function (name, value) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Not yet implemented');
  };
  GrpcRequestBuilder.prototype.method_34dpmi$ = function (method, body) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Not yet implemented');
  };
  GrpcRequestBuilder.prototype.build = function () {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Not yet implemented');
  };
  GrpcRequestBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcRequestBuilder',
    interfaces: []
  };
  function GrpcRequestBody() {
  }
  GrpcRequestBody.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcRequestBody',
    interfaces: []
  };
  function GrpcResponse() {
  }
  Object.defineProperty(GrpcResponse.prototype, 'body', {
    get: function () {
      throw new NotImplementedError_init('An operation is not implemented: ' + 'Not yet implemented');
    }
  });
  GrpcResponse.prototype.header_jyasbz$ = function (name, defaultValue) {
    if (defaultValue === void 0)
      defaultValue = null;
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Not yet implemented');
  };
  GrpcResponse.prototype.trailers = function () {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Not yet implemented');
  };
  GrpcResponse.prototype.close = function () {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Not yet implemented');
  };
  GrpcResponse.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcResponse',
    interfaces: []
  };
  function GrpcResponseBody() {
  }
  GrpcResponseBody.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GrpcResponseBody',
    interfaces: []
  };
  function Call() {
  }
  Call.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Call',
    interfaces: []
  };
  function asGzip($receiver) {
    throw UnsupportedOperationException_init('Gzip not implemented for JS');
  }
  function asGzip_0($receiver) {
    throw UnsupportedOperationException_init('Gzip not implemented for JS');
  }
  function addSuppressed($receiver, other) {
  }
  GrpcCall.Callback = GrpcCall$Callback;
  var package$com = _.com || (_.com = {});
  var package$squareup = package$com.squareup || (package$com.squareup = {});
  var package$wire = package$squareup.wire || (package$squareup.wire = {});
  package$wire.GrpcCall = GrpcCall;
  package$wire.GrpcMethod = GrpcMethod;
  $$importsForInline$$['wire-library-wire-grpc-client'] = _;
  package$wire.use_sn843q$ = use;
  package$wire.GrpcStreamingCall = GrpcStreamingCall;
  package$wire.WireGrpcExperimental = WireGrpcExperimental;
  Object.defineProperty(GrpcDecoder, 'IdentityGrpcDecoder', {
    get: GrpcDecoder$IdentityGrpcDecoder_getInstance
  });
  Object.defineProperty(GrpcDecoder, 'GzipGrpcDecoder', {
    get: GrpcDecoder$GzipGrpcDecoder_getInstance
  });
  var package$internal = package$wire.internal || (package$wire.internal = {});
  package$internal.GrpcDecoder = GrpcDecoder;
  package$internal.toGrpcDecoding_7efafi$ = toGrpcDecoding;
  Object.defineProperty(GrpcEncoder, 'IdentityGrpcEncoder', {
    get: GrpcEncoder$IdentityGrpcEncoder_getInstance
  });
  Object.defineProperty(GrpcEncoder, 'GzipGrpcEncoder', {
    get: GrpcEncoder$GzipGrpcEncoder_getInstance
  });
  package$internal.GrpcEncoder = GrpcEncoder;
  package$internal.toGrpcEncoder_7efafi$ = toGrpcEncoder;
  package$internal.GrpcMessageSink = GrpcMessageSink;
  package$internal.GrpcMessageSource = GrpcMessageSource;
  package$internal.addSuppressed_oz8fe6$ = addSuppressed;
  package$internal.use_dwuh8n$ = use_0;
  package$wire.GrpcClient = GrpcClient;
  package$wire.GrpcHeaders = GrpcHeaders;
  package$wire.GrpcHttpUrl = GrpcHttpUrl;
  package$wire.toHttpUrl_pdl1vz$ = toHttpUrl;
  package$wire.GrpcRequest = GrpcRequest;
  package$wire.GrpcRequestBuilder = GrpcRequestBuilder;
  package$wire.GrpcRequestBody = GrpcRequestBody;
  package$wire.GrpcResponse = GrpcResponse;
  package$wire.GrpcResponseBody = GrpcResponseBody;
  package$internal.Call = Call;
  package$internal.asGzip_wcsnxv$ = asGzip;
  package$internal.asGzip_kweupx$ = asGzip_0;
  Kotlin.defineModule('wire-library-wire-grpc-client', _);
  return _;
}));

//# sourceMappingURL=wire-library-wire-grpc-client.js.map
