/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0000\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0000\u001a(\u0010\u000f\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u0013H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"UNICODE_BOMS", "Lokio/Options;", "endsWithDotProto", "", "Lokio/Path;", "readBomAsCharset", "Ljava/nio/charset/Charset;", "Lokio/BufferedSource;", "default", "relativize", "", "descendant", "toOkioFileSystem", "Lokio/FileSystem;", "Ljava/nio/file/FileSystem;", "visitAll", "", "path", "block", "Lkotlin/Function1;", "wire-compiler"})
public final class FileSystemsKt {
    @NotNull
    private static final Options UNICODE_BOMS;

    public static final void visitAll(@NotNull okio.FileSystem $this$visitAll, @NotNull Path path, @NotNull Function1<? super Path, Unit> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$visitAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        block.invoke((Object)path);
        try {
            object = $this$visitAll.list(path);
        }
        catch (IOException e) {
            boolean bl = false;
            object = CollectionsKt.emptyList();
        }
        List toVisit = object;
        for (Path child : toVisit) {
            FileSystemsKt.visitAll($this$visitAll, child, block);
        }
    }

    @NotNull
    public static final okio.FileSystem toOkioFileSystem(@NotNull FileSystem $this$toOkioFileSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$toOkioFileSystem, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$toOkioFileSystem, (Object)FileSystems.getDefault())) {
            String string = Intrinsics.stringPlus((String)"Wire doesn't support non-default file system: ", (Object)$this$toOkioFileSystem);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return okio.FileSystem.SYSTEM;
    }

    @NotNull
    public static final String relativize(@NotNull Path $this$relativize, @NotNull Path descendant) {
        Intrinsics.checkNotNullParameter((Object)$this$relativize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descendant, (String)"descendant");
        if (Intrinsics.areEqual((Object)$this$relativize, (Object)descendant)) {
            return "";
        }
        String descendantString = descendant.toString();
        String thisString = $this$relativize.toString();
        String string = thisString;
        int slashIndex = (Intrinsics.areEqual((Object)string, (Object)"/") ? true : Intrinsics.areEqual((Object)string, (Object)"\\")) ? 0 : thisString.length();
        boolean bl = StringsKt.startsWith$default((String)descendantString, (String)thisString, (boolean)false, (int)2, null) && (descendantString.charAt(slashIndex) == '/' || descendantString.charAt(slashIndex) == '\\');
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string2 = "not a descendant of " + thisString + ": " + descendantString;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        String string3 = descendantString;
        n = slashIndex + 1;
        bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        return string5;
    }

    public static final boolean endsWithDotProto(@NotNull Path $this$endsWithDotProto) {
        Intrinsics.checkNotNullParameter((Object)$this$endsWithDotProto, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$endsWithDotProto.toString(), (String)".proto", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final Charset readBomAsCharset(@NotNull BufferedSource $this$readBomAsCharset, @NotNull Charset charset) {
        Charset charset2;
        Intrinsics.checkNotNullParameter((Object)$this$readBomAsCharset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"default");
        int n = $this$readBomAsCharset.select(UNICODE_BOMS);
        switch (n) {
            case 0: {
                charset2 = Charsets.UTF_8;
                break;
            }
            case 1: {
                charset2 = Charsets.UTF_16BE;
                break;
            }
            case 2: {
                charset2 = Charsets.UTF_16LE;
                break;
            }
            case 3: {
                charset2 = Charsets.INSTANCE.UTF32_BE();
                break;
            }
            case 4: {
                charset2 = Charsets.INSTANCE.UTF32_LE();
                break;
            }
            case -1: {
                charset2 = charset;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return charset2;
    }

    public static /* synthetic */ Charset readBomAsCharset$default(BufferedSource bufferedSource, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileSystemsKt.readBomAsCharset(bufferedSource, charset);
    }

    static {
        ByteString[] byteStringArray = new ByteString[]{ByteString.Companion.decodeHex("efbbbf"), ByteString.Companion.decodeHex("feff"), ByteString.Companion.decodeHex("fffe"), ByteString.Companion.decodeHex("0000ffff"), ByteString.Companion.decodeHex("ffff0000")};
        UNICODE_BOMS = Options.Companion.of(byteStringArray);
    }
}

