/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javapoet.JavaFile;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.wire.WireLogger;
import com.squareup.wire.schema.ProtoType;
import io.outfoxx.swiftpoet.FileSpec;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/squareup/wire/ConsoleWireLogger;", "Lcom/squareup/wire/WireLogger;", "()V", "quiet", "", "artifact", "", "outputPath", "Lokio/Path;", "javaFile", "Lcom/squareup/javapoet/JavaFile;", "kotlinFile", "Lcom/squareup/kotlinpoet/FileSpec;", "type", "Lcom/squareup/wire/schema/ProtoType;", "swiftFile", "Lio/outfoxx/swiftpoet/FileSpec;", "filePath", "", "artifactSkipped", "setQuiet", "warn", "message", "wire-compiler"})
public final class ConsoleWireLogger
implements WireLogger {
    private boolean quiet;

    @Override
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.quiet) {
            boolean bl = false;
            System.out.println((Object)message);
        }
    }

    @Override
    public void artifact(@NotNull Path outputPath, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.quiet) {
            boolean bl = false;
            System.out.println((Object)filePath);
        } else {
            String string = "Writing " + filePath + " to " + outputPath;
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    @Override
    public void artifact(@NotNull Path outputPath, @NotNull JavaFile javaFile) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)javaFile, (String)"javaFile");
        if (this.quiet) {
            String string = javaFile.packageName + '.' + javaFile.typeSpec.name;
            boolean bl = false;
            System.out.println((Object)string);
        } else {
            String string = "Writing " + javaFile.packageName + '.' + javaFile.typeSpec.name + " to " + outputPath;
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    @Override
    public void artifact(@NotNull Path outputPath, @NotNull com.squareup.kotlinpoet.FileSpec kotlinFile) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)kotlinFile, (String)"kotlinFile");
        Object object = CollectionsKt.first((List)kotlinFile.getMembers());
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.squareup.kotlinpoet.TypeSpec");
        }
        TypeSpec typeSpec = (TypeSpec)object;
        if (this.quiet) {
            String string = kotlinFile.getPackageName() + '.' + typeSpec.getName();
            boolean bl = false;
            System.out.println((Object)string);
        } else {
            String string = "Writing " + kotlinFile.getPackageName() + '.' + typeSpec.getName() + " to " + outputPath;
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    @Override
    public void artifact(@NotNull Path outputPath, @NotNull ProtoType type, @NotNull FileSpec swiftFile) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)swiftFile, (String)"swiftFile");
        if (this.quiet) {
            String string = swiftFile.getName();
            boolean bl = false;
            System.out.println((Object)string);
        } else {
            String string = "Writing " + type + " to " + outputPath;
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    @Override
    public void artifactSkipped(@NotNull ProtoType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String string = "Skipping " + type;
        boolean bl = false;
        System.out.println((Object)string);
    }
}

