/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.WireLogger;
import com.squareup.wire.schema.ClaimedDefinitions;
import com.squareup.wire.schema.EmittingRules;
import com.squareup.wire.schema.NewProfileLoader;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Target;
import com.squareup.wire.schema.Type;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J-\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0002\b\"J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\f\u0010$\u001a\u00020\n*\u00020%H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/squareup/wire/schema/ProtoTarget;", "Lcom/squareup/wire/schema/Target;", "outDirectory", "", "(Ljava/lang/String;)V", "excludes", "", "getExcludes", "()Ljava/util/List;", "exclusive", "", "getExclusive", "()Z", "includes", "getIncludes", "getOutDirectory", "()Ljava/lang/String;", "component1", "copy", "equals", "other", "", "hashCode", "", "newHandler", "Lcom/squareup/wire/schema/Target$SchemaHandler;", "schema", "Lcom/squareup/wire/schema/Schema;", "fs", "Ljava/nio/file/FileSystem;", "logger", "Lcom/squareup/wire/WireLogger;", "newProfileLoader", "Lcom/squareup/wire/schema/NewProfileLoader;", "newHandler$wire_compiler", "toString", "isEmpty", "Lcom/squareup/wire/schema/ProtoFile;", "wire-compiler"})
public final class ProtoTarget
extends Target {
    @NotNull
    private final List<String> includes;
    @NotNull
    private final List<String> excludes;
    private final boolean exclusive = false;
    @NotNull
    private final String outDirectory;

    @Override
    @NotNull
    public List<String> getIncludes() {
        return this.includes;
    }

    @Override
    @NotNull
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean getExclusive() {
        return this.exclusive;
    }

    @Override
    @NotNull
    public Target.SchemaHandler newHandler$wire_compiler(@NotNull Schema schema, @NotNull FileSystem fs, @NotNull WireLogger logger, @NotNull NewProfileLoader newProfileLoader) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)newProfileLoader, (String)"newProfileLoader");
        return new Target.SchemaHandler(this, fs, logger){
            final /* synthetic */ ProtoTarget this$0;
            final /* synthetic */ FileSystem $fs;
            final /* synthetic */ WireLogger $logger;

            public void handle(@NotNull Type type) {
                Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            }

            public void handle(@NotNull Service service) {
                Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(@NotNull ProtoFile protoFile, @NotNull EmittingRules emittingRules, @NotNull ClaimedDefinitions claimedDefinitions, boolean isExclusive) {
                Intrinsics.checkParameterIsNotNull((Object)protoFile, (String)"protoFile");
                Intrinsics.checkParameterIsNotNull((Object)emittingRules, (String)"emittingRules");
                Intrinsics.checkParameterIsNotNull((Object)claimedDefinitions, (String)"claimedDefinitions");
                if (ProtoTarget.access$isEmpty(this.this$0, protoFile)) {
                    return;
                }
                String relativePath = StringsKt.substringBeforeLast((String)protoFile.getLocation().getPath(), (String)"/", (String)".");
                Path outputDirectory = this.$fs.getPath(this.this$0.getOutDirectory(), relativePath);
                boolean bl = Files.notExists(outputDirectory, new LinkOption[0]) || Files.isDirectory(outputDirectory, new LinkOption[0]);
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "path " + outputDirectory + " exists but is not a directory.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                Files.createDirectories(outputDirectory, new FileAttribute[0]);
                Path outputFilePath = outputDirectory.resolve(protoFile.name() + ".proto");
                Path path = outputDirectory;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"outputDirectory");
                this.$logger.artifact(path, protoFile.getLocation().getPath());
                Path path2 = outputFilePath;
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"outputFilePath");
                Closeable closeable = (Closeable)Okio.buffer((Sink)Okio.sink((Path)path2, (OpenOption[])new OpenOption[0]));
                bl3 = false;
                Throwable throwable = null;
                try {
                    BufferedSink bufferedSink;
                    BufferedSink sink = (BufferedSink)closeable;
                    boolean bl5 = false;
                    try {
                        bufferedSink = sink.writeUtf8(protoFile.toSchema());
                    }
                    catch (IOException e) {
                        throw (Throwable)new IOException("Error emitting " + outputFilePath + " to " + this.this$0.getOutDirectory(), e);
                    }
                    BufferedSink bufferedSink2 = bufferedSink;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = $outer;
                this.$fs = $captured_local_variable$1;
                this.$logger = $captured_local_variable$2;
            }
        };
    }

    private final boolean isEmpty(@NotNull ProtoFile $this$isEmpty) {
        return $this$isEmpty.getTypes().isEmpty() && $this$isEmpty.getServices().isEmpty() && $this$isEmpty.getExtendList().isEmpty();
    }

    @NotNull
    public final String getOutDirectory() {
        return this.outDirectory;
    }

    public ProtoTarget(@NotNull String outDirectory) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)outDirectory, (String)"outDirectory");
        super(null);
        this.outDirectory = outDirectory;
        ProtoTarget protoTarget = this;
        boolean bl = false;
        protoTarget.includes = list = CollectionsKt.emptyList();
        protoTarget = this;
        bl = false;
        protoTarget.excludes = list = CollectionsKt.emptyList();
    }

    public static final /* synthetic */ boolean access$isEmpty(ProtoTarget $this, ProtoFile $this$access_u24isEmpty) {
        return $this.isEmpty($this$access_u24isEmpty);
    }

    @NotNull
    public final String component1() {
        return this.outDirectory;
    }

    @NotNull
    public final ProtoTarget copy(@NotNull String outDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)outDirectory, (String)"outDirectory");
        return new ProtoTarget(outDirectory);
    }

    public static /* synthetic */ ProtoTarget copy$default(ProtoTarget protoTarget, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = protoTarget.outDirectory;
        }
        return protoTarget.copy(string);
    }

    @NotNull
    public String toString() {
        return "ProtoTarget(outDirectory=" + this.outDirectory + ")";
    }

    public int hashCode() {
        String string = this.outDirectory;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ProtoTarget)) break block3;
                ProtoTarget protoTarget = (ProtoTarget)object;
                if (!Intrinsics.areEqual((Object)this.outDirectory, (Object)protoTarget.outDirectory)) break block3;
            }
            return true;
        }
        return false;
    }
}

