/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.java.internal.ProfileFileElement;
import com.squareup.wire.java.internal.ProfileParser;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Root;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/squareup/wire/schema/ProtoFilePath;", "Lcom/squareup/wire/schema/Root;", "location", "Lcom/squareup/wire/schema/Location;", "path", "Ljava/nio/file/Path;", "(Lcom/squareup/wire/schema/Location;Ljava/nio/file/Path;)V", "base", "", "getBase", "()Ljava/lang/String;", "getLocation", "()Lcom/squareup/wire/schema/Location;", "getPath", "()Ljava/nio/file/Path;", "allProtoFiles", "", "parse", "Lcom/squareup/wire/schema/ProtoFile;", "parseProfile", "Lcom/squareup/wire/java/internal/ProfileFileElement;", "resolve", "import", "toString", "wire-compiler"})
public final class ProtoFilePath
extends Root {
    @NotNull
    private final Location location;
    @NotNull
    private final Path path;

    @Override
    @Nullable
    public String getBase() {
        return null;
    }

    @Override
    @NotNull
    public Set<ProtoFilePath> allProtoFiles() {
        return SetsKt.setOf((Object)this);
    }

    @Override
    @Nullable
    public ProtoFilePath resolve(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"import");
        if (Intrinsics.areEqual((Object)string, (Object)this.location.getPath())) {
            return this;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ProtoFile parse() {
        try {
            Closeable closeable = (Closeable)Okio.buffer((Source)Okio.source((Path)this.path, (OpenOption[])new OpenOption[0]));
            boolean bl = false;
            Throwable throwable = null;
            try {
                BufferedSource source = (BufferedSource)closeable;
                boolean bl2 = false;
                String data = source.readUtf8();
                ProtoFileElement element = ProtoParser.Companion.parse(this.location, data);
                ProtoFile protoFile = ProtoFile.Companion.get(element);
                return protoFile;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Failed to load " + this.path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ProfileFileElement parseProfile() {
        try {
            Closeable closeable = (Closeable)Okio.buffer((Source)Okio.source((Path)this.path, (OpenOption[])new OpenOption[0]));
            boolean bl = false;
            Throwable throwable = null;
            try {
                ProfileFileElement element;
                BufferedSource source = (BufferedSource)closeable;
                boolean bl2 = false;
                String data = source.readUtf8();
                ProfileFileElement profileFileElement = element = new ProfileParser(this.location, data).read();
                return profileFileElement;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Failed to load " + this.path, e);
        }
    }

    @NotNull
    public String toString() {
        return this.location.toString();
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public ProtoFilePath(@NotNull Location location, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        super(null);
        this.location = location;
        this.path = path;
    }
}

