/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ConsoleWireLogger;
import com.squareup.wire.JavaFileWriter;
import com.squareup.wire.KotlinFileWriter;
import com.squareup.wire.PendingFileSpec;
import com.squareup.wire.PendingServiceFileSpec;
import com.squareup.wire.PendingTypeFileSpec;
import com.squareup.wire.WireException;
import com.squareup.wire.WireLogger;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.Profile;
import com.squareup.wire.java.ProfileLoader;
import com.squareup.wire.kotlin.KotlinGenerator;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.PruningRules;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u007f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u000f\u0012\u0006\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010)\u001a\u00020*R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u0013\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%\u00a8\u0006,"}, d2={"Lcom/squareup/wire/WireCompiler;", "", "fs", "Ljava/nio/file/FileSystem;", "log", "Lcom/squareup/wire/WireLogger;", "protoPaths", "", "", "javaOut", "kotlinOut", "sourceFileNames", "pruningRules", "Lcom/squareup/wire/schema/PruningRules;", "dryRun", "", "namedFilesOnly", "emitAndroid", "emitAndroidAnnotations", "emitCompact", "javaInterop", "(Ljava/nio/file/FileSystem;Lcom/squareup/wire/WireLogger;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/squareup/wire/schema/PruningRules;ZZZZZZ)V", "getDryRun", "()Z", "getEmitAndroid", "getEmitAndroidAnnotations", "getEmitCompact", "getFs", "()Ljava/nio/file/FileSystem;", "getJavaInterop", "getJavaOut", "()Ljava/lang/String;", "getKotlinOut", "getLog", "()Lcom/squareup/wire/WireLogger;", "getNamedFilesOnly", "getProtoPaths", "()Ljava/util/List;", "getPruningRules", "()Lcom/squareup/wire/schema/PruningRules;", "getSourceFileNames", "compile", "", "Companion", "wire-compiler"})
public final class WireCompiler {
    @NotNull
    private final FileSystem fs;
    @NotNull
    private final WireLogger log;
    @NotNull
    private final List<String> protoPaths;
    @Nullable
    private final String javaOut;
    @Nullable
    private final String kotlinOut;
    @NotNull
    private final List<String> sourceFileNames;
    @NotNull
    private final PruningRules pruningRules;
    private final boolean dryRun;
    private final boolean namedFilesOnly;
    private final boolean emitAndroid;
    private final boolean emitAndroidAnnotations;
    private final boolean emitCompact;
    private final boolean javaInterop;
    @NotNull
    public static final String CODE_GENERATED_BY_WIRE = "Code generated by Wire protocol buffer compiler, do not edit.";
    private static final String PROTO_PATH_FLAG = "--proto_path=";
    private static final String JAVA_OUT_FLAG = "--java_out=";
    private static final String KOTLIN_OUT_FLAG = "--kotlin_out=";
    private static final String FILES_FLAG = "--files=";
    private static final String INCLUDES_FLAG = "--includes=";
    private static final String EXCLUDES_FLAG = "--excludes=";
    private static final String QUIET_FLAG = "--quiet";
    private static final String DRY_RUN_FLAG = "--dry_run";
    private static final String NAMED_FILES_ONLY = "--named_files_only";
    private static final String ANDROID = "--android";
    private static final String ANDROID_ANNOTATIONS = "--android-annotations";
    private static final String COMPACT = "--compact";
    private static final String JAVA_INTEROP = "--java_interop";
    private static final int MAX_WRITE_CONCURRENCY = 8;
    private static final String DESCRIPTOR_PROTO = "google/protobuf/descriptor.proto";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void compile() throws IOException {
        Object object;
        SchemaLoader schemaLoader = new SchemaLoader();
        for (String protoPath : this.protoPaths) {
            Path path = this.fs.getPath(protoPath, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"fs.getPath(protoPath)");
            schemaLoader.addSource(path);
        }
        for (String sourceFileName : this.sourceFileNames) {
            schemaLoader.addProto(sourceFileName);
        }
        Schema schema = schemaLoader.load();
        if (!this.pruningRules.isEmpty()) {
            this.log.info("Analyzing dependencies of root types.");
            schema = schema.prune(this.pruningRules);
            for (String rule : this.pruningRules.unusedRoots()) {
                this.log.info("Unused include: " + rule);
            }
            for (String rule : this.pruningRules.unusedPrunes()) {
                this.log.info("Unused exclude: " + rule);
            }
        }
        ConcurrentLinkedQueue<PendingFileSpec> queue = new ConcurrentLinkedQueue<PendingFileSpec>();
        for (ProtoFile protoFile : schema.getProtoFiles()) {
            Service p1;
            boolean bl;
            Collection<Object> collection;
            Iterable $this$mapTo$iv$iv;
            if (!this.sourceFileNames.isEmpty() && !this.sourceFileNames.contains(protoFile.getLocation().getPath()) && (this.namedFilesOnly || Intrinsics.areEqual((Object)protoFile.getLocation().getPath(), (Object)DESCRIPTOR_PROTO))) continue;
            Iterable iterable = protoFile.getTypes();
            ConcurrentLinkedQueue<PendingFileSpec> concurrentLinkedQueue = queue;
            boolean $i$f$map = false;
            Iterable iterable2 = iterable;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Type type = (Type)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                object = new PendingTypeFileSpec((Type)p1);
                collection.add(object);
            }
            collection = (List)destination$iv$iv;
            concurrentLinkedQueue.addAll((Collection)collection);
            Iterable iterable3 = protoFile.getServices();
            concurrentLinkedQueue = queue;
            $i$f$map = false;
            $this$mapTo$iv$iv = iterable3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p1 = (Service)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                object = new PendingServiceFileSpec(p1);
                collection.add(object);
            }
            collection = (List)destination$iv$iv;
            concurrentLinkedQueue.addAll(collection);
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList futures = new ArrayList(8);
        if (this.javaOut != null) {
            void $this$filterIsInstanceTo$iv$iv;
            Object item$iv$iv;
            String string = this.emitAndroid ? "android" : "java";
            Profile profile = new ProfileLoader(string).schema(schema).load();
            JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema).withProfile(profile).withAndroid(this.emitAndroid).withAndroidAnnotations(this.emitAndroidAnnotations).withCompact(this.emitCompact);
            Iterable $this$filterIsInstance$iv232 = queue;
            boolean $i$f$filterIsInstance = false;
            item$iv$iv = $this$filterIsInstance$iv232;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PendingTypeFileSpec)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = (List)destination$iv$iv;
            Collection collection = (Collection)object;
            ConcurrentLinkedQueue<PendingTypeFileSpec> types = new ConcurrentLinkedQueue<PendingTypeFileSpec>(collection);
            int $this$filterIsInstance$iv232 = 0;
            int n = 8;
            while ($this$filterIsInstance$iv232 < n) {
                void i;
                JavaGenerator javaGenerator2 = javaGenerator;
                Intrinsics.checkExpressionValueIsNotNull((Object)javaGenerator2, (String)"javaGenerator");
                JavaFileWriter task = new JavaFileWriter(this.javaOut, javaGenerator2, types, this.dryRun, this.fs, this.log);
                futures.add(executor.submit(task));
                ++i;
            }
        } else if (this.kotlinOut != null) {
            KotlinGenerator kotlinGenerator = KotlinGenerator.Companion.get$default((KotlinGenerator.Companion)KotlinGenerator.Companion, (Schema)schema, (boolean)this.emitAndroid, (boolean)this.javaInterop, null, null, (int)24, null);
            int profile = 0;
            int n = 8;
            while (profile < n) {
                void i;
                KotlinFileWriter task = new KotlinFileWriter(this.kotlinOut, kotlinGenerator, queue, this.fs, this.log, this.dryRun);
                futures.add(executor.submit(task));
                ++i;
            }
        } else {
            throw (Throwable)((Object)new AssertionError());
        }
        executor.shutdown();
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (ExecutionException executionException) {
            throw (Throwable)new IOException(executionException.getMessage(), executionException);
        }
        catch (InterruptedException interruptedException) {
            throw (Throwable)new RuntimeException(interruptedException.getMessage(), interruptedException);
        }
    }

    @NotNull
    public final FileSystem getFs() {
        return this.fs;
    }

    @NotNull
    public final WireLogger getLog() {
        return this.log;
    }

    @NotNull
    public final List<String> getProtoPaths() {
        return this.protoPaths;
    }

    @Nullable
    public final String getJavaOut() {
        return this.javaOut;
    }

    @Nullable
    public final String getKotlinOut() {
        return this.kotlinOut;
    }

    @NotNull
    public final List<String> getSourceFileNames() {
        return this.sourceFileNames;
    }

    @NotNull
    public final PruningRules getPruningRules() {
        return this.pruningRules;
    }

    public final boolean getDryRun() {
        return this.dryRun;
    }

    public final boolean getNamedFilesOnly() {
        return this.namedFilesOnly;
    }

    public final boolean getEmitAndroid() {
        return this.emitAndroid;
    }

    public final boolean getEmitAndroidAnnotations() {
        return this.emitAndroidAnnotations;
    }

    public final boolean getEmitCompact() {
        return this.emitCompact;
    }

    public final boolean getJavaInterop() {
        return this.javaInterop;
    }

    public WireCompiler(@NotNull FileSystem fs, @NotNull WireLogger log, @NotNull List<String> protoPaths, @Nullable String javaOut, @Nullable String kotlinOut, @NotNull List<String> sourceFileNames, @NotNull PruningRules pruningRules, boolean dryRun, boolean namedFilesOnly, boolean emitAndroid, boolean emitAndroidAnnotations, boolean emitCompact, boolean javaInterop) {
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        Intrinsics.checkParameterIsNotNull(protoPaths, (String)"protoPaths");
        Intrinsics.checkParameterIsNotNull(sourceFileNames, (String)"sourceFileNames");
        Intrinsics.checkParameterIsNotNull((Object)pruningRules, (String)"pruningRules");
        this.fs = fs;
        this.log = log;
        this.protoPaths = protoPaths;
        this.javaOut = javaOut;
        this.kotlinOut = kotlinOut;
        this.sourceFileNames = sourceFileNames;
        this.pruningRules = pruningRules;
        this.dryRun = dryRun;
        this.namedFilesOnly = namedFilesOnly;
        this.emitAndroid = emitAndroid;
        this.emitAndroidAnnotations = emitAndroidAnnotations;
        this.emitCompact = emitCompact;
        this.javaInterop = javaInterop;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws IOException {
        Companion.main(args);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final WireCompiler forArgs(@NotNull FileSystem fileSystem, @NotNull WireLogger logger, String ... args) throws WireException {
        return Companion.forArgs(fileSystem, logger, args);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final WireCompiler forArgs(@NotNull FileSystem fileSystem, String ... args) throws WireException {
        return com.squareup.wire.WireCompiler$Companion.forArgs$default(Companion, fileSystem, null, args, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final WireCompiler forArgs(String ... args) throws WireException {
        return com.squareup.wire.WireCompiler$Companion.forArgs$default(Companion, null, null, args, 3, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001c\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u001e\u001a\u00020\u001f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cH\u0007\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/squareup/wire/WireCompiler$Companion;", "", "()V", "ANDROID", "", "ANDROID_ANNOTATIONS", "CODE_GENERATED_BY_WIRE", "COMPACT", "DESCRIPTOR_PROTO", "DRY_RUN_FLAG", "EXCLUDES_FLAG", "FILES_FLAG", "INCLUDES_FLAG", "JAVA_INTEROP", "JAVA_OUT_FLAG", "KOTLIN_OUT_FLAG", "MAX_WRITE_CONCURRENCY", "", "NAMED_FILES_ONLY", "PROTO_PATH_FLAG", "QUIET_FLAG", "forArgs", "Lcom/squareup/wire/WireCompiler;", "fileSystem", "Ljava/nio/file/FileSystem;", "logger", "Lcom/squareup/wire/WireLogger;", "args", "", "(Ljava/nio/file/FileSystem;Lcom/squareup/wire/WireLogger;[Ljava/lang/String;)Lcom/squareup/wire/WireCompiler;", "main", "", "([Ljava/lang/String;)V", "wire-compiler"})
    public static final class Companion {
        @JvmStatic
        public final void main(@NotNull String[] args) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            try {
                WireCompiler wireCompiler = com.squareup.wire.WireCompiler$Companion.forArgs$default(this, null, null, Arrays.copyOf(args, args.length), 3, null);
                wireCompiler.compile();
            }
            catch (WireException e) {
                System.err.print("Fatal: ");
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final WireCompiler forArgs(@NotNull FileSystem fileSystem, @NotNull WireLogger logger, String ... args) throws WireException {
            Intrinsics.checkParameterIsNotNull((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            boolean bl = false;
            List sourceFileNames = new ArrayList();
            PruningRules.Builder pruningRulesBuilder = new PruningRules.Builder();
            boolean bl2 = false;
            List protoPaths = new ArrayList();
            String javaOut = null;
            String kotlinOut = null;
            boolean quiet = false;
            boolean dryRun = false;
            boolean namedFilesOnly = false;
            boolean emitAndroid = false;
            boolean emitAndroidAnnotations = false;
            boolean emitCompact = false;
            boolean javaInterop = false;
            for (String arg : args) {
                int n;
                Object object;
                List list;
                String string;
                if (StringsKt.startsWith$default((String)arg, (String)WireCompiler.PROTO_PATH_FLAG, (boolean)false, (int)2, null)) {
                    string = arg;
                    int n2 = WireCompiler.PROTO_PATH_FLAG.length();
                    list = protoPaths;
                    boolean bl3 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                    list.add(object);
                    continue;
                }
                if (StringsKt.startsWith$default((String)arg, (String)WireCompiler.JAVA_OUT_FLAG, (boolean)false, (int)2, null)) {
                    boolean bl4 = javaOut == null;
                    int n3 = 0;
                    boolean bl5 = false;
                    if (!bl4) {
                        boolean bl6 = false;
                        String string3 = "java_out already set";
                        throw (Throwable)new IllegalStateException(string3.toString());
                    }
                    string = arg;
                    n3 = WireCompiler.JAVA_OUT_FLAG.length();
                    bl5 = false;
                    String string4 = string;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
                    continue;
                }
                if (StringsKt.startsWith$default((String)arg, (String)WireCompiler.KOTLIN_OUT_FLAG, (boolean)false, (int)2, null)) {
                    boolean bl7 = kotlinOut == null;
                    int n4 = 0;
                    boolean bl8 = false;
                    if (!bl7) {
                        boolean bl9 = false;
                        String string5 = "kotlin_out already set";
                        throw (Throwable)new IllegalStateException(string5.toString());
                    }
                    string = arg;
                    n4 = WireCompiler.KOTLIN_OUT_FLAG.length();
                    bl8 = false;
                    String string6 = string;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6.substring(n4), (String)"(this as java.lang.String).substring(startIndex)");
                    continue;
                }
                if (StringsKt.startsWith$default((String)arg, (String)WireCompiler.FILES_FLAG, (boolean)false, (int)2, null)) {
                    String string7;
                    Object object2 = arg;
                    int n5 = WireCompiler.FILES_FLAG.length();
                    boolean bl10 = false;
                    String string8 = object2;
                    if (string8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8.substring(n5), (String)"(this as java.lang.String).substring(startIndex)");
                    String string9 = string7;
                    File files = new File(string9);
                    try {
                        object2 = (Closeable)Okio.buffer((Source)Okio.source((File)files));
                        n5 = 0;
                        Throwable throwable = null;
                        try {
                            BufferedSource source = (BufferedSource)object2;
                            boolean bl11 = false;
                            while (source.readUtf8Line() != null) {
                                String line;
                                sourceFileNames.add(line);
                            }
                            Unit unit = Unit.INSTANCE;
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        throw (Throwable)new WireException("Error processing argument " + arg, ex);
                    }
                }
                if (StringsKt.startsWith$default((String)arg, (String)WireCompiler.INCLUDES_FLAG, (boolean)false, (int)2, null)) {
                    String includes;
                    CharSequence charSequence = arg;
                    int n6 = WireCompiler.INCLUDES_FLAG.length();
                    n = 0;
                    String string10 = charSequence;
                    if (string10 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string10.substring(n6), (String)"(this as java.lang.String).substring(startIndex)");
                    charSequence = includes;
                    Regex regex = new Regex(",");
                    list = pruningRulesBuilder;
                    n = 0;
                    boolean bl12 = false;
                    object = regex.split(charSequence, n);
                    list.addRoot((Iterable)object);
                    continue;
                }
                if (StringsKt.startsWith$default((String)arg, (String)WireCompiler.EXCLUDES_FLAG, (boolean)false, (int)2, null)) {
                    String excludes;
                    CharSequence charSequence = arg;
                    int n7 = WireCompiler.EXCLUDES_FLAG.length();
                    n = 0;
                    String string11 = charSequence;
                    if (string11 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string11.substring(n7), (String)"(this as java.lang.String).substring(startIndex)");
                    charSequence = excludes;
                    Regex regex = new Regex(",");
                    list = pruningRulesBuilder;
                    n = 0;
                    boolean bl13 = false;
                    object = regex.split(charSequence, n);
                    list.prune((Iterable)object);
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)WireCompiler.QUIET_FLAG)) {
                    quiet = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)WireCompiler.DRY_RUN_FLAG)) {
                    dryRun = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)WireCompiler.NAMED_FILES_ONLY)) {
                    namedFilesOnly = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)WireCompiler.ANDROID)) {
                    emitAndroid = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)WireCompiler.ANDROID_ANNOTATIONS)) {
                    emitAndroidAnnotations = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)WireCompiler.COMPACT)) {
                    emitCompact = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)arg, (Object)WireCompiler.JAVA_INTEROP)) {
                    javaInterop = true;
                    continue;
                }
                if (StringsKt.startsWith$default((String)arg, (String)"--", (boolean)false, (int)2, null)) {
                    throw (Throwable)new IllegalArgumentException("Unknown argument '" + arg + "'.");
                }
                sourceFileNames.add(arg);
            }
            if (javaOut != null == (kotlinOut != null)) {
                throw (Throwable)new WireException("Only one of --java_out= or --kotlin_out= flag must be specified");
            }
            logger.setQuiet(quiet);
            return new WireCompiler(fileSystem, logger, protoPaths, javaOut, kotlinOut, sourceFileNames, pruningRulesBuilder.build(), dryRun, namedFilesOnly, emitAndroid, emitAndroidAnnotations, emitCompact, javaInterop);
        }

        public static /* synthetic */ WireCompiler forArgs$default(Companion companion, FileSystem fileSystem, WireLogger wireLogger, String[] stringArray, int n, Object object) throws WireException {
            if ((n & 1) != 0) {
                FileSystem fileSystem2 = FileSystems.getDefault();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem2, (String)"FileSystems.getDefault()");
                fileSystem = fileSystem2;
            }
            if ((n & 2) != 0) {
                wireLogger = new ConsoleWireLogger();
            }
            return companion.forArgs(fileSystem, wireLogger, stringArray);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final WireCompiler forArgs(@NotNull FileSystem fileSystem, String ... args) throws WireException {
            return com.squareup.wire.WireCompiler$Companion.forArgs$default(this, fileSystem, null, args, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final WireCompiler forArgs(String ... args) throws WireException {
            return com.squareup.wire.WireCompiler$Companion.forArgs$default(this, null, null, args, 3, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

