/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.ConsoleWireLogger;
import com.squareup.wire.WireException;
import com.squareup.wire.WireLogger;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.Profile;
import com.squareup.wire.java.ProfileLoader;
import com.squareup.wire.schema.IdentifierSet;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.Type;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class WireCompiler {
    public static final String PROTO_PATH_FLAG = "--proto_path=";
    public static final String JAVA_OUT_FLAG = "--java_out=";
    public static final String FILES_FLAG = "--files=";
    public static final String INCLUDES_FLAG = "--includes=";
    public static final String EXCLUDES_FLAG = "--excludes=";
    public static final String QUIET_FLAG = "--quiet";
    public static final String DRY_RUN_FLAG = "--dry_run";
    public static final String NAMED_FILES_ONLY = "--named_files_only";
    public static final String ANDROID = "--android";
    public static final String COMPACT = "--compact";
    public static final int MAX_WRITE_CONCURRENCY = 8;
    private static final String CODE_GENERATED_BY_WIRE = "Code generated by Wire protocol buffer compiler, do not edit.";
    private static final String DESCRIPTOR_PROTO = "google/protobuf/descriptor.proto";
    private final FileSystem fs;
    private final WireLogger log;
    final List<String> protoPaths;
    final String javaOut;
    final List<String> sourceFileNames;
    final IdentifierSet identifierSet;
    final boolean dryRun;
    final boolean namedFilesOnly;
    final boolean emitAndroid;
    final boolean emitCompact;

    WireCompiler(FileSystem fs, WireLogger log, List<String> protoPaths, String javaOut, List<String> sourceFileNames, IdentifierSet identifierSet, boolean dryRun, boolean namedFilesOnly, boolean emitAndroid, boolean emitCompact) {
        this.fs = fs;
        this.log = log;
        this.protoPaths = protoPaths;
        this.javaOut = javaOut;
        this.sourceFileNames = sourceFileNames;
        this.identifierSet = identifierSet;
        this.dryRun = dryRun;
        this.namedFilesOnly = namedFilesOnly;
        this.emitAndroid = emitAndroid;
        this.emitCompact = emitCompact;
    }

    public static void main(String ... args) throws IOException {
        try {
            WireCompiler wireCompiler = WireCompiler.forArgs(args);
            wireCompiler.compile();
        }
        catch (WireException e) {
            System.err.print("Fatal: ");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    static WireCompiler forArgs(String ... args) throws WireException {
        return WireCompiler.forArgs(FileSystems.getDefault(), new ConsoleWireLogger(), args);
    }

    static WireCompiler forArgs(FileSystem fileSystem, WireLogger logger, String ... args) throws WireException {
        ArrayList<String> sourceFileNames = new ArrayList<String>();
        IdentifierSet.Builder identifierSetBuilder = new IdentifierSet.Builder();
        ArrayList<String> protoPaths = new ArrayList<String>();
        String javaOut = null;
        boolean quiet = false;
        boolean dryRun = false;
        boolean namedFilesOnly = false;
        boolean emitAndroid = false;
        boolean emitCompact = false;
        for (String arg : args) {
            if (arg.startsWith(PROTO_PATH_FLAG)) {
                protoPaths.add(arg.substring(PROTO_PATH_FLAG.length()));
                continue;
            }
            if (arg.startsWith(JAVA_OUT_FLAG)) {
                javaOut = arg.substring(JAVA_OUT_FLAG.length());
                continue;
            }
            if (arg.startsWith(FILES_FLAG)) {
                String[] fileNames;
                File files = new File(arg.substring(FILES_FLAG.length()));
                try {
                    fileNames = new Scanner(files, "UTF-8").useDelimiter("\\A").next().split("\n");
                }
                catch (FileNotFoundException ex) {
                    throw new WireException("Error processing argument " + arg, ex);
                }
                sourceFileNames.addAll(Arrays.asList(fileNames));
                continue;
            }
            if (arg.startsWith(INCLUDES_FLAG)) {
                for (String identifier : WireCompiler.splitArg(arg, INCLUDES_FLAG.length())) {
                    identifierSetBuilder.include(identifier);
                }
                continue;
            }
            if (arg.startsWith(EXCLUDES_FLAG)) {
                for (String identifier : WireCompiler.splitArg(arg, EXCLUDES_FLAG.length())) {
                    identifierSetBuilder.exclude(identifier);
                }
                continue;
            }
            if (arg.equals(QUIET_FLAG)) {
                quiet = true;
                continue;
            }
            if (arg.equals(DRY_RUN_FLAG)) {
                dryRun = true;
                continue;
            }
            if (arg.equals(NAMED_FILES_ONLY)) {
                namedFilesOnly = true;
                continue;
            }
            if (arg.equals(ANDROID)) {
                emitAndroid = true;
                continue;
            }
            if (arg.equals(COMPACT)) {
                emitCompact = true;
                continue;
            }
            if (arg.startsWith("--")) {
                throw new IllegalArgumentException("Unknown argument '" + arg + "'.");
            }
            sourceFileNames.add(arg);
        }
        if (javaOut == null) {
            throw new WireException("Must specify --java_out= flag");
        }
        logger.setQuiet(quiet);
        return new WireCompiler(fileSystem, logger, protoPaths, javaOut, sourceFileNames, identifierSetBuilder.build(), dryRun, namedFilesOnly, emitAndroid, emitCompact);
    }

    private static List<String> splitArg(String arg, int flagLength) {
        return Arrays.asList(arg.substring(flagLength).split(","));
    }

    void compile() throws IOException {
        SchemaLoader schemaLoader = new SchemaLoader();
        for (String protoPath : this.protoPaths) {
            schemaLoader.addSource(this.fs.getPath(protoPath, new String[0]));
        }
        for (String sourceFileName : this.sourceFileNames) {
            schemaLoader.addProto(sourceFileName);
        }
        Schema schema = schemaLoader.load();
        String profileName = this.emitAndroid ? "android" : "java";
        Profile profile = new ProfileLoader(profileName).schema(schema).load();
        if (!this.identifierSet.isEmpty()) {
            this.log.info("Analyzing dependencies of root types.");
            schema = schema.prune(this.identifierSet);
            for (String rule : this.identifierSet.unusedIncludes()) {
                this.log.info("Unused include: " + rule);
            }
            for (String rule : this.identifierSet.unusedExcludes()) {
                this.log.info("Unused exclude: " + rule);
            }
        }
        JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema).withProfile(profile).withAndroid(this.emitAndroid).withCompact(this.emitCompact);
        ConcurrentLinkedQueue<Type> types = new ConcurrentLinkedQueue<Type>();
        for (ProtoFile protoFile : schema.protoFiles()) {
            if (!this.sourceFileNames.isEmpty() && !this.sourceFileNames.contains(protoFile.location().path()) && (this.namedFilesOnly || protoFile.location().path().equals(DESCRIPTOR_PROTO))) continue;
            types.addAll((Collection<Type>)protoFile.types());
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(8);
        for (int i = 0; i < 8; ++i) {
            futures.add(i, executor.submit(new JavaFileWriter(javaGenerator, types)));
        }
        executor.shutdown();
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    class JavaFileWriter
    implements Callable<Void> {
        private final JavaGenerator javaGenerator;
        private final ConcurrentLinkedQueue<Type> queue;

        public JavaFileWriter(JavaGenerator javaGenerator, ConcurrentLinkedQueue<Type> queue) {
            this.javaGenerator = javaGenerator;
            this.queue = queue;
        }

        @Override
        public Void call() throws IOException {
            Type type;
            while ((type = this.queue.poll()) != null) {
                TypeSpec typeSpec = this.javaGenerator.generateType(type);
                ClassName javaTypeName = this.javaGenerator.generatedTypeName(type);
                Location location = type.location();
                JavaFile.Builder builder = JavaFile.builder((String)javaTypeName.packageName(), (TypeSpec)typeSpec).addFileComment("$L", new Object[]{WireCompiler.CODE_GENERATED_BY_WIRE});
                if (location != null) {
                    builder.addFileComment("\nSource file: $L", new Object[]{location.withPathOnly()});
                }
                JavaFile javaFile = builder.build();
                Path path = WireCompiler.this.fs.getPath(WireCompiler.this.javaOut, new String[0]);
                WireCompiler.this.log.artifact(path, javaFile);
                try {
                    if (WireCompiler.this.dryRun) continue;
                    javaFile.writeTo(path);
                }
                catch (IOException e) {
                    throw new IOException("Error emitting " + javaFile.packageName + "." + javaFile.typeSpec.name + " to " + WireCompiler.this.javaOut, e);
                }
            }
            return null;
        }
    }
}

