/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.CommandLineOptions;
import com.squareup.wire.ConsoleWireLogger;
import com.squareup.wire.WireException;
import com.squareup.wire.WireLogger;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.TypeWriter;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.IOException;

public final class WireCompiler {
    private static final String CODE_GENERATED_BY_WIRE = "Code generated by Wire protocol buffer compiler, do not edit.";
    private final Loader loader;
    private final JavaGenerator.IO javaGeneratorIo;
    private final CommandLineOptions options;
    private final WireLogger log;

    public static void main(String ... args) {
        try {
            new WireCompiler(new CommandLineOptions(args)).compile();
        }
        catch (WireException e) {
            System.err.print("Fatal: ");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    WireCompiler(CommandLineOptions options) throws WireException {
        this(options, Loader.forSearchPaths(options.protoPaths()), JavaGenerator.IO.DEFAULT, new ConsoleWireLogger(options.quiet));
    }

    WireCompiler(CommandLineOptions options, Loader loader, JavaGenerator.IO javaGeneratorIo, WireLogger logger) throws WireException {
        this.options = options;
        this.loader = loader;
        this.javaGeneratorIo = javaGeneratorIo;
        this.log = logger;
        if (options.javaOut == null) {
            throw new WireException("Must specify --java_out= flag");
        }
    }

    public void compile() throws WireException {
        Schema schema;
        try {
            schema = this.loader.load(this.options.sourceFileNames);
        }
        catch (IOException e) {
            throw new WireException(e);
        }
        if (!this.options.roots.isEmpty()) {
            this.log.info("Analyzing dependencies of root types.");
            schema = schema.retainRoots(this.options.roots);
        }
        JavaGenerator javaGenerator = JavaGenerator.get(schema);
        TypeWriter typeWriter = new TypeWriter(javaGenerator, this.options.emitOptions, this.options.enumOptions);
        for (ProtoFile protoFile : schema.protoFiles()) {
            if (!this.options.sourceFileNames.contains(protoFile.location().path())) continue;
            for (Type type : protoFile.types()) {
                ClassName javaTypeName = (ClassName)javaGenerator.typeName(type.name());
                TypeSpec typeSpec = typeWriter.toTypeSpec(type);
                this.writeJavaFile(javaTypeName, typeSpec, type.location());
            }
            if (this.options.serviceFactory != null) {
                for (Service service : protoFile.services()) {
                    TypeSpec typeSpec = this.options.serviceFactory.create(javaGenerator, this.options.serviceFactoryOptions, service);
                    ClassName baseJavaTypeName = (ClassName)javaGenerator.typeName(service.name());
                    ClassName generatedJavaTypeName = baseJavaTypeName.peerClass(typeSpec.name);
                    this.writeJavaFile(generatedJavaTypeName, typeSpec, service.location());
                }
            }
            if (protoFile.extendList().isEmpty()) continue;
            ClassName javaTypeName = javaGenerator.extensionsClass(protoFile);
            TypeSpec typeSpec = typeWriter.extensionsType(javaTypeName, protoFile);
            this.writeJavaFile(javaTypeName, typeSpec, protoFile.location());
        }
        if (this.options.registryClass != null) {
            ClassName className = ClassName.bestGuess((String)this.options.registryClass);
            TypeSpec typeSpec = typeWriter.registryType(className, schema);
            this.writeJavaFile(className, typeSpec, null);
        }
    }

    private void writeJavaFile(ClassName javaTypeName, TypeSpec typeSpec, Location location) throws WireException {
        JavaFile.Builder builder = JavaFile.builder((String)javaTypeName.packageName(), (TypeSpec)typeSpec).addFileComment("$L", new Object[]{CODE_GENERATED_BY_WIRE});
        if (location != null) {
            builder.addFileComment("\nSource file: $L", new Object[]{location});
        }
        JavaFile javaFile = builder.build();
        this.log.artifact(this.options.javaOut, javaFile);
        try {
            if (!this.options.dryRun) {
                this.javaGeneratorIo.write(this.options.javaOut, javaFile);
            }
        }
        catch (IOException e) {
            throw new WireException("Error emitting " + javaFile.packageName + "." + javaFile.typeSpec.name + " to " + this.options.javaOut, e);
        }
    }
}

