/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.ProtoSchemaParser;
import com.squareup.wire.OutputArtifact;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

interface IO {
    public ProtoFile parse(String var1) throws IOException;

    public JavaWriter getJavaWriter(OutputArtifact var1) throws IOException;

    public static class FileIO
    implements IO {
        private static final Charset UTF_8 = Charset.forName("UTF8");

        @Override
        public ProtoFile parse(String filename) throws IOException {
            return ProtoSchemaParser.parse((String)filename, (Reader)new InputStreamReader((InputStream)new FileInputStream(filename), UTF_8));
        }

        @Override
        public JavaWriter getJavaWriter(OutputArtifact artifact) throws IOException {
            artifact.dir().mkdirs();
            return new JavaWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(artifact.file()), UTF_8));
        }
    }
}

