/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.Service;
import com.squareup.wire.ServiceWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.lang.model.element.Modifier;

abstract class AbstractServiceWriter
extends ServiceWriter {
    public AbstractServiceWriter(JavaWriter writer, List<String> options) {
        super(writer, options);
    }

    @Override
    public void emitService(Service service, Set<String> importedTypes) throws IOException {
        importedTypes.addAll(this.getImports(service));
        this.writer.emitImports(importedTypes);
        this.writer.emitEmptyLine();
        if (!service.getDocumentation().isEmpty()) {
            this.writer.emitJavadoc(service.getDocumentation(), new Object[0]);
        }
        this.writer.beginType(service.getName(), "interface", EnumSet.of(Modifier.PUBLIC));
        for (Service.Method method : service.getMethods()) {
            String requestType = method.getRequestType();
            int index = requestType.lastIndexOf(46);
            if (index != -1) {
                requestType = requestType.substring(index + 1);
            }
            if (!method.getDocumentation().isEmpty()) {
                this.writer.emitJavadoc(method.getDocumentation(), new Object[0]);
            }
            this.emitAnnotation(service, method);
            this.writer.beginMethod(method.getResponseType(), this.getMethodName(method), EnumSet.noneOf(Modifier.class), Arrays.asList(this.getRequestType(requestType), this.getRequestName(requestType)), this.getThrows());
            this.writer.endMethod();
        }
        this.writer.endType();
    }

    List<String> getImports(Service service) {
        return null;
    }

    void emitAnnotation(Service service, Service.Method method) throws IOException {
    }

    String getMethodName(Service.Method method) {
        return this.lowerCaseInitialLetter(method.getName());
    }

    String getRequestName(String requestType) {
        return this.lowerCaseInitialLetter(requestType);
    }

    String lowerCaseInitialLetter(String name) {
        return name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
    }

    String getRequestType(String baseType) {
        return baseType;
    }

    List<String> getThrows() {
        return null;
    }
}

