/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.tape;

import com.squareup.tape.ObjectQueue;
import com.squareup.tape.Task;
import com.squareup.tape.TaskInjector;

public class TaskQueue<T extends Task>
implements ObjectQueue<T> {
    private final TaskInjector<T> taskInjector;
    private final ObjectQueue<T> delegate;

    public TaskQueue(ObjectQueue<T> delegate) {
        this(delegate, null);
    }

    public TaskQueue(ObjectQueue<T> delegate, TaskInjector<T> taskInjector) {
        this.delegate = delegate;
        this.taskInjector = taskInjector;
    }

    @Override
    public T peek() {
        Task task = (Task)this.delegate.peek();
        if (task != null && this.taskInjector != null) {
            this.taskInjector.injectMembers(task);
        }
        return (T)task;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void add(T entry) {
        this.delegate.add(entry);
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public void setListener(final ObjectQueue.Listener<T> listener) {
        if (listener != null) {
            this.delegate.setListener(new ObjectQueue.Listener<T>(){

                @Override
                public void onAdd(ObjectQueue<T> queue, T entry) {
                    listener.onAdd(TaskQueue.this, entry);
                }

                @Override
                public void onRemove(ObjectQueue<T> queue) {
                    listener.onRemove(TaskQueue.this);
                }
            });
        } else {
            this.delegate.setListener(null);
        }
    }
}

