/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.tape;

import com.squareup.tape.FileException;
import com.squareup.tape.ObjectQueue;
import com.squareup.tape.QueueFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileObjectQueue<T>
implements ObjectQueue<T> {
    private final QueueFile queueFile;
    private final DirectByteArrayOutputStream bytes = new DirectByteArrayOutputStream();
    private final File file;
    private final Converter<T> converter;
    private ObjectQueue.Listener<T> listener;

    public FileObjectQueue(File file, Converter<T> converter) throws IOException {
        this.file = file;
        this.converter = converter;
        this.queueFile = new QueueFile(file);
    }

    @Override
    public int size() {
        return this.queueFile.size();
    }

    @Override
    public final void add(T entry) {
        try {
            this.bytes.reset();
            this.converter.toStream(entry, this.bytes);
            this.queueFile.add(this.bytes.getArray(), 0, this.bytes.size());
            if (this.listener != null) {
                this.listener.onAdd(this, entry);
            }
        }
        catch (IOException e) {
            throw new FileException("Failed to add entry.", e, this.file);
        }
    }

    @Override
    public T peek() {
        try {
            byte[] bytes = this.queueFile.peek();
            if (bytes == null) {
                return null;
            }
            return this.converter.from(bytes);
        }
        catch (IOException e) {
            throw new FileException("Failed to peek.", e, this.file);
        }
    }

    @Override
    public final void remove() {
        try {
            this.queueFile.remove();
            if (this.listener != null) {
                this.listener.onRemove(this);
            }
        }
        catch (IOException e) {
            throw new FileException("Failed to remove.", e, this.file);
        }
    }

    @Override
    public void setListener(final ObjectQueue.Listener<T> listener) {
        if (listener != null) {
            try {
                this.queueFile.forEach(new QueueFile.ElementReader(){

                    @Override
                    public void read(InputStream in, int length) throws IOException {
                        byte[] data = new byte[length];
                        in.read(data, 0, length);
                        listener.onAdd(FileObjectQueue.this, FileObjectQueue.this.converter.from(data));
                    }
                });
            }
            catch (IOException e) {
                throw new FileException("Unable to iterate over QueueFile contents.", e, this.file);
            }
        }
        this.listener = listener;
    }

    private static class DirectByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getArray() {
            return this.buf;
        }
    }

    public static interface Converter<T> {
        public T from(byte[] var1) throws IOException;

        public void toStream(T var1, OutputStream var2) throws IOException;
    }
}

