/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.webhooks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateWebhookSubscriptionSignatureKeyRequest {
    private final String subscriptionId;
    private final Optional<String> idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private UpdateWebhookSubscriptionSignatureKeyRequest(String subscriptionId, Optional<String> idempotencyKey, Map<String, Object> additionalProperties) {
        this.subscriptionId = subscriptionId;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subscription_id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonIgnore
    public Optional<String> getIdempotencyKey() {
        if (this.idempotencyKey == null) {
            return Optional.empty();
        }
        return this.idempotencyKey;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="idempotency_key")
    private Optional<String> _getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateWebhookSubscriptionSignatureKeyRequest && this.equalTo((UpdateWebhookSubscriptionSignatureKeyRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateWebhookSubscriptionSignatureKeyRequest other) {
        return this.subscriptionId.equals(other.subscriptionId) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SubscriptionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SubscriptionIdStage,
    _FinalStage {
        private String subscriptionId;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateWebhookSubscriptionSignatureKeyRequest other) {
            this.subscriptionId(other.getSubscriptionId());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="subscription_id")
        public _FinalStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(Nullable<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey.isNull() ? null : (idempotencyKey.isEmpty() ? Optional.empty() : Optional.of(idempotencyKey.get()));
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public UpdateWebhookSubscriptionSignatureKeyRequest build() {
            return new UpdateWebhookSubscriptionSignatureKeyRequest(this.subscriptionId, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateWebhookSubscriptionSignatureKeyRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);

        public _FinalStage idempotencyKey(Nullable<String> var1);
    }

    public static interface SubscriptionIdStage {
        public _FinalStage subscriptionId(@NotNull String var1);

        public Builder from(UpdateWebhookSubscriptionSignatureKeyRequest var1);
    }
}

