/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.webhooks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListSubscriptionsRequest {
    private final Optional<String> cursor;
    private final Optional<Boolean> includeDisabled;
    private final Optional<SortOrder> sortOrder;
    private final Optional<Integer> limit;
    private final Map<String, Object> additionalProperties;

    private ListSubscriptionsRequest(Optional<String> cursor, Optional<Boolean> includeDisabled, Optional<SortOrder> sortOrder, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.cursor = cursor;
        this.includeDisabled = includeDisabled;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<Boolean> getIncludeDisabled() {
        if (this.includeDisabled == null) {
            return Optional.empty();
        }
        return this.includeDisabled;
    }

    @JsonIgnore
    public Optional<SortOrder> getSortOrder() {
        if (this.sortOrder == null) {
            return Optional.empty();
        }
        return this.sortOrder;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="include_disabled")
    private Optional<Boolean> _getIncludeDisabled() {
        return this.includeDisabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_order")
    private Optional<SortOrder> _getSortOrder() {
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListSubscriptionsRequest && this.equalTo((ListSubscriptionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListSubscriptionsRequest other) {
        return this.cursor.equals(other.cursor) && this.includeDisabled.equals(other.includeDisabled) && this.sortOrder.equals(other.sortOrder) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.includeDisabled, this.sortOrder, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> cursor = Optional.empty();
        private Optional<Boolean> includeDisabled = Optional.empty();
        private Optional<SortOrder> sortOrder = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListSubscriptionsRequest other) {
            this.cursor(other.getCursor());
            this.includeDisabled(other.getIncludeDisabled());
            this.sortOrder(other.getSortOrder());
            this.limit(other.getLimit());
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @JsonSetter(value="include_disabled", nulls=Nulls.SKIP)
        public Builder includeDisabled(Optional<Boolean> includeDisabled) {
            this.includeDisabled = includeDisabled;
            return this;
        }

        public Builder includeDisabled(Boolean includeDisabled) {
            this.includeDisabled = Optional.ofNullable(includeDisabled);
            return this;
        }

        public Builder includeDisabled(Nullable<Boolean> includeDisabled) {
            this.includeDisabled = includeDisabled.isNull() ? null : (includeDisabled.isEmpty() ? Optional.empty() : Optional.of(includeDisabled.get()));
            return this;
        }

        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public Builder sortOrder(Optional<SortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        public Builder sortOrder(Nullable<SortOrder> sortOrder) {
            this.sortOrder = sortOrder.isNull() ? null : (sortOrder.isEmpty() ? Optional.empty() : Optional.of(sortOrder.get()));
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        public ListSubscriptionsRequest build() {
            return new ListSubscriptionsRequest(this.cursor, this.includeDisabled, this.sortOrder, this.limit, this.additionalProperties);
        }
    }
}

