/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.webhooks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListEventTypesRequest {
    private final Optional<String> apiVersion;
    private final Map<String, Object> additionalProperties;

    private ListEventTypesRequest(Optional<String> apiVersion, Map<String, Object> additionalProperties) {
        this.apiVersion = apiVersion;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getApiVersion() {
        if (this.apiVersion == null) {
            return Optional.empty();
        }
        return this.apiVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="api_version")
    private Optional<String> _getApiVersion() {
        return this.apiVersion;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListEventTypesRequest && this.equalTo((ListEventTypesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEventTypesRequest other) {
        return this.apiVersion.equals(other.apiVersion);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> apiVersion = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListEventTypesRequest other) {
            this.apiVersion(other.getApiVersion());
            return this;
        }

        @JsonSetter(value="api_version", nulls=Nulls.SKIP)
        public Builder apiVersion(Optional<String> apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = Optional.ofNullable(apiVersion);
            return this;
        }

        public Builder apiVersion(Nullable<String> apiVersion) {
            this.apiVersion = apiVersion.isNull() ? null : (apiVersion.isEmpty() ? Optional.empty() : Optional.of(apiVersion.get()));
            return this;
        }

        public ListEventTypesRequest build() {
            return new ListEventTypesRequest(this.apiVersion, this.additionalProperties);
        }
    }
}

