/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Vendor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class VendorCreatedEventObject {
    private final Optional<String> operation;
    private final Optional<Vendor> vendor;
    private final Map<String, Object> additionalProperties;

    private VendorCreatedEventObject(Optional<String> operation, Optional<Vendor> vendor, Map<String, Object> additionalProperties) {
        this.operation = operation;
        this.vendor = vendor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="operation")
    public Optional<String> getOperation() {
        return this.operation;
    }

    @JsonProperty(value="vendor")
    public Optional<Vendor> getVendor() {
        return this.vendor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof VendorCreatedEventObject && this.equalTo((VendorCreatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(VendorCreatedEventObject other) {
        return this.operation.equals(other.operation) && this.vendor.equals(other.vendor);
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.vendor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> operation = Optional.empty();
        private Optional<Vendor> vendor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(VendorCreatedEventObject other) {
            this.operation(other.getOperation());
            this.vendor(other.getVendor());
            return this;
        }

        @JsonSetter(value="operation", nulls=Nulls.SKIP)
        public Builder operation(Optional<String> operation) {
            this.operation = operation;
            return this;
        }

        public Builder operation(String operation) {
            this.operation = Optional.ofNullable(operation);
            return this;
        }

        @JsonSetter(value="vendor", nulls=Nulls.SKIP)
        public Builder vendor(Optional<Vendor> vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder vendor(Vendor vendor) {
            this.vendor = Optional.ofNullable(vendor);
            return this;
        }

        public VendorCreatedEventObject build() {
            return new VendorCreatedEventObject(this.operation, this.vendor, this.additionalProperties);
        }
    }
}

