/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.V1UpdateOrderRequestAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class V1UpdateOrderRequest {
    private final String locationId;
    private final String orderId;
    private final V1UpdateOrderRequestAction action;
    private final Optional<String> shippedTrackingNumber;
    private final Optional<String> completedNote;
    private final Optional<String> refundedNote;
    private final Optional<String> canceledNote;
    private final Map<String, Object> additionalProperties;

    private V1UpdateOrderRequest(String locationId, String orderId, V1UpdateOrderRequestAction action, Optional<String> shippedTrackingNumber, Optional<String> completedNote, Optional<String> refundedNote, Optional<String> canceledNote, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.orderId = orderId;
        this.action = action;
        this.shippedTrackingNumber = shippedTrackingNumber;
        this.completedNote = completedNote;
        this.refundedNote = refundedNote;
        this.canceledNote = canceledNote;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="action")
    public V1UpdateOrderRequestAction getAction() {
        return this.action;
    }

    @JsonIgnore
    public Optional<String> getShippedTrackingNumber() {
        if (this.shippedTrackingNumber == null) {
            return Optional.empty();
        }
        return this.shippedTrackingNumber;
    }

    @JsonIgnore
    public Optional<String> getCompletedNote() {
        if (this.completedNote == null) {
            return Optional.empty();
        }
        return this.completedNote;
    }

    @JsonIgnore
    public Optional<String> getRefundedNote() {
        if (this.refundedNote == null) {
            return Optional.empty();
        }
        return this.refundedNote;
    }

    @JsonIgnore
    public Optional<String> getCanceledNote() {
        if (this.canceledNote == null) {
            return Optional.empty();
        }
        return this.canceledNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipped_tracking_number")
    private Optional<String> _getShippedTrackingNumber() {
        return this.shippedTrackingNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="completed_note")
    private Optional<String> _getCompletedNote() {
        return this.completedNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="refunded_note")
    private Optional<String> _getRefundedNote() {
        return this.refundedNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="canceled_note")
    private Optional<String> _getCanceledNote() {
        return this.canceledNote;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V1UpdateOrderRequest && this.equalTo((V1UpdateOrderRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V1UpdateOrderRequest other) {
        return this.locationId.equals(other.locationId) && this.orderId.equals(other.orderId) && this.action.equals(other.action) && this.shippedTrackingNumber.equals(other.shippedTrackingNumber) && this.completedNote.equals(other.completedNote) && this.refundedNote.equals(other.refundedNote) && this.canceledNote.equals(other.canceledNote);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.orderId, this.action, this.shippedTrackingNumber, this.completedNote, this.refundedNote, this.canceledNote);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    OrderIdStage,
    ActionStage,
    _FinalStage {
        private String locationId;
        private String orderId;
        private V1UpdateOrderRequestAction action;
        private Optional<String> canceledNote = Optional.empty();
        private Optional<String> refundedNote = Optional.empty();
        private Optional<String> completedNote = Optional.empty();
        private Optional<String> shippedTrackingNumber = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(V1UpdateOrderRequest other) {
            this.locationId(other.getLocationId());
            this.orderId(other.getOrderId());
            this.action(other.getAction());
            this.shippedTrackingNumber(other.getShippedTrackingNumber());
            this.completedNote(other.getCompletedNote());
            this.refundedNote(other.getRefundedNote());
            this.canceledNote(other.getCanceledNote());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public OrderIdStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public ActionStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="action")
        public _FinalStage action(@NotNull V1UpdateOrderRequestAction action) {
            this.action = Objects.requireNonNull(action, "action must not be null");
            return this;
        }

        @Override
        public _FinalStage canceledNote(Nullable<String> canceledNote) {
            this.canceledNote = canceledNote.isNull() ? null : (canceledNote.isEmpty() ? Optional.empty() : Optional.of(canceledNote.get()));
            return this;
        }

        @Override
        public _FinalStage canceledNote(String canceledNote) {
            this.canceledNote = Optional.ofNullable(canceledNote);
            return this;
        }

        @Override
        @JsonSetter(value="canceled_note", nulls=Nulls.SKIP)
        public _FinalStage canceledNote(Optional<String> canceledNote) {
            this.canceledNote = canceledNote;
            return this;
        }

        @Override
        public _FinalStage refundedNote(Nullable<String> refundedNote) {
            this.refundedNote = refundedNote.isNull() ? null : (refundedNote.isEmpty() ? Optional.empty() : Optional.of(refundedNote.get()));
            return this;
        }

        @Override
        public _FinalStage refundedNote(String refundedNote) {
            this.refundedNote = Optional.ofNullable(refundedNote);
            return this;
        }

        @Override
        @JsonSetter(value="refunded_note", nulls=Nulls.SKIP)
        public _FinalStage refundedNote(Optional<String> refundedNote) {
            this.refundedNote = refundedNote;
            return this;
        }

        @Override
        public _FinalStage completedNote(Nullable<String> completedNote) {
            this.completedNote = completedNote.isNull() ? null : (completedNote.isEmpty() ? Optional.empty() : Optional.of(completedNote.get()));
            return this;
        }

        @Override
        public _FinalStage completedNote(String completedNote) {
            this.completedNote = Optional.ofNullable(completedNote);
            return this;
        }

        @Override
        @JsonSetter(value="completed_note", nulls=Nulls.SKIP)
        public _FinalStage completedNote(Optional<String> completedNote) {
            this.completedNote = completedNote;
            return this;
        }

        @Override
        public _FinalStage shippedTrackingNumber(Nullable<String> shippedTrackingNumber) {
            this.shippedTrackingNumber = shippedTrackingNumber.isNull() ? null : (shippedTrackingNumber.isEmpty() ? Optional.empty() : Optional.of(shippedTrackingNumber.get()));
            return this;
        }

        @Override
        public _FinalStage shippedTrackingNumber(String shippedTrackingNumber) {
            this.shippedTrackingNumber = Optional.ofNullable(shippedTrackingNumber);
            return this;
        }

        @Override
        @JsonSetter(value="shipped_tracking_number", nulls=Nulls.SKIP)
        public _FinalStage shippedTrackingNumber(Optional<String> shippedTrackingNumber) {
            this.shippedTrackingNumber = shippedTrackingNumber;
            return this;
        }

        @Override
        public V1UpdateOrderRequest build() {
            return new V1UpdateOrderRequest(this.locationId, this.orderId, this.action, this.shippedTrackingNumber, this.completedNote, this.refundedNote, this.canceledNote, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public V1UpdateOrderRequest build();

        public _FinalStage shippedTrackingNumber(Optional<String> var1);

        public _FinalStage shippedTrackingNumber(String var1);

        public _FinalStage shippedTrackingNumber(Nullable<String> var1);

        public _FinalStage completedNote(Optional<String> var1);

        public _FinalStage completedNote(String var1);

        public _FinalStage completedNote(Nullable<String> var1);

        public _FinalStage refundedNote(Optional<String> var1);

        public _FinalStage refundedNote(String var1);

        public _FinalStage refundedNote(Nullable<String> var1);

        public _FinalStage canceledNote(Optional<String> var1);

        public _FinalStage canceledNote(String var1);

        public _FinalStage canceledNote(Nullable<String> var1);
    }

    public static interface ActionStage {
        public _FinalStage action(@NotNull V1UpdateOrderRequestAction var1);
    }

    public static interface OrderIdStage {
        public ActionStage orderId(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public OrderIdStage locationId(@NotNull String var1);

        public Builder from(V1UpdateOrderRequest var1);
    }
}

