/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class V1OrderState {
    public static final V1OrderState CANCELED = new V1OrderState(Value.CANCELED, "CANCELED");
    public static final V1OrderState REFUNDED = new V1OrderState(Value.REFUNDED, "REFUNDED");
    public static final V1OrderState REJECTED = new V1OrderState(Value.REJECTED, "REJECTED");
    public static final V1OrderState OPEN = new V1OrderState(Value.OPEN, "OPEN");
    public static final V1OrderState COMPLETED = new V1OrderState(Value.COMPLETED, "COMPLETED");
    public static final V1OrderState PENDING = new V1OrderState(Value.PENDING, "PENDING");
    private final Value value;
    private final String string;

    V1OrderState(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof V1OrderState && this.string.equals(((V1OrderState)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CANCELED: {
                return visitor.visitCanceled();
            }
            case REFUNDED: {
                return visitor.visitRefunded();
            }
            case REJECTED: {
                return visitor.visitRejected();
            }
            case OPEN: {
                return visitor.visitOpen();
            }
            case COMPLETED: {
                return visitor.visitCompleted();
            }
            case PENDING: {
                return visitor.visitPending();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static V1OrderState valueOf(String value) {
        switch (value) {
            case "CANCELED": {
                return CANCELED;
            }
            case "REFUNDED": {
                return REFUNDED;
            }
            case "REJECTED": {
                return REJECTED;
            }
            case "OPEN": {
                return OPEN;
            }
            case "COMPLETED": {
                return COMPLETED;
            }
            case "PENDING": {
                return PENDING;
            }
        }
        return new V1OrderState(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitPending();

        public T visitOpen();

        public T visitCompleted();

        public T visitCanceled();

        public T visitRefunded();

        public T visitRejected();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        PENDING,
        OPEN,
        COMPLETED,
        CANCELED,
        REFUNDED,
        REJECTED,
        UNKNOWN;

    }
}

