/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.V1OrderHistoryEntryAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class V1OrderHistoryEntry {
    private final Optional<V1OrderHistoryEntryAction> action;
    private final Optional<String> createdAt;
    private final Map<String, Object> additionalProperties;

    private V1OrderHistoryEntry(Optional<V1OrderHistoryEntryAction> action, Optional<String> createdAt, Map<String, Object> additionalProperties) {
        this.action = action;
        this.createdAt = createdAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="action")
    public Optional<V1OrderHistoryEntryAction> getAction() {
        return this.action;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V1OrderHistoryEntry && this.equalTo((V1OrderHistoryEntry)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V1OrderHistoryEntry other) {
        return this.action.equals(other.action) && this.createdAt.equals(other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.createdAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<V1OrderHistoryEntryAction> action = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(V1OrderHistoryEntry other) {
            this.action(other.getAction());
            this.createdAt(other.getCreatedAt());
            return this;
        }

        @JsonSetter(value="action", nulls=Nulls.SKIP)
        public Builder action(Optional<V1OrderHistoryEntryAction> action) {
            this.action = action;
            return this;
        }

        public Builder action(V1OrderHistoryEntryAction action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        public V1OrderHistoryEntry build() {
            return new V1OrderHistoryEntry(this.action, this.createdAt, this.additionalProperties);
        }
    }
}

