/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Snippet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpsertSnippetRequest {
    private final String siteId;
    private final Snippet snippet;
    private final Map<String, Object> additionalProperties;

    private UpsertSnippetRequest(String siteId, Snippet snippet, Map<String, Object> additionalProperties) {
        this.siteId = siteId;
        this.snippet = snippet;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="site_id")
    public String getSiteId() {
        return this.siteId;
    }

    @JsonProperty(value="snippet")
    public Snippet getSnippet() {
        return this.snippet;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpsertSnippetRequest && this.equalTo((UpsertSnippetRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpsertSnippetRequest other) {
        return this.siteId.equals(other.siteId) && this.snippet.equals(other.snippet);
    }

    public int hashCode() {
        return Objects.hash(this.siteId, this.snippet);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SiteIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SiteIdStage,
    SnippetStage,
    _FinalStage {
        private String siteId;
        private Snippet snippet;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpsertSnippetRequest other) {
            this.siteId(other.getSiteId());
            this.snippet(other.getSnippet());
            return this;
        }

        @Override
        @JsonSetter(value="site_id")
        public SnippetStage siteId(@NotNull String siteId) {
            this.siteId = Objects.requireNonNull(siteId, "siteId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="snippet")
        public _FinalStage snippet(@NotNull Snippet snippet) {
            this.snippet = Objects.requireNonNull(snippet, "snippet must not be null");
            return this;
        }

        @Override
        public UpsertSnippetRequest build() {
            return new UpsertSnippetRequest(this.siteId, this.snippet, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpsertSnippetRequest build();
    }

    public static interface SnippetStage {
        public _FinalStage snippet(@NotNull Snippet var1);
    }

    public static interface SiteIdStage {
        public SnippetStage siteId(@NotNull String var1);

        public Builder from(UpsertSnippetRequest var1);
    }
}

