/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Timecard;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateTimecardRequest {
    private final String id;
    private final Timecard timecard;
    private final Map<String, Object> additionalProperties;

    private UpdateTimecardRequest(String id, Timecard timecard, Map<String, Object> additionalProperties) {
        this.id = id;
        this.timecard = timecard;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="timecard")
    public Timecard getTimecard() {
        return this.timecard;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateTimecardRequest && this.equalTo((UpdateTimecardRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTimecardRequest other) {
        return this.id.equals(other.id) && this.timecard.equals(other.timecard);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.timecard);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TimecardStage,
    _FinalStage {
        private String id;
        private Timecard timecard;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateTimecardRequest other) {
            this.id(other.getId());
            this.timecard(other.getTimecard());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TimecardStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="timecard")
        public _FinalStage timecard(@NotNull Timecard timecard) {
            this.timecard = Objects.requireNonNull(timecard, "timecard must not be null");
            return this;
        }

        @Override
        public UpdateTimecardRequest build() {
            return new UpdateTimecardRequest(this.id, this.timecard, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateTimecardRequest build();
    }

    public static interface TimecardStage {
        public _FinalStage timecard(@NotNull Timecard var1);
    }

    public static interface IdStage {
        public TimecardStage id(@NotNull String var1);

        public Builder from(UpdateTimecardRequest var1);
    }
}

