/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.UpdateTeamMemberRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateTeamMembersRequest {
    private final String teamMemberId;
    private final UpdateTeamMemberRequest body;
    private final Map<String, Object> additionalProperties;

    private UpdateTeamMembersRequest(String teamMemberId, UpdateTeamMemberRequest body, Map<String, Object> additionalProperties) {
        this.teamMemberId = teamMemberId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="team_member_id")
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonProperty(value="body")
    public UpdateTeamMemberRequest getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateTeamMembersRequest && this.equalTo((UpdateTeamMembersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTeamMembersRequest other) {
        return this.teamMemberId.equals(other.teamMemberId) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.teamMemberId, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TeamMemberIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TeamMemberIdStage,
    BodyStage,
    _FinalStage {
        private String teamMemberId;
        private UpdateTeamMemberRequest body;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateTeamMembersRequest other) {
            this.teamMemberId(other.getTeamMemberId());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="team_member_id")
        public BodyStage teamMemberId(@NotNull String teamMemberId) {
            this.teamMemberId = Objects.requireNonNull(teamMemberId, "teamMemberId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull UpdateTeamMemberRequest body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public UpdateTeamMembersRequest build() {
            return new UpdateTeamMembersRequest(this.teamMemberId, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateTeamMembersRequest build();
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull UpdateTeamMemberRequest var1);
    }

    public static interface TeamMemberIdStage {
        public BodyStage teamMemberId(@NotNull String var1);

        public Builder from(UpdateTeamMembersRequest var1);
    }
}

