/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateItemModifierListsRequest {
    private final List<String> itemIds;
    private final Optional<List<String>> modifierListsToEnable;
    private final Optional<List<String>> modifierListsToDisable;
    private final Map<String, Object> additionalProperties;

    private UpdateItemModifierListsRequest(List<String> itemIds, Optional<List<String>> modifierListsToEnable, Optional<List<String>> modifierListsToDisable, Map<String, Object> additionalProperties) {
        this.itemIds = itemIds;
        this.modifierListsToEnable = modifierListsToEnable;
        this.modifierListsToDisable = modifierListsToDisable;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="item_ids")
    public List<String> getItemIds() {
        return this.itemIds;
    }

    @JsonIgnore
    public Optional<List<String>> getModifierListsToEnable() {
        if (this.modifierListsToEnable == null) {
            return Optional.empty();
        }
        return this.modifierListsToEnable;
    }

    @JsonIgnore
    public Optional<List<String>> getModifierListsToDisable() {
        if (this.modifierListsToDisable == null) {
            return Optional.empty();
        }
        return this.modifierListsToDisable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="modifier_lists_to_enable")
    private Optional<List<String>> _getModifierListsToEnable() {
        return this.modifierListsToEnable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="modifier_lists_to_disable")
    private Optional<List<String>> _getModifierListsToDisable() {
        return this.modifierListsToDisable;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateItemModifierListsRequest && this.equalTo((UpdateItemModifierListsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateItemModifierListsRequest other) {
        return this.itemIds.equals(other.itemIds) && this.modifierListsToEnable.equals(other.modifierListsToEnable) && this.modifierListsToDisable.equals(other.modifierListsToDisable);
    }

    public int hashCode() {
        return Objects.hash(this.itemIds, this.modifierListsToEnable, this.modifierListsToDisable);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> itemIds = new ArrayList<String>();
        private Optional<List<String>> modifierListsToEnable = Optional.empty();
        private Optional<List<String>> modifierListsToDisable = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateItemModifierListsRequest other) {
            this.itemIds(other.getItemIds());
            this.modifierListsToEnable(other.getModifierListsToEnable());
            this.modifierListsToDisable(other.getModifierListsToDisable());
            return this;
        }

        @JsonSetter(value="item_ids", nulls=Nulls.SKIP)
        public Builder itemIds(List<String> itemIds) {
            this.itemIds.clear();
            this.itemIds.addAll(itemIds);
            return this;
        }

        public Builder addItemIds(String itemIds) {
            this.itemIds.add(itemIds);
            return this;
        }

        public Builder addAllItemIds(List<String> itemIds) {
            this.itemIds.addAll(itemIds);
            return this;
        }

        @JsonSetter(value="modifier_lists_to_enable", nulls=Nulls.SKIP)
        public Builder modifierListsToEnable(Optional<List<String>> modifierListsToEnable) {
            this.modifierListsToEnable = modifierListsToEnable;
            return this;
        }

        public Builder modifierListsToEnable(List<String> modifierListsToEnable) {
            this.modifierListsToEnable = Optional.ofNullable(modifierListsToEnable);
            return this;
        }

        public Builder modifierListsToEnable(Nullable<List<String>> modifierListsToEnable) {
            this.modifierListsToEnable = modifierListsToEnable.isNull() ? null : (modifierListsToEnable.isEmpty() ? Optional.empty() : Optional.of(modifierListsToEnable.get()));
            return this;
        }

        @JsonSetter(value="modifier_lists_to_disable", nulls=Nulls.SKIP)
        public Builder modifierListsToDisable(Optional<List<String>> modifierListsToDisable) {
            this.modifierListsToDisable = modifierListsToDisable;
            return this;
        }

        public Builder modifierListsToDisable(List<String> modifierListsToDisable) {
            this.modifierListsToDisable = Optional.ofNullable(modifierListsToDisable);
            return this;
        }

        public Builder modifierListsToDisable(Nullable<List<String>> modifierListsToDisable) {
            this.modifierListsToDisable = modifierListsToDisable.isNull() ? null : (modifierListsToDisable.isEmpty() ? Optional.empty() : Optional.of(modifierListsToDisable.get()));
            return this;
        }

        public UpdateItemModifierListsRequest build() {
            return new UpdateItemModifierListsRequest(this.itemIds, this.modifierListsToEnable, this.modifierListsToDisable, this.additionalProperties);
        }
    }
}

